/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin.report;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.LocalProxyRbelMessageListener;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.exceptions.TigerOsException;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.proxy.data.MessageMetaDataDto;
import de.gematik.test.tiger.testenvmgr.env.FeatureUpdate;
import de.gematik.test.tiger.testenvmgr.env.ScenarioUpdate;
import de.gematik.test.tiger.testenvmgr.env.StepUpdate;
import de.gematik.test.tiger.testenvmgr.env.TestResult;
import de.gematik.test.tiger.testenvmgr.env.TigerStatusUpdate;
import io.cucumber.core.plugin.FeatureFileLoader;
import io.cucumber.core.plugin.ScenarioContextDelegate;
import io.cucumber.core.plugin.report.EvidenceRecorder;
import io.cucumber.core.plugin.report.EvidenceRecorderFactory;
import io.cucumber.core.plugin.report.EvidenceRenderer;
import io.cucumber.core.plugin.report.EvidenceReport;
import io.cucumber.core.plugin.report.FeatureExecutionMonitor;
import io.cucumber.core.plugin.report.HtmlEvidenceRenderer;
import io.cucumber.core.plugin.report.LocationConverter;
import io.cucumber.core.plugin.report.ReportStepConfiguration;
import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableRow;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.serenitybdd.core.Serenity;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.awaitility.Awaitility;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityReporterCallbacks {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SerenityReporterCallbacks.class);
    public static final String TARGET_DIR = "target";
    private static final Object startupMutex = new Object();
    private static RuntimeException tigerStartupFailedException;
    private static boolean pauseMode;
    private final Pattern showSteps = Pattern.compile(".*TGR (zeige|show) ([\\w|\u00fc\u00df ]*)(Banner|banner|text|Text) \"(.*)\"");
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private final EvidenceRecorder evidenceRecorder = EvidenceRecorderFactory.getEvidenceRecorder();
    private final EvidenceRenderer evidenceRenderer = new EvidenceRenderer(new HtmlEvidenceRenderer());
    FeatureFileLoader featureLoader = new FeatureFileLoader();
    private int currentScenarioDataVariantIndex = -1;
    private String currentScenarioID = "";
    private int currentStepIndex = -1;
    private int scPassed = 0;
    private int scFailed = 0;
    private final FeatureExecutionMonitor featureExecutionMonitor = new FeatureExecutionMonitor();

    @NotNull
    private static Path getEvidenceDir() throws IOException {
        Path parentDir = Path.of(TARGET_DIR, "evidences");
        if (Files.notExists(parentDir, new LinkOption[0])) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        return parentDir;
    }

    public void handleTestSourceRead(Event event) {
        this.featureLoader.addTestSourceReadEvent((TestSourceRead)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTestRunStarted(Event ignoredEvent, ScenarioContextDelegate ignoredContext) {
        Object object = startupMutex;
        synchronized (object) {
            if (TigerDirector.isInitialized()) {
                return;
            }
            this.showTigerVersion();
            this.initializeTiger();
            TigerDirector.assertThatTigerIsInitialized();
            this.shouldAbortTestExecution();
            this.featureExecutionMonitor.startTestRun();
        }
    }

    public void handleTestRunFinished(TestRunFinished ignoredEvent, ScenarioContextDelegate ignoredContext) {
        this.featureExecutionMonitor.stopTestRun();
    }

    private void showTigerVersion() {
        log.info(Ansi.colorize((String)("Starting Tiger version " + this.getTigerVersionString()), (RbelAnsiColors)RbelAnsiColors.GREEN_BRIGHT));
    }

    private String getTigerVersionString() {
        try {
            Properties p = new Properties();
            p.load(SerenityReporterCallbacks.class.getResourceAsStream("/build.properties"));
            String version = p.getProperty("tiger.version");
            if (version.equals("${project.version}")) {
                version = "UNKNOWN";
            }
            return version + "-" + p.getProperty("tiger.build.timestamp");
        }
        catch (IOException | RuntimeException ignored) {
            return "UNKNOWN";
        }
    }

    private synchronized void initializeTiger() {
        if (tigerStartupFailedException != null) {
            return;
        }
        try {
            TigerDirector.registerShutdownHook();
            TigerDirector.start();
        }
        catch (RuntimeException rte) {
            tigerStartupFailedException = rte;
            throw tigerStartupFailedException;
        }
    }

    public void handleTestCaseStarted(TestCaseStarted testCaseStartedEvent, ScenarioContextDelegate context) {
        this.shouldAbortTestExecution();
        Optional<Feature> currentFeature = this.featureFrom(context.currentFeaturePath());
        if (StringUtils.isEmpty((CharSequence)this.currentScenarioID)) {
            this.currentScenarioID = context.getCurrentScenarioId();
        }
        if (context.getCurrentScenarioId() != null && !context.getCurrentScenarioId().equals(this.currentScenarioID)) {
            this.currentScenarioDataVariantIndex = -1;
            this.currentScenarioID = context.getCurrentScenarioId();
        }
        if (context.isAScenarioOutline()) {
            this.currentScenarioDataVariantIndex = this.extractScenarioDataVariantIndex(testCaseStartedEvent, context);
        } else {
            this.currentScenarioDataVariantIndex = -1;
            this.currentScenarioID = context.getCurrentScenarioId();
        }
        this.currentStepIndex = 0;
        currentFeature.ifPresent(feature -> this.informWorkflowUiAboutCurrentScenario((Feature)feature, context));
        this.evidenceRecorder.reset();
        this.featureExecutionMonitor.startTestCase(testCaseStartedEvent);
    }

    private int extractScenarioDataVariantIndex(TestCaseStarted event, ScenarioContextDelegate context) {
        LocationConverter converter = new LocationConverter();
        List<Location> exampleLocations = context.currentScenarioOutline().getExamples().stream().flatMap(e -> e.getTableBody().stream()).map(TableRow::getLocation).toList();
        return exampleLocations.indexOf(converter.convertLocation(event.getTestCase().getLocation()));
    }

    private Optional<Feature> featureFrom(URI currentFeaturePath) {
        return Optional.ofNullable(this.featureLoader.getFeature(currentFeaturePath));
    }

    private List<Step> getStepsIncludingBackgroundFromFeatureForScenario(Feature feature, Scenario scenario) {
        ArrayList<Step> steps = new ArrayList<Step>();
        feature.getChildren().stream().filter(child -> child.getBackground().isPresent()).map(child -> (Background)child.getBackground().get()).forEach(background -> steps.addAll(background.getSteps()));
        steps.addAll(scenario.getSteps());
        return steps;
    }

    private void informWorkflowUiAboutCurrentScenario(Feature feature, ScenarioContextDelegate context) {
        Scenario scenario = context.getCurrentScenarioDefinition();
        List<Step> steps = this.getStepsIncludingBackgroundFromFeatureForScenario(feature, scenario);
        log.info("Scenario location {}", (Object)scenario.getLocation());
        Map<String, String> variantDataMap = this.getVariantDataMap(context);
        log.debug("Current row for scenario variant {} {}", (Object)this.currentScenarioDataVariantIndex, variantDataMap);
        TigerDirector.getTigerTestEnvMgr().receiveTestEnvUpdate(TigerStatusUpdate.builder().featureMap(new LinkedHashMap<String, FeatureUpdate>(Map.of(feature.getName(), FeatureUpdate.builder().description(feature.getName()).scenarios(new LinkedHashMap<String, ScenarioUpdate>(Map.of(this.mapScenarioToScenarioUpdateMap(scenario, context.isAScenarioOutline()), ScenarioUpdate.builder().description(this.replaceLineWithCurrentDataVariantValues(scenario.getName(), variantDataMap)).location(scenario.getLocation()).uri(context.currentFeaturePath()).variantIndex(this.currentScenarioDataVariantIndex).exampleKeys(context.isAScenarioOutline() ? context.getTable().getHeaders() : null).exampleList(variantDataMap).steps(this.mapStepsToStepUpdateMap(steps, line -> this.replaceLineWithCurrentDataVariantValues((String)line, variantDataMap))).build()))).build()))).build());
    }

    private Map<String, String> getVariantDataMap(ScenarioContextDelegate context) {
        return context.isAScenarioOutline() ? context.getTable().row(this.currentScenarioDataVariantIndex).toStringMap() : Map.of();
    }

    private String mapScenarioToScenarioUpdateMap(Scenario scenario, boolean outline) {
        if (outline) {
            return this.currentScenarioDataVariantIndex + "-" + scenario.getId();
        }
        return scenario.getId();
    }

    private String replaceLineWithCurrentDataVariantValues(String line, Map<String, String> variantDataMap) {
        if (variantDataMap == null) {
            return line;
        }
        String parsedLine = line;
        for (Map.Entry<String, String> entry : variantDataMap.entrySet()) {
            parsedLine = parsedLine.replace("<" + entry.getKey() + ">", "<" + entry.getValue() + ">");
        }
        return parsedLine;
    }

    private String getStepDescription(Step step) {
        StringBuilder stepText = new StringBuilder(step.getKeyword()).append(StringEscapeUtils.escapeHtml4((String)step.getText()));
        step.getDocString().ifPresent(docStr -> stepText.append("<div class=\"steps-docstring\">").append(StringEscapeUtils.escapeHtml4((String)docStr.getContent())).append("</div>"));
        step.getDataTable().ifPresent(dataTable -> {
            stepText.append("<br/><table class=\"table table-sm table-data-table\">");
            dataTable.getRows().forEach(row -> {
                stepText.append("<tr>");
                row.getCells().forEach(cell -> stepText.append("<td>").append(StringEscapeUtils.escapeHtml4((String)cell.getValue())).append("</td>"));
                stepText.append("</tr>");
            });
            stepText.append("</table>");
        });
        return stepText.toString();
    }

    private Map<String, StepUpdate> mapStepsToStepUpdateMap(List<Step> steps, UnaryOperator<String> postProduction) {
        LinkedHashMap<String, StepUpdate> map = new LinkedHashMap<String, StepUpdate>();
        for (int stepIndex = 0; stepIndex < steps.size(); ++stepIndex) {
            if (map.put(Integer.toString(stepIndex), StepUpdate.builder().description((String)postProduction.apply(this.getStepDescription(steps.get(stepIndex)))).status(TestResult.PENDING).stepIndex(stepIndex).build()) == null) continue;
            throw new IllegalStateException("Duplicate key");
        }
        return map;
    }

    public void handleTestStepStarted(Event event, ScenarioContextDelegate context) {
        TestStep testStep;
        this.shouldWaitIfInPauseMode();
        this.shouldAbortTestExecution();
        TestStepStarted tssEvent = (TestStepStarted)event;
        if (!(tssEvent.getTestStep() instanceof HookTestStep) && (testStep = tssEvent.getTestStep()) instanceof PickleStepTestStep) {
            PickleStepTestStep pickleTestStep = (PickleStepTestStep)testStep;
            this.informWorkflowUiAboutCurrentStep((TestStep)pickleTestStep, "EXECUTING", context);
        }
        if (context.getCurrentStep() != null) {
            this.evidenceRecorder.openStepContext(new ReportStepConfiguration(this.getStepDescription(context.getCurrentStep())));
        }
    }

    private void addBannerMessageToUpdate(Map<String, String> variantDataMap, PickleStepTestStep pickleTestStep, TigerStatusUpdate.TigerStatusUpdateBuilder statusUpdateBuilder) {
        Matcher m = this.showSteps.matcher(pickleTestStep.getStep().getText());
        if (m.find()) {
            Color col;
            String colStr = this.replaceLineWithCurrentDataVariantValues(m.group(2), variantDataMap).trim();
            try {
                col = !colStr.isEmpty() ? (Color)Color.class.getDeclaredField(RbelAnsiColors.seekColor((String)colStr).name().toUpperCase()).get(null) : Color.BLACK;
            }
            catch (Exception ignored) {
                col = Color.BLACK;
            }
            statusUpdateBuilder.bannerColor(String.format("#%06X", 0xFFFFFF & col.getRGB())).bannerMessage(TigerGlobalConfiguration.resolvePlaceholders((String)this.replaceLineWithCurrentDataVariantValues(m.group(4), variantDataMap)));
        }
    }

    public void handleTestStepFinished(Event event, ScenarioContextDelegate context) {
        if (TigerDirector.getTigerTestEnvMgr().isShouldAbortTestExecution()) {
            return;
        }
        TestStepFinished tsfEvent = (TestStepFinished)event;
        if (!(tsfEvent.getTestStep() instanceof HookTestStep)) {
            if (TigerDirector.getLibConfig().isAddCurlCommandsForRaCallsToReport() && TigerDirector.isSerenityAvailable() && TigerDirector.getCurlLoggingFilter() != null) {
                TigerDirector.getCurlLoggingFilter().printToReport();
            }
            if (context.getCurrentStep() != null) {
                this.informWorkflowUiAboutCurrentStep(tsfEvent.getTestStep(), ((TestStepFinished)event).getResult().getStatus().name(), context);
                if (TigerDirector.isSerenityAvailable()) {
                    this.addStepEvidence();
                }
            }
            ++this.currentStepIndex;
        }
    }

    private void addStepEvidence() {
        this.evidenceRecorder.getCurrentStep().ifPresent(step -> step.getEvidenceEntries().forEach(entry -> Serenity.recordReportData().asEvidence().withTitle(entry.getType() + " - " + entry.getTitle()).andContents(new JSONObject(entry.getDetails()).toString(2))));
    }

    private void informWorkflowUiAboutCurrentStep(TestStep event, String status, ScenarioContextDelegate context) {
        Scenario scenario = context.getCurrentScenarioDefinition();
        PickleStepTestStep pickleTestStep = (PickleStepTestStep)event;
        TigerStatusUpdate.TigerStatusUpdateBuilder builder = TigerStatusUpdate.builder();
        String featureName = this.featureFrom(context.currentFeaturePath()).map(Feature::getName).orElse("?");
        List<MessageMetaDataDto> stepMessagesMetaDataList = new ArrayList<RbelElement>(LocalProxyRbelMessageListener.getStepRbelMessages()).stream().map(MessageMetaDataDto::createFrom).toList();
        Map<String, String> variantDataMap = this.getVariantDataMap(context);
        this.addBannerMessageToUpdate(variantDataMap, pickleTestStep, builder);
        TigerDirector.getTigerTestEnvMgr().receiveTestEnvUpdate(builder.featureMap(new LinkedHashMap<String, FeatureUpdate>(Map.of(featureName, FeatureUpdate.builder().description(featureName).scenarios(new LinkedHashMap<String, ScenarioUpdate>(Map.of(this.mapScenarioToScenarioUpdateMap(scenario, context.isAScenarioOutline()), ScenarioUpdate.builder().description(this.replaceLineWithCurrentDataVariantValues(scenario.getName(), variantDataMap)).uri(context.currentFeaturePath()).location(scenario.getLocation()).variantIndex(this.currentScenarioDataVariantIndex).steps(new HashMap<String, StepUpdate>(Map.of(String.valueOf(this.currentStepIndex), StepUpdate.builder().description(this.replaceLineWithCurrentDataVariantValues(this.getStepDescription(context.getCurrentStep()), variantDataMap)).status(TestResult.valueOf((String)status)).stepIndex(this.currentStepIndex).rbelMetaData(stepMessagesMetaDataList).build()))).build()))).build()))).build());
        LocalProxyRbelMessageListener.getStepRbelMessages().clear();
    }

    public void handleTestCaseFinished(TestCaseFinished event, ScenarioContextDelegate context) {
        String scenarioStatus;
        if (TigerDirector.getTigerTestEnvMgr().isShouldAbortTestExecution()) {
            return;
        }
        this.currentStepIndex = -1;
        switch (scenarioStatus = event.getResult().getStatus().toString()) {
            case "PASSED": {
                ++this.scPassed;
                break;
            }
            case "ERROR": 
            case "FAILED": {
                ++this.scFailed;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported scenario: %s".formatted(scenarioStatus));
            }
        }
        log.info("------------ STATUS: {} passed {}", (Object)this.scPassed, this.scFailed > 0 ? this.scFailed + " failed or error" : "");
        if (TigerDirector.getLibConfig().createRbelHtmlReports) {
            this.createRbelLogReport(event.getTestCase().getName(), event.getTestCase().getUri());
        }
        this.createEvidenceFile(event, context);
        TigerGlobalConfiguration.clearLocalTestVariables();
    }

    private void createEvidenceFile(TestCaseFinished testCaseFinishedEvent, ScenarioContextDelegate scenarioContext) {
        EvidenceReport evidenceReport = this.getEvidenceReport(testCaseFinishedEvent, scenarioContext);
        if (evidenceReport.getSteps().stream().anyMatch(step -> !step.getEvidenceEntries().isEmpty())) {
            Path reportFile = this.createEvidenceReportFile(scenarioContext, evidenceReport);
            if (TigerDirector.isSerenityAvailable()) {
                Serenity.recordReportData().asEvidence().withTitle("Evidence Report").downloadable().fromFile(reportFile);
            }
        }
    }

    @NotNull
    private Path createEvidenceReportFile(ScenarioContextDelegate scenarioContext, EvidenceReport evidenceReport) throws IOException {
        String renderedReport = this.evidenceRenderer.render(evidenceReport);
        Path parentDir = SerenityReporterCallbacks.getEvidenceDir();
        return Files.writeString(parentDir.resolve(this.getFileNameFor("evidence", scenarioContext.getScenarioName(), this.currentScenarioDataVariantIndex)), (CharSequence)renderedReport, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private EvidenceReport getEvidenceReport(TestCaseFinished testCaseFinishedEvent, ScenarioContextDelegate scenarioContext) {
        return this.evidenceRecorder.getEvidenceReportForScenario(new EvidenceReport.ReportContext(scenarioContext.getScenarioName(), testCaseFinishedEvent.getTestCase().getUri()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRbelLogReport(String scenarioName, URI scenarioUri) {
        try {
            File folder = Paths.get(TARGET_DIR, "rbellogs").toFile();
            if (!folder.exists() && !folder.mkdirs()) {
                throw new TigerOsException("Unable to create folder '" + folder.getAbsolutePath() + "'");
            }
            RbelHtmlRenderer rbelRenderer = this.getRbelHtmlRenderer(scenarioName, scenarioUri);
            String html = rbelRenderer.doRender(LocalProxyRbelMessageListener.getMessages());
            String name = this.getFileNameFor("rbel", scenarioName, this.currentScenarioDataVariantIndex);
            File logFile = Paths.get(TARGET_DIR, "rbellogs", name).toFile();
            FileUtils.writeStringToFile((File)logFile, (String)html, (Charset)StandardCharsets.UTF_8);
            if (TigerDirector.isSerenityAvailable()) {
                Serenity.recordReportData().asEvidence().withTitle("RBellog " + (this.currentScenarioDataVariantIndex + 1)).downloadable().fromFile(logFile.toPath());
            }
            log.info("Saved HTML report of scenario '{}' to {}", (Object)scenarioName, (Object)logFile.getAbsolutePath());
        }
        catch (Exception e) {
            log.error("Unable to create/save rbel log for scenario " + scenarioName, (Throwable)e);
        }
        finally {
            LocalProxyRbelMessageListener.clearMessages();
        }
    }

    @NotNull
    private RbelHtmlRenderer getRbelHtmlRenderer(String scenarioName, URI scenarioUri) {
        RbelHtmlRenderer rbelRenderer = new RbelHtmlRenderer();
        rbelRenderer.setTitle(scenarioName);
        rbelRenderer.setSubTitle("<p>" + (String)(this.currentScenarioDataVariantIndex != -1 ? "<button class=\"js-modal-trigger\" data-bs-target=\"modal-data-variant\">Variant " + (this.currentScenarioDataVariantIndex + 1) + "</button>" : "") + "</p><p><i>" + scenarioUri + "</i></p>");
        rbelRenderer.setVersionInfo(this.getTigerVersionString());
        return rbelRenderer;
    }

    public String getFileNameFor(String type, String scenarioName, int dataVariantIndex) {
        if (((String)scenarioName).length() > 80) {
            scenarioName = ((String)scenarioName).substring(0, 60) + UUID.nameUUIDFromBytes(((String)scenarioName).getBytes(StandardCharsets.UTF_8));
        }
        if (dataVariantIndex != -1) {
            scenarioName = (String)scenarioName + "_" + (dataVariantIndex + 1);
        }
        scenarioName = type + "_" + this.replaceSpecialCharacters((String)scenarioName) + "_" + this.sdf.format(new Date()) + ".html";
        return scenarioName;
    }

    public String replaceSpecialCharacters(String name) {
        String result = name;
        String[] tokenMap = new String[]{"\u00e4", "ae", "\u00c4", "Ae", "\u00f6", "oe", "\u00d6", "Oe", "\u00fc", "ue", "\u00dc", "Ue", "\u00df", "s", " ", "_", "(", "_", ")", "_", "[", "_", "]", "_", "{", "_", "}", "_", "<", "_", ">", "_", "|", "_", "$", "_", "%", "_", "&", "_", "/", "_", "\\", "_", "?", "_", ":", "_", "*", "_", "\"", "_"};
        for (int i = 0; i < tokenMap.length; i += 2) {
            result = result.replace(tokenMap[i], tokenMap[i + 1]);
        }
        return result;
    }

    private void shouldAbortTestExecution() {
        if (TigerDirector.getTigerTestEnvMgr().isShouldAbortTestExecution()) {
            throw new AssertionError((Object)"Aborted test execution on user request");
        }
    }

    private void shouldWaitIfInPauseMode() {
        if (SerenityReporterCallbacks.isPauseMode()) {
            log.info("Test run is paused, via Workflow Ui pause button...");
            Awaitility.await().pollDelay(500L, TimeUnit.MILLISECONDS).atMost(TigerDirector.getLibConfig().getPauseExecutionTimeoutSeconds(), TimeUnit.SECONDS).until(() -> !SerenityReporterCallbacks.isPauseMode() || TigerDirector.getTigerTestEnvMgr().isShouldAbortTestExecution());
            log.info("Test run commencing...");
        }
    }

    @Generated
    public static boolean isPauseMode() {
        return pauseMode;
    }

    @Generated
    public static void setPauseMode(boolean pauseMode) {
        SerenityReporterCallbacks.pauseMode = pauseMode;
    }

    @Generated
    public int getCurrentScenarioDataVariantIndex() {
        return this.currentScenarioDataVariantIndex;
    }

    @Generated
    public int getScPassed() {
        return this.scPassed;
    }

    @Generated
    public int getScFailed() {
        return this.scFailed;
    }
}

