/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin.report;

import freemarker.core.HTMLOutputFormat;
import freemarker.core.OutputFormat;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModel;
import io.cucumber.core.plugin.report.EvidenceReport;
import io.cucumber.core.plugin.report.EvidenceReportJsonConverter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.TimeZone;

public class HtmlEvidenceRenderer {
    private final Configuration freemarkerConfiguration = new Configuration(Configuration.VERSION_2_3_32);

    public HtmlEvidenceRenderer() {
        this.freemarkerConfiguration.setClassLoaderForTemplateLoading(this.getClass().getClassLoader(), "/" + this.getClass().getPackageName().replace('.', '/') + "/templates");
        this.freemarkerConfiguration.setDefaultEncoding("UTF-8");
        this.freemarkerConfiguration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.freemarkerConfiguration.setLogTemplateExceptions(false);
        this.freemarkerConfiguration.setWrapUncheckedExceptions(true);
        this.freemarkerConfiguration.setFallbackOnNullLoopVariable(false);
        this.freemarkerConfiguration.setSQLDateAndTimeTimeZone(TimeZone.getDefault());
        this.freemarkerConfiguration.setAutoEscapingPolicy(22);
        this.freemarkerConfiguration.setOutputFormat((OutputFormat)HTMLOutputFormat.INSTANCE);
    }

    public String render(EvidenceReport report) throws IOException {
        Template reportTemplate = this.freemarkerConfiguration.getTemplate("EvidenceReport.ftl");
        try {
            BeansWrapper wrapper = new BeansWrapperBuilder(Configuration.VERSION_2_3_32).build();
            TemplateHashModel staticModels = wrapper.getStaticModels();
            TemplateHashModel me = (TemplateHashModel)staticModels.get(EvidenceReportJsonConverter.class.getName());
            StringWriter resultContainer = new StringWriter();
            reportTemplate.process(Map.of("report", report, "jsonConverter", me), (Writer)resultContainer);
            return resultContainer.toString();
        }
        catch (TemplateException e) {
            throw new IOException("Error processing Evidence Template", e);
        }
    }
}

