/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.options.CommandlineOptionsParser;
import io.cucumber.core.options.CucumberProperties;
import io.cucumber.core.options.CucumberPropertiesParser;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.options.RuntimeOptionsBuilder;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.TigerSerenityReporterPlugin;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.runtime.ExitStatus;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.core.runtime.FeatureSupplier;
import io.cucumber.core.runtime.Runtime;
import io.cucumber.core.runtime.ThreadLocalRunnerSupplier;
import io.cucumber.core.runtime.TimeServiceEventBus;
import io.cucumber.junit.Assertions;
import io.cucumber.junit.CucumberSerenityBaseRunner;
import io.cucumber.junit.JUnitOptions;
import io.cucumber.junit.LiteralExpression;
import io.cucumber.plugin.Plugin;
import io.cucumber.tagexpressions.Expression;
import java.io.OutputStream;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.Generated;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.webdriver.Configuration;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerCucumberRunner
extends CucumberSerenityBaseRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerCucumberRunner.class);

    public static void main(String[] argv) {
        log.info("Starting TigerSerenityRunner.main()...");
        Supplier<ClassLoader> classLoaderSupplier = ClassLoaders::getDefaultClassLoader;
        byte exitstatus = TigerCucumberRunner.run(argv, classLoaderSupplier);
        System.exit(exitstatus);
    }

    public static byte run(String[] argv, Supplier<ClassLoader> classLoaderSupplier) {
        ArrayList<String> argvList = new ArrayList<String>(Arrays.asList(argv));
        int index = argvList.indexOf("--tags");
        if (index <= 0) {
            argvList.add("--tags");
            argvList.add("not @Ignore");
        }
        String[] arr = argvList.toArray(new String[argvList.size()]);
        RuntimeOptions cmdLineOptions = new CommandlineOptionsParser((OutputStream)System.out).parse(arr).build();
        RuntimeOptions runtimeOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromSystemProperties()).enablePublishPlugin().build(cmdLineOptions);
        TigerCucumberRunner.setRuntimeOptions((RuntimeOptions)runtimeOptions);
        Runtime runtime = TigerCucumberRunner.using(classLoaderSupplier, runtimeOptions);
        runtime.run();
        return runtime.exitStatus();
    }

    public static Runtime using(Supplier<ClassLoader> classLoaderSupplier, RuntimeOptions runtimeOptions) {
        Configuration systemConfiguration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        return TigerCucumberRunner.createTigerSerenityEnabledRuntime(classLoaderSupplier, runtimeOptions, systemConfiguration);
    }

    public static Runtime createTigerSerenityEnabledRuntime(Supplier<ClassLoader> classLoaderSupplier, RuntimeOptions runtimeOptions, Configuration systemConfiguration) {
        RuntimeOptionsBuilder runtimeOptionsBuilder = new RuntimeOptionsBuilder();
        Collection allTagFilters = TigerCucumberRunner.environmentSpecifiedTags((List)runtimeOptions.getTagExpressions());
        for (String tagFilter : allTagFilters) {
            runtimeOptionsBuilder.addTagFilter((Expression)new LiteralExpression(tagFilter));
        }
        runtimeOptionsBuilder.build(runtimeOptions);
        TigerCucumberRunner.setRuntimeOptions((RuntimeOptions)runtimeOptions);
        TimeServiceEventBus bus = new TimeServiceEventBus(Clock.systemUTC(), UUID::randomUUID);
        FeatureParser parser = new FeatureParser(() -> ((EventBus)bus).generateId());
        FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(classLoaderSupplier, (io.cucumber.core.feature.Options)runtimeOptions, parser);
        TigerSerenityReporterPlugin reporter = new TigerSerenityReporterPlugin(systemConfiguration);
        return Runtime.builder().withClassLoader(classLoaderSupplier).withRuntimeOptions(runtimeOptions).withAdditionalPlugins(new Plugin[]{reporter}).withEventBus((EventBus)bus).withFeatureSupplier((FeatureSupplier)featureSupplier).build();
    }

    public TigerCucumberRunner(Class clazz) throws InitializationError {
        super(clazz);
        Assertions.assertNoCucumberAnnotatedMethods((Class)clazz);
        RuntimeOptions runtimeOptions = this.createRuntimeOptions(clazz);
        log.info("Tag filters {}", (Object)runtimeOptions.getTagExpressions());
        JUnitOptions junitOptions = this.createJUnitOptions(clazz);
        this.initializeBus();
        TigerCucumberRunner.setRuntimeOptions((RuntimeOptions)runtimeOptions);
        this.parseFeaturesEarly();
        this.initiatePluginsList(runtimeOptions);
        ExitStatus exitStatus = new ExitStatus((Options)runtimeOptions);
        this.addPlugin((Plugin)exitStatus);
        ThreadLocalRunnerSupplier runnerSupplier = this.initializeServices(clazz, runtimeOptions);
        Configuration systemConfiguration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        TigerSerenityReporterPlugin reporter = new TigerSerenityReporterPlugin(systemConfiguration);
        this.addPlugin((Plugin)reporter);
        this.initiateContext(exitStatus, runnerSupplier);
        this.createFeatureRunners(this.getFeatures(), runtimeOptions, junitOptions);
    }
}

