/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue;

import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.pki.TigerConfigurationPkiIdentity;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.proxy.TigerProxy;
import io.cucumber.java.de.Wenn;
import io.cucumber.java.en.When;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerProxyGlue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerProxyGlue.class);

    @Wenn(value="TGR \u00e4ndere die forwardMutualTlsIdentity des lokalen TigerProxies zu {string}")
    @When(value="TGR change the local TigerProxy forwardMutualTlsIdentity to {string}")
    public void setLocalTigerProxyForwardMutualTlsIdentity(String certificateFile) {
        TigerProxyGlue.changeTlsSettingForLocalTigerProxy(certificateFile, (cfg, crt) -> cfg.getTls().setForwardMutualTlsIdentity(crt));
    }

    @Wenn(value="TGR \u00e4ndere die serverIdentity des lokalen TigerProxies zu {string}")
    @When(value="TGR change the local TigerProxy serverIdentity to {string}")
    public void setLocalTigerProxyServerIdentity(String certificateFile) {
        TigerProxyGlue.changeTlsSettingForLocalTigerProxy(certificateFile, (cfg, crt) -> cfg.getTls().setServerIdentity(crt));
    }

    @Wenn(value="TGR \u00e4ndere die rootCa des lokalen TigerProxies zu {string}")
    @When(value="TGR change the local TigerProxy rootCa to {string}")
    public void setLocalTigerProxyRootCa(String certificateFile) {
        TigerProxyGlue.changeTlsSettingForLocalTigerProxy(certificateFile, (cfg, crt) -> cfg.getTls().setServerRootCa(crt));
    }

    private static void changeTlsSettingForLocalTigerProxy(String certificateFile, BiConsumer<TigerProxyConfiguration, TigerConfigurationPkiIdentity> configurationChanger) {
        TigerProxy localTigerProxy = (TigerProxy)TigerDirector.getTigerTestEnvMgr().getLocalTigerProxyOptional().orElseThrow(() -> new TigerProxyGlueException("Could not change settings for the local TigerProxy: The local TigerProxy is inactive"));
        TigerConfigurationPkiIdentity newIdentity = new TigerConfigurationPkiIdentity(certificateFile);
        configurationChanger.accept(localTigerProxy.getTigerProxyConfiguration(), newIdentity);
        localTigerProxy.restartMockserver();
    }

    private static class TigerProxyGlueException
    extends RuntimeException {
        public TigerProxyGlueException(String s) {
            super(s);
        }
    }
}

