/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.reports;

import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.reports.RestAssuredLogToCurlCommandParser;
import de.gematik.test.tiger.lib.reports.SerenityReportUtils;
import io.restassured.filter.Filter;
import io.restassured.filter.FilterContext;
import io.restassured.filter.log.LogDetail;
import io.restassured.filter.log.RequestLoggingFilter;
import io.restassured.response.Response;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerRestAssuredCurlLoggingFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerRestAssuredCurlLoggingFilter.class);
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private RequestLoggingFilter requestLoggingFilter = new RequestLoggingFilter(LogDetail.ALL, true, new PrintStream(this.outputStream), true);

    public synchronized void printToReport() {
        int callCounter = 0;
        String raLog = this.outputStream.toString(StandardCharsets.UTF_8);
        List<String> listOfCurlCalls = RestAssuredLogToCurlCommandParser.convertRestAssuredLogToCurlCalls(raLog);
        for (String callLog : listOfCurlCalls) {
            String curlCommand = RestAssuredLogToCurlCommandParser.parseCurlCommandFromRestAssuredLog(callLog);
            if (!TigerDirector.isSerenityAvailable(true) || curlCommand.isEmpty()) continue;
            Object title = "cURL";
            if (listOfCurlCalls.size() > 1) {
                title = (String)title + String.format("%3d", callCounter++);
            }
            log.info("cURL command: " + curlCommand);
            log.debug("RestAssured details:\n" + callLog);
            SerenityReportUtils.addCustomData((String)title, curlCommand);
        }
        this.outputStream.reset();
    }

    public synchronized Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        return this.requestLoggingFilter.filter(requestSpec, responseSpec, ctx);
    }
}

