/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.reports;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class RestAssuredLogToCurlCommandParser {
    public static List<String> convertRestAssuredLogToCurlCalls(String raLog) {
        ArrayList<String> requestLogs = new ArrayList<String>();
        String[] lines = raLog.split("\\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if (line.trim().startsWith("Request method:") && sb.length() > 0) {
                requestLogs.add(sb.toString());
                sb.setLength(0);
            }
            sb.append(line).append("\n");
        }
        if (sb.length() > 0) {
            requestLogs.add(sb.toString());
        }
        return requestLogs;
    }

    public static String parseCurlCommandFromRestAssuredLog(String rALogDetails) {
        String[] lines = rALogDetails.split("\\n");
        Optional<String> uri = RestAssuredLogToCurlCommandParser.getOptionalValueFromLogLine(lines, "Request URI:");
        Optional<String> method = RestAssuredLogToCurlCommandParser.getOptionalValueFromLogLine(lines, "Request method:");
        StringBuilder curlCmd = new StringBuilder("curl -v ");
        if (uri.isPresent() && method.isPresent()) {
            List<String> headers = RestAssuredLogToCurlCommandParser.getValuesForBlock(lines, "Headers");
            boolean isFirstHeader = true;
            for (String header : headers) {
                if (header.isEmpty()) continue;
                if (header.contains("=")) {
                    if (isFirstHeader) {
                        curlCmd.append("-H \"");
                        isFirstHeader = false;
                    } else {
                        curlCmd.append("\" -H \"");
                    }
                    int equal = header.indexOf("=");
                    curlCmd.append(header, 0, equal).append(": ").append(header.substring(equal + 1));
                    continue;
                }
                curlCmd.append(header, 0, header.length());
            }
            switch (method.get()) {
                case "GET": {
                    curlCmd.append("\" -X GET \"").append(uri.get()).append("\" ");
                    break;
                }
                case "POST": {
                    StringBuilder paramsStr = new StringBuilder();
                    if (RestAssuredLogToCurlCommandParser.createCurlParamString(paramsStr, RestAssuredLogToCurlCommandParser.getValuesForBlock(lines, "Form params"))) {
                        curlCmd.append(" ").append((CharSequence)paramsStr).append("\" ");
                    }
                    curlCmd.append("\" -X POST \"").append(uri.get()).append("\" ");
                    break;
                }
                case "DELETE": {
                    curlCmd.append("\" -X DELETE \"").append(uri.get()).append("\" ");
                    break;
                }
                case "PUT": {
                    curlCmd.append("\" -X PUT -d '").append(RestAssuredLogToCurlCommandParser.createCurlBodyString(RestAssuredLogToCurlCommandParser.getValuesForBlock(lines, "Body"))).append("' \"").append(uri.get()).append("\" ");
                }
            }
        } else {
            curlCmd.append("Unable to parse log data");
        }
        return curlCmd.toString();
    }

    private static Optional<String> getOptionalValueFromLogLine(String[] lines, String prefix) {
        return Stream.of(lines).filter(l -> l.trim().startsWith(prefix)).map(line -> line.substring(prefix.length()).trim()).findFirst();
    }

    private static boolean createCurlParamString(StringBuilder paramsStr, List<String> params) {
        boolean first = true;
        for (String param : params) {
            int equal = param.indexOf("=");
            if (first) {
                first = false;
                paramsStr.append("--data \"");
            } else {
                paramsStr.append("&");
            }
            if (equal == -1) {
                paramsStr.append(param).append("=");
                continue;
            }
            paramsStr.append(param, 0, equal).append("=").append(param.substring(equal + 1));
        }
        return !first;
    }

    private static String getValueFromLogLine(String line) {
        int start = line.lastIndexOf("\t");
        if (start == -1) {
            return line.trim();
        }
        return line.substring(start).trim();
    }

    private static String createCurlBodyString(List<String> bodyLines) {
        return String.join((CharSequence)"\n", bodyLines);
    }

    private static List<String> getValuesForBlock(String[] lines, String blockToken) {
        ArrayList<String> values = new ArrayList<String>();
        boolean blockStarted = false;
        for (String line : lines) {
            if (!blockStarted && line.startsWith(blockToken + ":")) {
                blockStarted = true;
                String v = RestAssuredLogToCurlCommandParser.getValueFromLogLine(line);
                if ("<none>".equals(v)) {
                    return new ArrayList<String>();
                }
                if (line.trim().equals(v)) continue;
                values.add(v);
                continue;
            }
            if (!blockStarted) continue;
            int tab = line.indexOf("\t");
            int colon = line.indexOf(":");
            if (colon != -1 && colon < tab) {
                return values;
            }
            values.add(RestAssuredLogToCurlCommandParser.getValueFromLogLine(line));
        }
        return values;
    }
}

