/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue;

import de.gematik.test.tiger.common.banner.Banner;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.TigerLibraryException;
import de.gematik.test.tiger.testenvmgr.data.BannerType;
import de.gematik.test.tiger.testenvmgr.env.TigerStatusUpdate;
import io.cucumber.java.de.Dann;
import io.cucumber.java.de.Gegebensei;
import io.cucumber.java.de.Wenn;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerGlue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerGlue.class);

    @Wenn(value="TGR setze globale Variable {string} auf {string}")
    @When(value="TGR set global variable {string} to {string}")
    public void ctxtISetGlobalVariableTo(String key, String value) {
        TigerGlobalConfiguration.putValue((String)TigerGlobalConfiguration.resolvePlaceholders((String)key), (String)TigerGlobalConfiguration.resolvePlaceholders((String)value));
    }

    @Wenn(value="TGR setze lokale Variable {string} auf {string}")
    @When(value="TGR set local variable {string} to {string}")
    public void ctxtISetLocalVariableTo(String key, String value) {
        TigerGlobalConfiguration.putValue((String)TigerGlobalConfiguration.resolvePlaceholders((String)key), (String)TigerGlobalConfiguration.resolvePlaceholders((String)value), (SourceType)SourceType.THREAD_CONTEXT);
    }

    @Dann(value="TGR pr\u00fcfe Variable {string} stimmt \u00fcberein mit {string}")
    @Then(value="TGR assert variable {string} matches {string}")
    public void ctxtAssertVariableMatches(String key, String regex) {
        String resolvedKey = TigerGlobalConfiguration.resolvePlaceholders((String)key);
        String value = (String)TigerGlobalConfiguration.readStringOptional((String)resolvedKey).orElseThrow(() -> new TigerLibraryException("Wanted to assert value of key " + key + " (resolved to " + resolvedKey + ") but couldn't find it!"));
        if (!Objects.equals(value, regex)) {
            Assertions.assertThat((String)value).matches((CharSequence)regex);
        }
    }

    @Dann(value="TGR pr\u00fcfe Variable {string} ist unbekannt")
    @Then(value="TGR assert variable {string} is unknown")
    public void ctxtAssertVariableUnknown(String key) {
        String resolvedKey = TigerGlobalConfiguration.resolvePlaceholders((String)key);
        Optional optionalValue = TigerGlobalConfiguration.readStringOptional((String)resolvedKey);
        ((OptionalAssert)Assertions.assertThat((Optional)optionalValue).withFailMessage("Wanted to assert value of key {} (resolved to {}) is not set but found value {}!", new Object[]{key, resolvedKey, optionalValue})).isEmpty();
    }

    @Gegebensei(value="TGR zeige {word} Banner {string}")
    @Given(value="TGR show {word} banner {string}")
    public void tgrShowColoredBanner(String color, String text) {
        log.info("\n" + Banner.toBannerStrWithCOLOR((String)TigerGlobalConfiguration.resolvePlaceholders((String)text), (String)color.toUpperCase()));
    }

    @Gegebensei(value="TGR zeige {word} Text {string}")
    @Given(value="TGR show {word} text {string}")
    public void tgrShowColoredText(String color, String text) {
        log.info("\n" + Banner.toTextStr((String)TigerGlobalConfiguration.resolvePlaceholders((String)text), (String)color.toUpperCase()));
    }

    @Gegebensei(value="TGR zeige Banner {string}")
    @Given(value="TGR show banner {string}")
    public void tgrIWantToShowBanner(String text) {
        log.info("\n" + Banner.toBannerStrWithCOLOR((String)TigerGlobalConfiguration.resolvePlaceholders((String)text), (String)"WHITE"));
    }

    @When(value="TGR wait for user abort")
    @Wenn(value="TGR warte auf Abbruch")
    public void tgrWaitForUserAbort() {
        TigerDirector.waitForAcknowledgedQuit();
    }

    @When(value="TGR pause test run execution")
    @Wenn(value="TGR pausiere Testausf\u00fchrung")
    public void tgrPauseExecution() {
        TigerDirector.pauseExecution();
    }

    @When(value="TGR pause test run execution with message {string}")
    @Wenn(value="TGR pausiere Testausf\u00fchrung mit Nachricht {string}")
    public void tgrPauseExecutionWithMessage(String message) {
        TigerDirector.pauseExecution(TigerGlobalConfiguration.resolvePlaceholders((String)message));
    }

    @When(value="TGR pause test run execution with message {string} and message in case of error {string}")
    @Wenn(value="TGR pausiere Testausf\u00fchrung mit Nachricht {string} und Meldung im Fehlerfall {string}")
    public void tgrPauseExecutionWithMessageAndErrorMessage(String message, String errorMessage) {
        TigerDirector.pauseExecutionAndFailIfDesired(TigerGlobalConfiguration.resolvePlaceholders((String)message), TigerGlobalConfiguration.resolvePlaceholders((String)errorMessage));
    }

    @When(value="TGR show HTML Notification:")
    @Wenn(value="TGR zeige HTML Notification:")
    public void tgrShowHtmlNotification(String message) {
        String bannerMessage = TigerGlobalConfiguration.resolvePlaceholders((String)message);
        if (TigerDirector.getLibConfig().isActivateWorkflowUi()) {
            TigerDirector.getTigerTestEnvMgr().receiveTestEnvUpdate(TigerStatusUpdate.builder().bannerMessage(bannerMessage).bannerColor("green").bannerType(BannerType.STEP_WAIT).bannerIsHtml(true).build());
            Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(TigerDirector.getLibConfig().getPauseExecutionTimeoutSeconds(), TimeUnit.SECONDS).until(() -> TigerDirector.getTigerTestEnvMgr().isUserAcknowledgedOnWorkflowUi());
            TigerDirector.getTigerTestEnvMgr().resetConfirmationFromWorkflowUi();
        } else {
            log.warn("Workflow UI is not active! Can't display message '{}'", (Object)bannerMessage);
        }
    }

    @When(value="TGR assert {string} matches {string}")
    @Dann(value="TGR pr\u00fcfe das {string} mit {string} \u00fcberein stimmt")
    public void tgrAssertMatches(String rawValue1, String rawValue2) {
        String value2;
        String value1 = TigerGlobalConfiguration.resolvePlaceholders((String)rawValue1);
        if (!Objects.equals(value1, value2 = TigerGlobalConfiguration.resolvePlaceholders((String)rawValue2))) {
            Assertions.assertThat((String)value1).matches((CharSequence)value2);
        }
    }
}

