/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.configuration.RbelConfiguration;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.initializers.RbelKeyFolderInitializer;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.config.TigerTypedConfigurationKey;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.exception.TigerHttpGlueCodeException;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.ParameterType;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import io.restassured.RestAssured;
import io.restassured.http.Method;
import io.restassured.specification.RequestSpecification;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.assertj.core.api.SoftAssertionsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpGlueCode {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpGlueCode.class);
    private static final TigerTypedConfigurationKey<Boolean> executeBlocking = new TigerTypedConfigurationKey(new TigerConfigurationKey(new String[]{"tiger", "httpClient", "executeBlocking"}), Boolean.class, (Object)false);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static RbelLogger rbelLogger;
    private static RbelWriter rbelWriter;

    private static RequestSpecification givenDefaultSpec() {
        RequestSpecification requestSpecification = RestAssured.given();
        return requestSpecification.headers(TigerGlobalConfiguration.readMap((String[])new String[]{"tiger", "httpClient", "defaultHeader"}));
    }

    private static String resolveToString(String value) {
        return new String(HttpGlueCode.resolve(value), DEFAULT_CHARSET);
    }

    private static byte[] resolve(String value) {
        String resolvedInput = TigerGlobalConfiguration.resolvePlaceholders((String)value);
        if (TigerDirector.getLibConfig().getHttpClientConfig().isActivateRbelWriter()) {
            RbelElement input = HttpGlueCode.getRbelConverter().convertElement(resolvedInput, null);
            return HttpGlueCode.getRbelWriter().serialize(input, new TigerJexlContext().withRootElement((Object)input));
        }
        return resolvedInput.getBytes(DEFAULT_CHARSET);
    }

    private static void executeCommandWithContingentWait(SoftAssertionsProvider.ThrowingRunnable command) {
        if (((Boolean)executeBlocking.getValueOrDefault()).booleanValue()) {
            HttpGlueCode.executeCommandInBackground(command);
        } else {
            try {
                command.run();
            }
            catch (Exception e) {
                throw new TigerHttpGlueCodeException("Error during request execution", e);
            }
        }
    }

    private static void executeCommandInBackground(SoftAssertionsProvider.ThrowingRunnable command) {
        TigerDirector.getTigerTestEnvMgr().getCachedExecutor().submit(() -> {
            try {
                command.run();
            }
            catch (Exception e) {
                throw new TigerHttpGlueCodeException("Error during request execution", e);
            }
        });
    }

    private static RbelWriter getRbelWriter() {
        HttpGlueCode.assureRbelIsInitialized();
        return rbelWriter;
    }

    private static RbelConverter getRbelConverter() {
        HttpGlueCode.assureRbelIsInitialized();
        return rbelLogger.getRbelConverter();
    }

    private static void assureRbelIsInitialized() {
        if (rbelWriter == null) {
            rbelLogger = RbelLogger.build((RbelConfiguration)RbelConfiguration.builder().activateAsn1Parsing(true).initializers(Optional.ofNullable(TigerDirector.getTigerTestEnvMgr().getConfiguration().getTigerProxy().getKeyFolders()).stream().flatMap(Collection::stream).map(RbelKeyFolderInitializer::new).map(init -> init).toList()).build());
            rbelWriter = new RbelWriter(rbelLogger.getRbelConverter());
        }
    }

    @ParameterType(value="GET|POST|DELETE|PUT|OPTIONS")
    public Method requestType(String name) {
        return Method.valueOf((String)name);
    }

    @When.Whens(value={@When(value="TGR send empty {requestType} request to {string}"), @When(value="TGR eine leere {requestType} Anfrage an {string} sendet")})
    @Then(value="TGR sende eine leere {requestType} Anfrage an {string}")
    public void sendEmptyRequest(Method method, String address) {
        log.info("Sending empty {} request to {}", (Object)method, (Object)address);
        HttpGlueCode.executeCommandWithContingentWait(() -> HttpGlueCode.givenDefaultSpec().request(method, new URI(HttpGlueCode.resolveToString(address))));
    }

    @When(value="TGR send empty {requestType} request to {string} without waiting for the response")
    @Then(value="TGR sende eine leere {requestType} Anfrage an {string} ohne auf Antwort zu warten")
    public void sendEmptyRequestNonBlocking(Method method, String address) {
        log.info("Sending empty {} request to {}", (Object)method, (Object)address);
        HttpGlueCode.executeCommandInBackground(() -> HttpGlueCode.givenDefaultSpec().request(method, new URI(HttpGlueCode.resolveToString(address))));
    }

    @When.Whens(value={@When(value="TGR send empty {requestType} request to {string} with headers:"), @When(value="TGR eine leere {requestType} Anfrage an {string} und den folgenden Headern sendet:")})
    @Then(value="TGR sende eine leere {requestType} Anfrage an {string} mit folgenden Headern:")
    public void sendEmptyRequestWithHeaders(Method method, String address, DataTable customHeaders) {
        log.info("Sending empty {} request with headers to {}", (Object)method, (Object)address);
        Map defaultHeaders = TigerGlobalConfiguration.readMap((String[])new String[]{"tiger", "httpClient", "defaultHeader"});
        defaultHeaders.putAll(this.resolveMap(customHeaders.asMap()));
        HttpGlueCode.executeCommandWithContingentWait(() -> HttpGlueCode.givenDefaultSpec().headers(defaultHeaders).request(method, new URI(HttpGlueCode.resolveToString(address))));
    }

    @When(value="TGR send empty {requestType} request to {string} without waiting for the response with headers:")
    @Then(value="TGR sende eine leere {requestType} Anfrage an {string} ohne auf Antwort zu warten mit folgenden Headern:")
    public void sendEmptyRequestWithHeadersNonBlocking(Method method, String address, DataTable customHeaders) {
        log.info("Sending empty {} request with headers to {}", (Object)method, (Object)address);
        Map defaultHeaders = TigerGlobalConfiguration.readMap((String[])new String[]{"tiger", "httpClient", "defaultHeader"});
        defaultHeaders.putAll(this.resolveMap(customHeaders.asMap()));
        HttpGlueCode.executeCommandInBackground(() -> HttpGlueCode.givenDefaultSpec().headers(defaultHeaders).request(method, new URI(HttpGlueCode.resolveToString(address))));
    }

    @When.Whens(value={@When(value="TGR send {requestType} request to {string} with body {string}"), @When(value="TGR eine leere {requestType} Anfrage an {string} und dem folgenden body {string} sendet")})
    @Then(value="TGR sende eine {requestType} Anfrage an {string} mit Body {string}")
    public void sendRequestWithBody(Method method, String address, String body) {
        log.info("Sending {} request with body to {}", (Object)method, (Object)address);
        HttpGlueCode.executeCommandWithContingentWait(() -> HttpGlueCode.givenDefaultSpec().body(HttpGlueCode.resolve(body)).request(method, new URI(HttpGlueCode.resolveToString(address))));
    }

    @When(value="TGR send {requestType} request to {string} with body {string} without waiting for the response")
    @Then(value="TGR sende eine {requestType} Anfrage an {string} mit Body {string} ohne auf Antwort zu warten")
    public void sendRequestWithBodyNonBlocking(Method method, String address, String body) {
        log.info("Sending {} request with body to {}", (Object)method, (Object)address);
        HttpGlueCode.executeCommandInBackground(() -> HttpGlueCode.givenDefaultSpec().body(HttpGlueCode.resolve(body)).request(method, new URI(HttpGlueCode.resolveToString(address))));
    }

    @When.Whens(value={@When(value="TGR send {requestType} request to {string} with:"), @When(value="TGR eine {requestType} Anfrage an {string} mit den folgenden Daten sendet:")})
    @Then(value="TGR sende eine {requestType} Anfrage an {string} mit folgenden Daten:")
    public void sendRequestWithParams(Method method, String address, DataTable parameters) {
        List dataAsMaps = parameters.asMaps();
        if (dataAsMaps.size() != 1) {
            throw new AssertionError((Object)("Expected exactly one entry for data table, got " + dataAsMaps.size()));
        }
        HttpGlueCode.executeCommandWithContingentWait(() -> HttpGlueCode.givenDefaultSpec().formParams(this.resolveMap((Map)dataAsMaps.get(0))).request(method, new URI(HttpGlueCode.resolveToString(address))));
    }

    @When(value="TGR send {requestType} request to {string} without waiting for the response with:")
    @Then(value="TGR sende eine {requestType} Anfrage an {string} ohne auf Antwort zu warten mit folgenden Daten:")
    public void sendRequestWithParamsNonBlocking(Method method, String address, DataTable parameters) {
        List dataAsMaps = parameters.asMaps();
        if (dataAsMaps.size() != 1) {
            throw new AssertionError((Object)("Expected exactly one entry for data table, got " + dataAsMaps.size()));
        }
        HttpGlueCode.executeCommandInBackground(() -> HttpGlueCode.givenDefaultSpec().formParams(this.resolveMap((Map)dataAsMaps.get(0))).request(method, new URI(HttpGlueCode.resolveToString(address))));
    }

    @When.Whens(value={@When(value="TGR set default header {string} to {string}"), @When(value="TGR den default header {string} auf den Wert {string} setzen")})
    @Then(value="TGR setze den default header {string} auf den Wert {string}")
    public void setDefaultHeader(String header, String value) {
        TigerGlobalConfiguration.putValue((String)("tiger.httpClient.defaultHeader." + HttpGlueCode.resolveToString(header)), (String)HttpGlueCode.resolveToString(value));
    }

    private Map<String, String> resolveMap(Map<String, String> map) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> HttpGlueCode.resolveToString((String)entry.getKey()), entry -> HttpGlueCode.resolveToString((String)entry.getValue())));
    }
}

