/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.parser.model.gherkin;

import de.gematik.test.tiger.lib.parser.model.gherkin.Feature;
import de.gematik.test.tiger.lib.parser.model.gherkin.GherkinStruct;
import de.gematik.test.tiger.lib.parser.model.gherkin.Step;
import de.gematik.test.tiger.lib.parser.model.gherkin.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.json.JSONArray;
import org.json.JSONObject;

public class Scenario
extends GherkinStruct {
    private Feature feature;
    private Integer lineNumber;
    private List<Step> steps = new ArrayList<Step>();

    @Override
    public Tag getTag(String tagName) {
        Tag tag = super.getTag(tagName);
        if (tag == null) {
            return this.feature.getTag(tagName);
        }
        return tag;
    }

    public boolean hasTag(String tagName) {
        return this.getTag(tagName) != null;
    }

    @Override
    public String toString() {
        return super.toString() + " , Feature=" + this.feature.getName();
    }

    public JSONObject toPolarionJSON() {
        JSONObject json = new JSONObject();
        if (this.hasTag("@TCID")) {
            json.put("Interne Id", (Object)this.getTag("@TCID").getParameter());
        }
        if (this.hasTag("@Ready")) {
            json.put("Status", (Object)"Implementiert");
        } else {
            json.put("Status", (Object)"In Bearbeitung");
        }
        json.put("NegativTestfall", this.hasTag("@Negative"));
        if (this.hasTag("@PRIO")) {
            json.put("Priorit\u00e4t", Integer.parseInt(this.getTag("@PRIO").getParameter()));
        }
        if (this.hasTag("@Product")) {
            json.put("ProduktTyp", (Object)this.feature.getTag("@Product").getParameter());
        }
        if (this.hasTag("@manual")) {
            json.put("Modus", (Object)"Manuell");
        } else {
            json.put("Modus", (Object)"Automatisch");
        }
        json.put("Teststufe", (Object)"Produkttest");
        json.put("Testart", (Object)"Funktionstest");
        JSONArray afos = new JSONArray((Collection)this.getTags().stream().filter(tag -> tag.getName().equals("@Afo")).map(Tag::getParameter).collect(Collectors.toList()));
        json.put("AFO-Verkn\u00fcpfungen", (Object)afos);
        JSONArray anwendungsfaelle = new JSONArray((Collection)this.getTags().stream().filter(tag -> tag.getName().equals("@AF-ID")).map(Tag::getParameter).collect(Collectors.toList()));
        json.put("Anwendungsf\u00e4lle", (Object)anwendungsfaelle);
        json.put("Titel", (Object)this.getName());
        json.put("Description", (Object)this.getDescription().replace("\n", "</br>"));
        json.put("Vorbedingung", (Object)"");
        StringBuilder sb = new StringBuilder();
        int stepIdx = 0;
        for (Step step : this.steps) {
            ++stepIdx;
            switch (step.getKeyword()) {
                case "Given": {
                    sb.append("<b>Setup</b><br/>");
                    break;
                }
                case "When": {
                    sb.append("<hr/><b>Aktion</b><br/>");
                    break;
                }
                case "Then": {
                    sb.append("<hr/><b>Pr\u00fcfung</b><br/>");
                }
            }
            this.addStep(step, stepIdx + ": ", sb);
        }
        json.put("Testablauf/Testdurchf\u00fchrung", (Object)sb.toString());
        return json;
    }

    protected void addStep(Step step, String header, StringBuilder sb) {
        sb.append("<pre>").append(header);
        step.getLines().forEach(line -> sb.append("    ").append(line.replace("<", "&lt;").replace(">", "&gt;")).append("<br/>"));
        sb.append("</pre>");
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Scenario)) {
            return false;
        }
        Scenario other = (Scenario)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$lineNumber = this.getLineNumber();
        Integer other$lineNumber = other.getLineNumber();
        if (this$lineNumber == null ? other$lineNumber != null : !((Object)this$lineNumber).equals(other$lineNumber)) {
            return false;
        }
        Feature this$feature = this.getFeature();
        Feature other$feature = other.getFeature();
        if (this$feature == null ? other$feature != null : !((Object)this$feature).equals(other$feature)) {
            return false;
        }
        List<Step> this$steps = this.getSteps();
        List<Step> other$steps = other.getSteps();
        return !(this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Scenario;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $lineNumber = this.getLineNumber();
        result = result * 59 + ($lineNumber == null ? 43 : ((Object)$lineNumber).hashCode());
        Feature $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : ((Object)$feature).hashCode());
        List<Step> $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        return result;
    }

    @Generated
    public Scenario() {
    }

    @Generated
    public Feature getFeature() {
        return this.feature;
    }

    @Generated
    public Integer getLineNumber() {
        return this.lineNumber;
    }

    @Generated
    public List<Step> getSteps() {
        return this.steps;
    }

    @Generated
    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    @Generated
    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Generated
    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }
}

