/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib;

import de.gematik.rbellogger.RbelOptions;
import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.LocalProxyRbelMessageListener;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.banner.Banner;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.lib.TigerLibConfig;
import de.gematik.test.tiger.lib.exception.TigerStartupException;
import de.gematik.test.tiger.lib.reports.TigerRestAssuredCurlLoggingFilter;
import de.gematik.test.tiger.lib.serenityRest.SerenityRestUtils;
import de.gematik.test.tiger.proxy.IRbelMessageListener;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgrApplication;
import de.gematik.test.tiger.testenvmgr.data.BannerType;
import de.gematik.test.tiger.testenvmgr.env.TigerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import io.restassured.filter.Filter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import lombok.Generated;
import net.serenitybdd.rest.SerenityRest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Fail;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class TigerDirector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerDirector.class);
    public static TigerRestAssuredCurlLoggingFilter curlLoggingFilter;
    private static TigerTestEnvMgr tigerTestEnvMgr;
    private static boolean initialized;
    private static TigerLibConfig libConfig;
    public static ConfigurableApplicationContext envMgrApplicationContext;
    private static boolean shutdownHookRegistered;
    private static final Pattern showSteps;

    public static synchronized void start() {
        if (initialized) {
            log.info("Tiger Director already started, skipping");
            return;
        }
        TigerDirector.showTigerBanner();
        TigerDirector.readConfiguration();
        TigerDirector.registerRestAssuredFilter();
        TigerDirector.applyTestLibConfig();
        TigerDirector.startTestEnvMgr();
        tigerTestEnvMgr.getLocalTigerProxy().addRbelMessageListener((IRbelMessageListener)LocalProxyRbelMessageListener.rbelMessageListener);
        TigerDirector.startWorkflowUi();
        TigerDirector.setupTestEnvironent();
        TigerDirector.setDefaultProxyToLocalTigerProxy();
        initialized = true;
    }

    public static synchronized void registerShutdownHook() {
        if (shutdownHookRegistered) {
            return;
        }
        shutdownHookRegistered = true;
        log.info("Registering shutdown hook...");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                if (TigerDirector.getLibConfig().isActivateWorkflowUi() && !tigerTestEnvMgr.isUserAcknowledgedShutdown()) {
                    System.out.println(Ansi.colorize((String)"TGR Workflow UI is active, please press quit in browser window...", (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD));
                    if (tigerTestEnvMgr != null) {
                        tigerTestEnvMgr.receiveTestEnvUpdate(TigerStatusUpdate.builder().bannerMessage("Test run finished, press QUIT").bannerColor("green").bannerType(BannerType.TESTRUN_ENDED).build());
                        try {
                            Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(5L, TimeUnit.HOURS).until(() -> tigerTestEnvMgr.isUserAcknowledgedShutdown());
                        }
                        finally {
                            tigerTestEnvMgr.shutDown();
                        }
                    }
                } else if (tigerTestEnvMgr != null) {
                    System.out.println("TGR Shutting down test env...");
                    tigerTestEnvMgr.shutDown();
                }
                TigerDirector.unregisterRestAssuredFilter();
            }
            finally {
                System.out.println("TGR Destroying spring boot context after testrun...");
                if (envMgrApplicationContext != null) {
                    envMgrApplicationContext.close();
                }
                System.out.println("TGR Tiger shut down orderly");
            }
        }));
    }

    private static void setupTestEnvironent() {
        if (!TigerGlobalConfiguration.readBoolean((String)"tiger.skipEnvironmentSetup", (boolean)false)) {
            log.info("\n" + Banner.toBannerStr((String)"SETTING UP TESTENV...", (String)RbelAnsiColors.BLUE_BOLD.toString()));
            tigerTestEnvMgr.setUpEnvironment();
            log.info("\n" + Banner.toBannerStr((String)"TESTENV SET UP OK", (String)RbelAnsiColors.BLUE_BOLD.toString()));
        }
    }

    private static synchronized void readConfiguration() {
        libConfig = TigerGlobalConfiguration.instantiateConfigurationBean(TigerLibConfig.class, (String[])new String[]{"TIGER_LIB"}).orElseGet(TigerLibConfig::new);
    }

    private static void showTigerBanner() {
        if (TigerGlobalConfiguration.readBoolean((String)"TIGER_LOGO", (boolean)false)) {
            try {
                log.info("\n" + IOUtils.toString((InputStream)Objects.requireNonNull(TigerDirector.class.getResourceAsStream("/tiger2-logo.ansi")), (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new TigerStartupException("Unable to read tiger logo!");
            }
        }
    }

    private static void applyTestLibConfig() {
        if (libConfig.isRbelPathDebugging()) {
            RbelOptions.activateRbelPathDebugging();
        } else {
            RbelOptions.deactivateRbelPathDebugging();
        }
        if (libConfig.isRbelAnsiColors()) {
            RbelOptions.activateAnsiColors();
        } else {
            RbelOptions.deactivateAnsiColors();
        }
    }

    private static synchronized void startTestEnvMgr() {
        log.info("\n" + Banner.toBannerStr((String)"STARTING TESTENV MGR...", (String)RbelAnsiColors.BLUE_BOLD.toString()));
        envMgrApplicationContext = new SpringApplicationBuilder(new Class[0]).bannerMode(Banner.Mode.OFF).properties(Map.of("server.port", TigerGlobalConfiguration.readIntegerOptional((String)"tiger.internal.testenvmgr.port").orElse(0))).sources(new Class[]{TigerTestEnvMgrApplication.class}).web(WebApplicationType.SERVLET).registerShutdownHook(false).initializers(new ApplicationContextInitializer[0]).run(new String[0]);
        tigerTestEnvMgr = (TigerTestEnvMgr)envMgrApplicationContext.getBean(TigerTestEnvMgr.class);
    }

    private static synchronized void startWorkflowUi() {
        if (TigerDirector.libConfig.activateWorkflowUi) {
            log.info("\n" + Banner.toBannerStr((String)"STARTING WORKFLOW UI ...", (String)RbelAnsiColors.BLUE_BOLD.toString()));
            TigerTestEnvMgr.openWorkflowUiInBrowser((String)((Integer)TigerGlobalConfiguration.readIntegerOptional((String)"tiger.internal.testenvmgr.port").orElseThrow(() -> new TigerEnvironmentStartupException("No free port for test environment manager reserved!"))).toString());
            log.info("Waiting for workflow Ui to fetch status...");
            try {
                Awaitility.await().atMost(Duration.ofSeconds(10L)).pollInterval(Duration.ofSeconds(1L)).until(() -> tigerTestEnvMgr.isWorkflowUiSentFetch());
            }
            catch (ConditionTimeoutException cte) {
                TigerDirector.libConfig.activateWorkflowUi = false;
                throw new TigerTestEnvException("No feedback from workflow Ui, aborting!", (Throwable)cte);
            }
            try {
                TimeUnit.MILLISECONDS.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TigerTestEnvException("Interrupt received while waiting for workflow Ui to become ready", (Throwable)e);
            }
        }
    }

    private static synchronized void setDefaultProxyToLocalTigerProxy() {
        TigerProxyConfiguration tpCfg = tigerTestEnvMgr.getConfiguration().getTigerProxy();
        if (tigerTestEnvMgr.isLocalTigerProxyActive()) {
            if (System.getProperty("http.proxyHost") != null || System.getProperty("https.proxyHost") != null) {
                log.info(Ansi.colorize((String)"SKIPPING TIGER PROXY settings as System Property is set already...", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
            } else {
                log.info(Ansi.colorize((String)("SETTING TIGER PROXY http://localhost:" + tigerTestEnvMgr.getLocalTigerProxy().getProxyPort() + "..."), (RbelAnsiColors)RbelAnsiColors.BLUE_BOLD));
                System.setProperty("http.proxyHost", "localhost");
                System.setProperty("http.proxyPort", "" + tigerTestEnvMgr.getLocalTigerProxy().getProxyPort());
                System.setProperty("http.nonProxyHosts", "localhost|127.0.0.1");
                System.setProperty("https.proxyHost", "localhost");
                System.setProperty("https.proxyPort", "" + tigerTestEnvMgr.getLocalTigerProxy().getProxyPort());
                System.setProperty("java.net.useSystemProxies", "true");
                SerenityRestUtils.setupSerenityRest(tigerTestEnvMgr.getLocalTigerProxy().getProxyPort());
            }
        } else {
            log.info(Ansi.colorize((String)"SKIPPING TIGER PROXY settings as localProxyActive==false...", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
        }
    }

    public static synchronized boolean isInitialized() {
        return initialized;
    }

    public static TigerTestEnvMgr getTigerTestEnvMgr() {
        TigerDirector.assertThatTigerIsInitialized();
        return tigerTestEnvMgr;
    }

    public static String getLocalTigerProxyUrl() {
        TigerDirector.assertThatTigerIsInitialized();
        if (tigerTestEnvMgr.getLocalTigerProxy() == null || !tigerTestEnvMgr.getConfiguration().isLocalProxyActive()) {
            return null;
        }
        return tigerTestEnvMgr.getLocalTigerProxy().getBaseUrl();
    }

    public static void waitForQuit() {
        if (TigerDirector.getLibConfig().isActivateWorkflowUi()) {
            tigerTestEnvMgr.receiveTestEnvUpdate(TigerStatusUpdate.builder().bannerMessage("Press QUIT to abort test run").bannerColor("green").bannerType(BannerType.TESTRUN_ENDED).build());
            try {
                Awaitility.await().pollInterval(200L, TimeUnit.MILLISECONDS).atMost(5L, TimeUnit.HOURS).until(() -> tigerTestEnvMgr.isUserAcknowledgedShutdown());
            }
            finally {
                System.exit(0);
            }
        } else {
            TigerTestEnvMgr.waitForConsoleInput((String)"quit");
            System.exit(0);
        }
    }

    private static void assertThatTigerIsInitialized() {
        if (!initialized) {
            throw new TigerStartupException("Tiger test environment has not been initialized successfully!");
        }
    }

    public static boolean isSerenityAvailable() {
        return TigerDirector.isSerenityAvailable(false);
    }

    public static boolean isSerenityAvailable(boolean quiet) {
        try {
            Class.forName("net.serenitybdd.core.Serenity");
            return true;
        }
        catch (ClassNotFoundException e) {
            if (!quiet) {
                log.warn("Trying to use Serenity functionality, but Serenity BDD packages are not declared as runtime dependency.", (Throwable)e);
            }
            return false;
        }
    }

    public static void testUninitialize() {
        initialized = false;
        tigerTestEnvMgr = null;
        curlLoggingFilter = null;
        System.clearProperty("TIGER_TESTENV_CFGFILE");
        System.clearProperty("http.proxyHost");
        System.clearProperty("https.proxyHost");
        System.clearProperty("http.proxyPort");
        System.clearProperty("https.proxyPort");
        TigerGlobalConfiguration.reset();
    }

    public static synchronized void registerRestAssuredFilter() {
        if (TigerDirector.getLibConfig().isAddCurlCommandsForRaCallsToReport() && curlLoggingFilter == null) {
            curlLoggingFilter = new TigerRestAssuredCurlLoggingFilter();
            SerenityRest.filters((Filter)curlLoggingFilter, (Filter[])new Filter[0]);
        }
    }

    public static synchronized void unregisterRestAssuredFilter() {
        if (curlLoggingFilter != null) {
            SerenityRest.replaceFiltersWith(new ArrayList());
        }
        curlLoggingFilter = null;
    }

    public static void pauseExecution() {
        TigerDirector.pauseExecution("", false);
    }

    public static void pauseExecution(String message, boolean isHtml) {
        String defaultMessage = "Test execution paused, click to continue";
        if (StringUtils.isBlank((CharSequence)message)) {
            message = defaultMessage;
        }
        if (TigerDirector.getLibConfig().isActivateWorkflowUi()) {
            tigerTestEnvMgr.receiveTestEnvUpdate(TigerStatusUpdate.builder().bannerMessage(message).bannerColor("green").bannerType(BannerType.STEP_WAIT).bannerIsHtml(isHtml).build());
            Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(5L, TimeUnit.HOURS).until(() -> tigerTestEnvMgr.isUserAcknowledgedContinueTestRun());
            tigerTestEnvMgr.resetUserInput();
        } else {
            log.warn(String.format("The step 'TGR pause test run execution with message \"%s\"' is not supported outside the Workflow UI. Please check the manual for more information.", message));
        }
    }

    public static void pauseExecution(String message) {
        TigerDirector.pauseExecution(message, false);
    }

    public static void pauseExecutionAndFailIfDesired(String message, String errorMessage) {
        if (TigerDirector.getLibConfig().isActivateWorkflowUi()) {
            tigerTestEnvMgr.receiveTestEnvUpdate(TigerStatusUpdate.builder().bannerMessage(message).bannerColor("black").bannerType(BannerType.FAIL_PASS).build());
            Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(5L, TimeUnit.HOURS).until(() -> tigerTestEnvMgr.isUserAcknowledgedContinueTestRun() || tigerTestEnvMgr.isUserAcknowledgedFailingTestRun());
            if (tigerTestEnvMgr.isUserAcknowledgedFailingTestRun()) {
                tigerTestEnvMgr.resetUserInput();
                Fail.fail((String)errorMessage);
            } else {
                tigerTestEnvMgr.resetUserInput();
            }
        } else {
            log.warn(String.format("The step 'TGR pause test run execution with message \"%s\" and message in case of error \"%s\"' is not supported outside the Workflow UI. Please check the manual for more information.", message, errorMessage));
        }
    }

    @Generated
    public static TigerLibConfig getLibConfig() {
        return libConfig;
    }

    static {
        initialized = false;
        shutdownHookRegistered = false;
        showSteps = Pattern.compile(".*TGR (zeige|show) ([\\w|\u00fc|\u00df]*) (Banner|banner|text|Text) \"(.*)\"");
    }
}

