/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger;

import de.gematik.test.tiger.TigerCucumberListener;
import de.gematik.test.tiger.lib.TigerDirector;
import io.cucumber.core.options.CommandlineOptionsParser;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.plugin.SerenityReporter;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.runtime.Runtime;
import io.cucumber.junit.CucumberSerenityRunner;
import io.cucumber.plugin.Plugin;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import lombok.Generated;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.webdriver.Configuration;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerCucumberRunner
extends CucumberSerenityRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerCucumberRunner.class);
    private static RuntimeException tigerStartupFailedException;

    public static void main(String[] argv) {
        log.info("Starting TigerCucumberRunner.main()...");
        if (tigerStartupFailedException != null) {
            log.error("Aborting due to earlier errors in setting up Tiger!");
            System.exit(1);
        }
        TigerCucumberRunner.initializeTiger();
        if (tigerStartupFailedException != null) {
            log.error("Unable to start Tiger!", (Throwable)tigerStartupFailedException);
            System.exit(1);
        }
        Supplier<ClassLoader> classLoaderSupplier = ClassLoaders::getDefaultClassLoader;
        byte exitstatus = TigerCucumberRunner.run(argv, classLoaderSupplier);
        System.exit(exitstatus);
    }

    public static byte run(String[] argv, Supplier<ClassLoader> classLoaderSupplier) {
        ArrayList<String> argvList = new ArrayList<String>(Arrays.asList(argv));
        int index = argvList.indexOf("--tags");
        if (index <= 0) {
            argvList.add("--tags");
            argvList.add("not @Ignore");
        }
        String[] arr = argvList.toArray(new String[argvList.size()]);
        RuntimeOptions runtimeOptions = new CommandlineOptionsParser((OutputStream)System.out).parse(arr).build();
        TigerCucumberRunner.setRuntimeOptions((RuntimeOptions)runtimeOptions);
        Runtime runtime = TigerCucumberRunner.using(classLoaderSupplier, runtimeOptions);
        runtime.run();
        return runtime.exitStatus();
    }

    public TigerCucumberRunner(Class clazz) throws InitializationError {
        super(clazz);
        log.info("Starting TigerCucumberRunner for {}", (Object)clazz.getName());
        if (tigerStartupFailedException != null) {
            throw new InitializationError((Throwable)tigerStartupFailedException);
        }
        TigerCucumberRunner.initializeTiger();
        if (tigerStartupFailedException != null) {
            throw new InitializationError((Throwable)tigerStartupFailedException);
        }
    }

    private static synchronized void initializeTiger() {
        try {
            TigerDirector.registerShutdownHook();
            TigerDirector.start();
        }
        catch (RuntimeException rte) {
            tigerStartupFailedException = rte;
        }
    }

    public static Runtime using(Supplier<ClassLoader> classLoaderSupplier, RuntimeOptions runtimeOptions) {
        Configuration systemConfiguration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        return TigerCucumberRunner.createSerenityEnabledRuntime(classLoaderSupplier, runtimeOptions, systemConfiguration);
    }

    public static Runtime createSerenityEnabledRuntime(Supplier<ClassLoader> classLoaderSupplier, RuntimeOptions runtimeOptions, Configuration systemConfiguration) {
        SerenityReporter reporter = new SerenityReporter(systemConfiguration);
        TigerCucumberListener tigerListener = new TigerCucumberListener();
        return Runtime.builder().withClassLoader(classLoaderSupplier).withRuntimeOptions(runtimeOptions).withAdditionalPlugins(new Plugin[]{reporter, tigerListener}).build();
    }
}

