/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.rbel;

import de.gematik.rbellogger.data.RbelMessage;
import de.gematik.rbellogger.data.elements.RbelElement;
import de.gematik.rbellogger.data.elements.RbelHttpRequest;
import de.gematik.rbellogger.data.elements.RbelHttpResponse;
import de.gematik.rbellogger.util.RbelPathExecutor;
import de.gematik.test.tiger.common.context.TestContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class RbelMessageValidator {
    private final TestContext testContext;
    private final String rbelMsgsContextKey;
    private final String lastRbelRequestContextKey;

    public RbelMessageValidator() {
        this("default", "rbelmsgs", "rbelRequest");
    }

    public RbelMessageValidator(String testContextDomain) {
        this(testContextDomain, "rbelmsgs", "rbelRequest");
    }

    public RbelMessageValidator(String testContextDomain, String rbelMsgsContextKey, String lastRbelRequestContextKey) {
        this.testContext = new TestContext(testContextDomain);
        this.rbelMsgsContextKey = rbelMsgsContextKey;
        this.lastRbelRequestContextKey = lastRbelRequestContextKey;
    }

    public List<RbelMessage> getRbelMessages() {
        return (List)this.testContext.getContext().get(this.rbelMsgsContextKey);
    }

    public RbelHttpRequest getLastRequest() {
        return (RbelHttpRequest)this.testContext.getContext().get(this.lastRbelRequestContextKey);
    }

    RbelHttpResponse getResponseOfRequest(RbelHttpRequest request) {
        return this.getRbelMessages().stream().map(RbelMessage::getHttpMessage).filter(RbelHttpResponse.class::isInstance).map(RbelHttpResponse.class::cast).filter(res -> res.getRequest() == request).findAny().orElseThrow(() -> new AssertionError((Object)"No response found for given request"));
    }

    boolean getPath(RbelHttpRequest req, String path) {
        try {
            return new URL(req.getPath().getBasicPath().getContent()).getPath().equals(path);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    void filterRequestsAndStoreInContext(String path, String rbelPath, String value) {
        this.filterGivenRequestsAndStoreInContext(path, rbelPath, value, this.getRbelMessages());
    }

    void filterGivenRequestsAndStoreInContext(String path, String rbelPath, String value, List<RbelMessage> msgs) {
        RbelHttpRequest request = msgs.stream().map(RbelMessage::getHttpMessage).filter(RbelHttpRequest.class::isInstance).map(RbelHttpRequest.class::cast).filter(req -> this.getPath((RbelHttpRequest)req, path)).filter(req -> value == null || rbelPath == null || !new RbelPathExecutor((RbelElement)req, rbelPath).execute().isEmpty() && (((RbelElement)new RbelPathExecutor((RbelElement)req, rbelPath).execute().get(0)).getContent().equals(value) || ((RbelElement)new RbelPathExecutor((RbelElement)req, rbelPath).execute().get(0)).getContent().matches(value))).findAny().orElseThrow(() -> new AssertionError((Object)("No request with path '" + path + "' and rbelPath '" + rbelPath + "' matching '" + value + "'")));
        this.testContext.getContext().put("rbelRequest", request);
        this.testContext.getContext().put("rbelResponse", this.getResponseOfRequest(request));
    }

    void filterNextRequestAndStoreInContext(String path, String rbelPath, String value) {
        List<RbelMessage> msgs = this.getRbelMessages();
        RbelHttpRequest prevRequest = this.getLastRequest();
        int idx = -1;
        for (int i = 0; i < msgs.size(); ++i) {
            if (msgs.get(i).getHttpMessage() != prevRequest) continue;
            idx = i;
            break;
        }
        this.filterGivenRequestsAndStoreInContext(path, rbelPath, value, new ArrayList<RbelMessage>(msgs.subList(idx + 2, msgs.size())));
    }
}

