/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.proxy;

import de.gematik.rbellogger.data.RbelMessage;
import de.gematik.rbellogger.data.elements.RbelHttpMessage;
import de.gematik.test.tiger.lib.TigerLibraryException;
import de.gematik.test.tiger.lib.parser.model.gherkin.Step;
import de.gematik.test.tiger.proxy.IRbelMessageListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelMessageProvider
implements IRbelMessageListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelMessageProvider.class);
    private final List<RbelMessage> messages = new ArrayList<RbelMessage>();
    private long timeoutms = 5000L;
    private boolean wait = false;

    public void triggerNewReceivedMessage(RbelMessage el) {
        this.messages.add(el);
        this.wait = false;
    }

    public void waitForMessage() {
        this.wait = true;
        long startms = System.currentTimeMillis();
        while (this.wait) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                log.warn("Interruption signaled");
                Thread.currentThread().interrupt();
            }
            if (System.currentTimeMillis() - startms <= this.timeoutms) continue;
            throw new TigerLibraryException("Timeout waiting for rbel message");
        }
    }

    public RbelMessage pullMessage() {
        if (this.messages.isEmpty()) {
            this.waitForMessage();
        }
        RbelMessage el = this.messages.get(0);
        this.messages.remove(0);
        return el;
    }

    public List<RbelHttpMessage> getHttpMessages() {
        return this.messages.stream().map(RbelMessage::getHttpMessage).collect(Collectors.toList());
    }

    public List<RbelMessage> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public void startStep(Step st) {
        this.messages.clear();
        this.wait = false;
    }

    public void setTimeoutms(long timeout) {
        this.timeoutms = timeout;
    }
}

