/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib;

import de.gematik.test.tiger.common.OsEnvironment;
import de.gematik.test.tiger.common.banner.Banner;
import de.gematik.test.tiger.lib.TigerLibraryException;
import de.gematik.test.tiger.lib.exception.TigerStartupException;
import de.gematik.test.tiger.lib.proxy.RbelMessageProvider;
import de.gematik.test.tiger.proxy.IRbelMessageListener;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerDirector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerDirector.class);
    private static final Map<Long, RbelMessageProvider> rbelMsgProviderMap = new HashMap<Long, RbelMessageProvider>();
    private static final Map<Long, TigerProxy> proxiesMap = new HashMap<Long, TigerProxy>();
    private static TigerTestEnvMgr tigerTestEnvMgr;
    private static boolean initialized;

    private TigerDirector() {
    }

    public static synchronized void beforeTestRun() {
        if (!OsEnvironment.getAsBoolean((String)"TIGER_ACTIVE")) {
            log.warn("\u001b[1m\u001b[31mABORTING initialisation as environment variable TIGER_ACTIVE is not set to '1'\u001b[0m");
            throw new AssertionError((Object)"ABORTING initialisation as environment variable TIGER_ACTIVE is not set to '1'");
        }
        log.info("\n" + IOUtils.toString((InputStream)Objects.requireNonNull(TigerDirector.class.getResourceAsStream("/tiger2-logo.ansi")), (Charset)StandardCharsets.UTF_8));
        log.info("\n" + Banner.toBannerStr((String)"READING TEST CONFIG...", (String)"\u001b[1m\u001b[34m"));
        log.info("\n" + Banner.toBannerStr((String)"STARTING TESTENV MGR...", (String)"\u001b[1m\u001b[34m"));
        tigerTestEnvMgr = new TigerTestEnvMgr();
        tigerTestEnvMgr.setUpEnvironment();
        log.info("\n" + Banner.toBannerStr((String)"SETTING TIGER PROXY...", (String)"\u001b[1m\u001b[34m"));
        System.setProperty("http.proxyHost", "localhost");
        System.setProperty("http.proxyPort", "" + tigerTestEnvMgr.getLocalDockerProxy().getPort());
        System.setProperty("http.nonProxyHosts", "localhost|127.0.0.1");
        System.setProperty("https.proxyHost", "localhost");
        System.setProperty("https.proxyPort", "" + tigerTestEnvMgr.getLocalDockerProxy().getPort());
        initialized = true;
        log.info("\n" + Banner.toBannerStr((String)"DIRECTOR STARTUP OK", (String)"\u001b[1m\u001b[34m"));
    }

    public static synchronized boolean isInitialized() {
        return initialized;
    }

    public static TigerTestEnvMgr getTigerTestEnvMgr() {
        TigerDirector.assertThatTigerIsInitialized();
        return tigerTestEnvMgr;
    }

    public static void synchronizeTestCasesWithPolarion() {
        TigerDirector.assertThatTigerIsInitialized();
        if (OsEnvironment.getAsBoolean((String)"TIGER_SYNC_TESTCASES")) {
            try {
                Method polarionToolBoxMain = Class.forName("de.gematik.polarion.toolbox.ToolBox").getDeclaredMethod("main", String[].class);
                String[] args = new String[]{"-m", "tcimp", "-dryrun"};
                log.info("Syncing test cases with Polarion...");
                polarionToolBoxMain.invoke(null, (Object[])args);
                log.info("Test cases synched with Polarion...");
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new TigerLibraryException("Unable to access Polarion Toolbox! Be sure to have it included in mvn dependencies.", new Object[]{e});
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new TigerLibraryException("Unable to call Polarion Toolbox's main method!", new Object[]{e});
            }
        }
    }

    public static void beforeTestThreadStart() {
        TigerDirector.assertThatTigerIsInitialized();
        if (proxiesMap.containsKey(TigerDirector.tid())) {
            log.warn("Proxy for given thread '" + TigerDirector.tid() + "' already initialized!");
            return;
        }
        TigerProxy threadProxy = new TigerProxy(tigerTestEnvMgr.getConfiguration().getTigerProxy());
        TigerDirector.getTigerTestEnvMgr().getRoutes().forEach(route -> threadProxy.addRoute(route));
        threadProxy.addRbelMessageListener((IRbelMessageListener)rbelMsgProviderMap.computeIfAbsent(TigerDirector.tid(), key -> new RbelMessageProvider()));
        proxiesMap.putIfAbsent(TigerDirector.tid(), threadProxy);
    }

    public static void createAfoRepoort() {
        TigerDirector.assertThatTigerIsInitialized();
    }

    public static String getProxySettings() {
        TigerDirector.assertThatTigerIsInitialized();
        return tigerTestEnvMgr.getLocalDockerProxy().getBaseUrl();
    }

    public static RbelMessageProvider getRbelMessageProvider() {
        TigerDirector.assertThatTigerIsInitialized();
        return Optional.ofNullable(rbelMsgProviderMap.get(TigerDirector.tid())).orElseThrow(() -> new TigerLibraryException("Tiger has not been initialized for Thread '%s'. Did you call TigerDirector.beforeTestThreadStart for this thread?", TigerDirector.tid()));
    }

    public static long tid() {
        return Thread.currentThread().getId();
    }

    private static void assertThatTigerIsInitialized() {
        if (!OsEnvironment.getAsBoolean((String)"TIGER_ACTIVE")) {
            throw new TigerStartupException("Tiger test environment has not been initialized,as the TIGER_ACTIVE environment variable is not set to '1'.");
        }
        if (!initialized) {
            throw new TigerStartupException("Tiger test environment has not been initialized. Did you call TigerDirector.beforeTestRun before starting test run?");
        }
    }

    static void testUninitialize() {
        initialized = false;
        tigerTestEnvMgr = null;
    }

    static {
        initialized = false;
    }
}

