/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.parser;

import de.gematik.test.tiger.lib.parser.TestParserException;
import de.gematik.test.tiger.lib.parser.model.gherkin.Background;
import de.gematik.test.tiger.lib.parser.model.gherkin.Feature;
import de.gematik.test.tiger.lib.parser.model.gherkin.GherkinStruct;
import de.gematik.test.tiger.lib.parser.model.gherkin.ParseMode;
import de.gematik.test.tiger.lib.parser.model.gherkin.Scenario;
import de.gematik.test.tiger.lib.parser.model.gherkin.ScenarioOutline;
import de.gematik.test.tiger.lib.parser.model.gherkin.Step;
import de.gematik.test.tiger.lib.parser.model.gherkin.Tag;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class FeatureParser {
    public synchronized Feature parseFeatureFile(File f) {
        return this.parseFeatureFile(f.toURI());
    }

    public synchronized Feature parseFeatureFile(URI featureURI) {
        AtomicReference<Feature> feature = new AtomicReference<Feature>();
        AtomicReference<Scenario> child = new AtomicReference<Scenario>();
        StringBuilder description = new StringBuilder();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Step step = null;
        int linectr = 0;
        String excLine = "";
        try {
            String[] lines;
            ParseMode mode = ParseMode.PRESTRUCT;
            String content = IOUtils.toString((URI)featureURI, (Charset)StandardCharsets.UTF_8);
            content = content.replace("\r\n", "\n").replace("\r", "\n");
            boolean docString = false;
            String[] stringArray = lines = content.split("\n");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String line;
                excLine = line = stringArray[i];
                ++linectr;
                if ((line = line.trim()).startsWith("\"\"\"") || line.startsWith("'''")) {
                    boolean bl = docString = !docString;
                }
                if (docString) {
                    if (step == null) {
                        throw new TestParserException("Step not set!");
                    }
                    step.getLines().add(excLine);
                    continue;
                }
                if (line.startsWith("#") || line.isBlank() || this.parseTagsFromLine(line, tags)) continue;
                if (this.parseGherkinStructFromLine(line, tags, feature, child, linectr)) {
                    mode = ParseMode.DESCRIPTION;
                    continue;
                }
                AtomicReference<ParseMode> moderef = new AtomicReference<ParseMode>(mode);
                step = this.getStep(child, description, step, line, excLine, moderef);
                mode = moderef.get();
            }
            ((Feature)feature.get()).setFileName(new File(featureURI).getAbsolutePath());
            return (Feature)feature.get();
        }
        catch (Exception e) {
            throw new TestParserException(String.format("Error in line %d '%s' of file '%s'", linectr, excLine, new File(featureURI).getAbsolutePath()), e);
        }
    }

    private Step getStep(AtomicReference<Scenario> child, StringBuilder description, Step step, String line, String origLine, AtomicReference<ParseMode> moderef) {
        String keyword = Step.getKeyword(line);
        if (moderef.get() == ParseMode.DESCRIPTION) {
            if (!Step.KEYWORDS.contains(keyword)) {
                if (!line.equals("```")) {
                    description.append(line).append("\n");
                }
            } else {
                child.get().setDescription(StringUtils.removeEnd((String)description.toString(), (String)"\n"));
                description.setLength(0);
                step = Step.fromLine(line);
                moderef.set(this.addStepToScenario(child.get(), step));
            }
        } else if (moderef.get() == ParseMode.STEPS || moderef.get() == ParseMode.EXAMPLES) {
            if (Step.KEYWORDS.contains(keyword)) {
                step = Step.fromLine(line);
                moderef.set(this.addStepToScenario(child.get(), step));
            } else if (line.equals("\"\"\"") || line.equals("'''")) {
                step.getLines().add(origLine);
            } else {
                step.getLines().add(line);
            }
        } else {
            throw new TestParserException("Unable to parse line");
        }
        return step;
    }

    private ParseMode addStepToScenario(Scenario sc, Step step) {
        if (step.getKeyword().equals("Examples") || step.getKeyword().equals("Beispiele")) {
            if (sc instanceof ScenarioOutline) {
                ((ScenarioOutline)sc).setExamples(step);
                return ParseMode.EXAMPLES;
            }
            throw new TestParserException("Unable to add Examples section to Scenario '" + sc.getName() + "' which is not an outline");
        }
        sc.getSteps().add(step);
        return ParseMode.STEPS;
    }

    private boolean parseTagsFromLine(String line, List<Tag> tags) {
        if (line.startsWith("@")) {
            Arrays.stream(line.split(" ")).map(Tag::fromString).forEach(tags::add);
            return true;
        }
        return false;
    }

    private boolean parseGherkinStructFromLine(String line, List<Tag> tags, AtomicReference<Feature> feature, AtomicReference<Scenario> child, int lineNumber) {
        int colon = line.indexOf(58);
        if (colon != -1) {
            String structName = line.substring(0, colon).replace(" ", "").replace("\t", "");
            if (!GherkinStruct.STRUCT_NAMES.contains(structName)) {
                return false;
            }
            if (GherkinStruct.STRUCT_I18N_MAP.containsKey(structName)) {
                structName = GherkinStruct.STRUCT_I18N_MAP.get(structName);
            }
            GherkinStruct gs = (GherkinStruct)Class.forName(this.getClass().getPackageName() + ".model.gherkin." + structName).getConstructor(new Class[0]).newInstance(new Object[0]);
            gs.setName(line.substring(colon + 1).trim());
            gs.getTags().addAll(tags);
            tags.clear();
            Optional.of(gs).filter(Feature.class::isInstance).map(Feature.class::cast).ifPresentOrElse(feature::set, () -> {
                if (!(gs instanceof Scenario)) {
                    throw new TestParserException("Unknown Gherkin struct " + gs.getName());
                }
                Scenario sc = (Scenario)gs;
                child.set(sc);
                sc.setFeature((Feature)feature.get());
                sc.setLineNumber(lineNumber);
                if (sc instanceof Background) {
                    ((Feature)feature.get()).setBackground((Background)sc);
                } else {
                    ((Feature)feature.get()).getScenarios().add(sc);
                }
            });
            return true;
        }
        return false;
    }
}

