/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.lib.enums.ModeType;
import de.gematik.test.tiger.lib.rbel.RbelMessageValidator;
import de.gematik.test.tiger.lib.rbel.RequestParameter;
import io.cucumber.java.ParameterType;
import io.cucumber.java.de.Dann;
import io.cucumber.java.de.Gegebensei;
import io.cucumber.java.de.Wenn;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RBelValidatorGlue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RBelValidatorGlue.class);
    static final RbelMessageValidator rbelValidator = new RbelMessageValidator();

    public static RbelMessageValidator getRbelValidator() {
        return rbelValidator;
    }

    @Gegebensei(value="TGR setze Anfrage Timeout auf {int} Sekunden")
    @Given(value="TGR set request wait timeout to {int} seconds")
    public void tgrSetRequestWaitTimeout(int waitsec) {
        TigerGlobalConfiguration.putValue((String)"tiger.rbel.request.timeout", (Object)waitsec, (SourceType)SourceType.TEST_CONTEXT);
    }

    @Wenn(value="TGR l\u00f6sche aufgezeichnete Nachrichten")
    @When(value="TGR clear recorded messages")
    public void tgrClearRecordedMessages() {
        rbelValidator.clearRBelMessages();
    }

    @Wenn(value="TGR filtere Anfragen nach Server {string}")
    @When(value="TGR filter requests based on host {string}")
    public void tgrFilterBasedOnHost(String hostname) {
        TigerGlobalConfiguration.putValue((String)"tiger.rbel.request.filter.host", (String)hostname, (SourceType)SourceType.TEST_CONTEXT);
    }

    @Wenn(value="TGR filtere Anfragen nach HTTP Methode {string}")
    @When(value="TGR filter requests based on method {string}")
    public void tgrFilterBasedOnMethod(String method) {
        TigerGlobalConfiguration.putValue((String)"tiger.rbel.request.filter.method", (String)method.toUpperCase(), (SourceType)SourceType.TEST_CONTEXT);
    }

    @Wenn(value="TGR l\u00f6sche den gesetzten HTTP Methodenfilter")
    @When(value="TGR reset request method filter")
    public void tgrResetRequestMethodFilter() {
        TigerGlobalConfiguration.putValue((String)"tiger.rbel.request.filter.method", null, (SourceType)SourceType.TEST_CONTEXT);
    }

    @Wenn(value="TGR finde die erste Anfrage mit Pfad {string}")
    @When(value="TGR find request to path {string}")
    public void findRequestToPath(String path) {
        rbelValidator.filterRequestsAndStoreInContext(RequestParameter.builder().path(path).build().resolvePlaceholders());
    }

    @Wenn(value="TGR finde die erste Anfrage mit Pfad {string} und Knoten {string} der mit {string} \u00fcbereinstimmt")
    @When(value="TGR find request to path {string} with {string} matching {string}")
    public void findRequestToPathWithCommand(String path, String rbelPath, String value) {
        rbelValidator.filterRequestsAndStoreInContext(RequestParameter.builder().path(path).rbelPath(rbelPath).value(value).build().resolvePlaceholders());
    }

    @Wenn(value="TGR finde die n\u00e4chste Anfrage mit dem Pfad {string}")
    @When(value="TGR find next request to path {string}")
    public void findNextRequestToPath(String path) {
        rbelValidator.filterRequestsAndStoreInContext(RequestParameter.builder().path(path).startFromLastRequest(true).build().resolvePlaceholders());
    }

    @Wenn(value="TGR finde die n\u00e4chste Anfrage mit Pfad {string} und Knoten {string} der mit {string} \u00fcbereinstimmt")
    @When(value="TGR find next request to path {string} with {string} matching {string}")
    public void findNextRequestToPathWithCommand(String path, String rbelPath, String value) {
        rbelValidator.filterRequestsAndStoreInContext(RequestParameter.builder().path(path).rbelPath(rbelPath).value(value).startFromLastRequest(true).build().resolvePlaceholders());
    }

    @Wenn(value="TGR finde die erste Anfrage mit Pfad {string} die den Knoten {string} enth\u00e4lt")
    @When(value="TGR find request to path {string} containing node {string}")
    public void findFirstRequestToPathContainingNode(String path, String rbelPath) {
        rbelValidator.filterRequestsAndStoreInContext(RequestParameter.builder().path(path).rbelPath(rbelPath).build().resolvePlaceholders());
    }

    @Wenn(value="TGR finde die n\u00e4chste Anfrage mit Pfad {string} die den Knoten {string} enth\u00e4lt")
    @When(value="TGR find next request to path {string} containing node {string}")
    public void findNextRequestToPathContainingNode(String path, String rbelPath) {
        rbelValidator.filterRequestsAndStoreInContext(RequestParameter.builder().path(path).rbelPath(rbelPath).build().resolvePlaceholders());
    }

    @Wenn(value="TGR finde die letzte Anfrage mit dem Pfad {string}")
    @When(value="TGR find last request to path {string}")
    public void findLastRequestToPath(String path) {
        rbelValidator.filterRequestsAndStoreInContext(RequestParameter.builder().path(path).filterPreviousRequest(true).build().resolvePlaceholders());
    }

    @Wenn(value="TGR finde die letzte Anfrage mit Pfad {string} und Knoten {string} der mit {string} \u00fcbereinstimmt")
    @When(value="TGR find last request to path {string} with {string} matching {string}")
    public void findLastRequestToPathWithCommand(String path, String rbelPath, String value) {
        rbelValidator.filterRequestsAndStoreInContext(RequestParameter.builder().path(path).rbelPath(rbelPath).value(value).filterPreviousRequest(true).build().resolvePlaceholders());
    }

    @Wenn(value="TGR finde eine Nachricht mit Knoten {string} der mit {string} \u00fcbereinstimmt")
    @When(value="TGR any message with attribute {string} matches {string}")
    public void findAnyMessageAttributeMatches(String rbelPath, String value) {
        rbelValidator.findAnyMessageMatchingAtNode(rbelPath, TigerGlobalConfiguration.resolvePlaceholders((String)value));
    }

    @Dann(value="TGR speichere Wert des Knotens {string} der aktuellen Antwort in der Variable {string}")
    @Then(value="TGR store current response node text value at {string} in variable {string}")
    public void storeCurrentResponseNodeTextValueInVariable(String rbelPath, String varName) {
        String text = rbelValidator.findElementsInCurrentResponse(rbelPath).stream().map(RbelElement::getRawStringContent).filter(Objects::nonNull).map(String::trim).collect(Collectors.joining());
        TigerGlobalConfiguration.putValue((String)varName, (String)text, (SourceType)SourceType.TEST_CONTEXT);
        log.info(String.format("Storing '%s' in variable '%s'", text, varName));
    }

    @Dann(value="TGR ersetze {string} mit {string} im Inhalt der Variable {string}")
    @Then(value="TGR replace {string} with {string} in content of variable {string}")
    public void replaceContentOfVariable(String regexPattern, String replace, String varName) {
        Optional content = TigerGlobalConfiguration.readStringOptional((String)varName);
        ((OptionalAssert)Assertions.assertThat((Optional)content).withFailMessage("No configuration property '" + varName + "' found!", new Object[0])).isNotEmpty();
        String newContent = ((String)content.get()).replaceAll(regexPattern, replace);
        TigerGlobalConfiguration.putValue((String)varName, (String)newContent, (SourceType)SourceType.TEST_CONTEXT);
        log.info(String.format("Modified content in variable '%s' to '%s'", varName, newContent));
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort stimmt im Body \u00fcberein mit:")
    @Then(value="TGR current response body matches:")
    public void currentResponseBodyMatches(String docString) {
        this.currentResponseMessageAttributeMatches("$.body", docString);
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort enth\u00e4lt Knoten {string}")
    @Then(value="TGR current response contains node {string}")
    public void currentResponseMessageContainsNode(String rbelPath) {
        Assertions.assertThat(rbelValidator.findElementsInCurrentResponse(TigerGlobalConfiguration.resolvePlaceholders((String)rbelPath))).isNotEmpty();
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort stimmt im Knoten {string} \u00fcberein mit {string}")
    @Then(value="TGR current response with attribute {string} matches {string}")
    public void currentResponseMessageAttributeMatches(String rbelPath, String value) {
        rbelValidator.assertAttributeOfCurrentResponseMatches(TigerGlobalConfiguration.resolvePlaceholders((String)rbelPath), TigerGlobalConfiguration.resolvePlaceholders((String)value), true);
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort stimmt im Knoten {string} nicht \u00fcberein mit {string}")
    @Then(value="TGR current response with attribute {string} does not match {string}")
    public void currentResponseMessageAttributeDoesNotMatch(String rbelPath, String value) {
        rbelValidator.assertAttributeOfCurrentResponseMatches(TigerGlobalConfiguration.resolvePlaceholders((String)rbelPath), TigerGlobalConfiguration.resolvePlaceholders((String)value), false);
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort im Knoten {string} stimmt \u00fcberein mit:")
    @Then(value="TGR current response at {string} matches:")
    public void currentResponseMessageAtMatchesDocString(String rbelPath, String docString) {
        this.currentResponseMessageAttributeMatches(rbelPath, docString);
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort im Knoten {string} stimmt nicht \u00fcberein mit:")
    @Then(value="TGR current response at {string} does not match:")
    public void currentResponseMessageAtDoesNotMatchDocString(String rbelPath, String docString) {
        rbelValidator.assertAttributeOfCurrentResponseMatches(TigerGlobalConfiguration.resolvePlaceholders((String)rbelPath), TigerGlobalConfiguration.resolvePlaceholders((String)docString), false);
    }

    @Then(value="TGR current response at {string} matches {string}")
    public void currentResponseMessageAtMatches(String rbelPath, String value) {
        rbelValidator.assertAttributeOfCurrentResponseMatches(TigerGlobalConfiguration.resolvePlaceholders((String)rbelPath), TigerGlobalConfiguration.resolvePlaceholders((String)value), true);
    }

    @ParameterType(value="XML|JSON")
    public ModeType ModeType(String mode) {
        return ModeType.valueOf(mode);
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort im Knoten {string} stimmt als {ModeType} \u00fcberein mit:")
    @Then(value="TGR current response at {string} matches as {ModeType}:")
    public void currentResponseAtMatchesAsJsonOrXml(String rbelPath, ModeType mode, String oracleDocStr) {
        rbelValidator.assertAttributeOfCurrentResponseMatchesAs(TigerGlobalConfiguration.resolvePlaceholders((String)rbelPath), mode, TigerGlobalConfiguration.resolvePlaceholders((String)oracleDocStr));
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort im Knoten {string} stimmt als XML mit folgenden diff Optionen {string} \u00fcberein mit:")
    @Then(value="TGR current response at {string} matches as XML and diff options {string}:")
    public void currentResponseAtMatchesAsXMLAndDiffOptions(String rbelPath, String diffOptionsCSV, String xmlDocStr) {
        rbelValidator.compareXMLStructureOfRbelElement(rbelValidator.findElementInCurrentResponse(TigerGlobalConfiguration.resolvePlaceholders((String)rbelPath)), TigerGlobalConfiguration.resolvePlaceholders((String)xmlDocStr), diffOptionsCSV);
    }

    @Dann(value="TGR gebe aktuelle Response als Rbel-Tree aus")
    @Then(value="TGR print current response as rbel-tree")
    public void printCurrentResponse() {
        System.out.println(RBelValidatorGlue.getRbelValidator().getCurrentResponse().printTreeStructure());
    }

    @Dann(value="TGR gebe aktuelle Request als Rbel-Tree aus")
    @Then(value="TGR print current request as rbel-tree")
    public void printCurrentRequest() {
        System.out.println(RBelValidatorGlue.getRbelValidator().getCurrentRequest().printTreeStructure());
    }
}

