/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.json;

import java.util.Iterator;
import net.thucydides.core.annotations.Step;
import org.apache.commons.collections.IteratorUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.skyscreamer.jsonassert.Customization;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.comparator.CustomComparator;
import org.skyscreamer.jsonassert.comparator.JSONComparator;

public class JsonChecker {
    public static final String IGNORE_JSON_VALUE = "${json-unit.ignore}";
    final CustomComparator customComparator = new CustomComparator(JSONCompareMode.LENIENT, new Customization[]{new Customization("***", (oracleJson, testJson) -> {
        try {
            new JSONObject(testJson.toString());
            new JSONObject(oracleJson.toString());
            this.assertJsonObjectShouldMatchOrContainInAnyOrder(testJson.toString(), oracleJson.toString(), true);
        }
        catch (RuntimeException e) {
            try {
                new JSONArray(testJson.toString());
                new JSONArray(oracleJson.toString());
                this.assertJsonArrayShouldMatchInAnyOrder(testJson.toString(), oracleJson.toString());
            }
            catch (RuntimeException e2) {
                return oracleJson.toString().equals(IGNORE_JSON_VALUE) || testJson.toString().equals(oracleJson.toString()) || testJson.toString().matches(oracleJson.toString());
            }
        }
        return true;
    })}){

        protected void compareJSONArrayOfJsonObjects(String key, JSONArray expected, JSONArray actual, JSONCompareResult result) throws JSONException {
            if (expected.length() == 1 && actual.length() == 1) {
                this.compareJSON(expected.getJSONObject(0), actual.getJSONObject(0));
                return;
            }
            super.compareJSONArrayOfJsonObjects(key, expected, actual, result);
        }
    };

    @Step
    public void assertJsonArrayShouldMatchInAnyOrder(String json, String oracle) {
        JSONAssert.assertEquals((String)oracle, (String)json, (JSONComparator)new CustomComparator(JSONCompareMode.LENIENT, new Customization[]{new Customization("***", (oracleJson, testJson) -> {
            if (testJson instanceof JSONObject) {
                this.assertJsonObjectShouldMatchOrContainInAnyOrder(testJson.toString(), oracleJson.toString(), true);
                return true;
            }
            if (testJson instanceof JSONArray) {
                this.assertJsonArrayShouldMatchInAnyOrder(testJson.toString(), oracleJson.toString());
                return true;
            }
            return IGNORE_JSON_VALUE.equals(oracleJson) || testJson.toString().equals(oracleJson.toString()) || testJson.toString().matches(oracleJson.toString());
        })}));
    }

    @Step
    public void assertJsonObjectShouldMatchOrContainInAnyOrder(String jsonStr, String oracleStr, boolean checkExtraAttributes) {
        JSONObject json = null;
        JSONObject oracle = null;
        try {
            json = this.convertToJsonObject(jsonStr);
            oracle = this.convertToJsonObject(oracleStr);
            for (String oracleKey : oracle.keySet()) {
                if (oracleKey.startsWith("____") || json.has(oracleKey)) continue;
                throw new JsonCheckerAssertionError("Expected JSON to have key '" + oracleKey + "', but only found keys '" + json.keySet() + "'");
            }
            if (checkExtraAttributes) {
                JSONObject finalOracle = oracle;
                json.keySet().forEach(key -> ((AbstractBooleanAssert)Assertions.assertThat((finalOracle.has(key) || finalOracle.has("____" + key) ? 1 : 0) != 0).withFailMessage("EXTRA Key " + key + " detected in received in JSON", new Object[0])).isTrue());
            }
            this.compareAllAttributes(json, oracle);
        }
        catch (NoSuchMethodError nsme) {
            Assertions.fail((String)this.dumpComparisonBetween("JSON does not match!\nExpected:\n%s\n\n--------\n\nReceived:\n%s", null, oracle == null ? "Oracle is null" : oracle.toString(2), json == null ? "Received is null" : json.toString(2)), (Throwable)nsme);
        }
    }

    private JSONObject convertToJsonObject(String jsonStr) {
        try {
            return new JSONObject(jsonStr);
        }
        catch (RuntimeException e) {
            throw new JsonCheckerConversionException(jsonStr);
        }
    }

    private void compareAllAttributes(JSONObject json, JSONObject oracle) {
        Iterator keyIt = oracle.keys();
        while (keyIt.hasNext()) {
            String oracleKey = (String)keyIt.next();
            boolean optionalAttribute = oracleKey.startsWith("____");
            String jsonKey = optionalAttribute ? oracleKey.substring(4) : oracleKey;
            String oracleValue = oracle.get(oracleKey).toString();
            if (optionalAttribute && !json.has(jsonKey) || "$NULL".equals(oracleValue) && json.get(jsonKey) == JSONObject.NULL || IGNORE_JSON_VALUE.equals(oracleValue)) continue;
            if (!json.get(jsonKey).getClass().equals(oracle.get(oracleKey).getClass())) {
                throw new JsonCheckerAssertionError("Expected an '" + oracle.get(jsonKey).getClass().getSimpleName() + "' at key '" + jsonKey + "', but found '" + json.get(jsonKey).getClass().getSimpleName() + "'");
            }
            if (oracle.get(oracleKey) instanceof JSONObject) {
                this.assertJsonObjectShouldMatchOrContainInAnyOrder(json.get(jsonKey).toString(), oracle.get(oracleKey).toString(), true);
                continue;
            }
            if (oracle.get(oracleKey) instanceof JSONArray) {
                JSONAssert.assertEquals((String)oracle.get(oracleKey).toString(), (String)json.get(jsonKey).toString(), (JSONComparator)this.customComparator);
                continue;
            }
            String jsoValue = json.get(jsonKey).toString();
            if (jsoValue.equals(oracleValue)) continue;
            try {
                ((AbstractStringAssert)Assertions.assertThat((String)jsoValue).withFailMessage(this.dumpComparisonAtKeyDiffer(oracleKey, oracleValue, jsoValue), new Object[0])).matches((CharSequence)oracleValue);
            }
            catch (RuntimeException ex) {
                Assertions.fail((String)this.dumpComparisonAtKeyDiffer(oracleKey, oracleValue, jsoValue));
            }
        }
    }

    @Step
    public void assertJsonAttributeShouldMatch(JSONObject json, String claimName, String regex) {
        if (regex != null && regex.equals("$REMOVE")) {
            Assertions.assertThat((Object[])IteratorUtils.toArray((Iterator)json.keys())).doesNotContain(new Object[]{claimName});
            return;
        }
        Assertions.assertThat((Object[])IteratorUtils.toArray((Iterator)json.keys())).contains(new Object[]{claimName});
        if (regex == null) {
            if (json.get(claimName) != JSONObject.NULL) {
                Assertions.assertThat((Object)json.get(claimName)).isNull();
            }
            return;
        }
        String jsoValue = json.get(claimName).toString();
        if (!jsoValue.equals(regex)) {
            ((AbstractStringAssert)Assertions.assertThat((String)jsoValue).withFailMessage(this.dumpComparisonAtKeyDiffer(claimName, regex, jsoValue), new Object[0])).matches((CharSequence)regex);
        }
    }

    @Step
    public void assertJsonAttributeShouldNotMatch(JSONObject json, String claimName, String regex) {
        Assertions.assertThat((Object[])IteratorUtils.toArray((Iterator)json.keys())).contains(new Object[]{claimName});
        if (regex == null) {
            Assertions.assertThat((Object)json.get(claimName)).isNotEqualTo(JSONObject.NULL);
            Assertions.assertThat((Object)json.get(claimName)).isNotNull();
        } else {
            String jsoValue = json.get(claimName).toString();
            if (!jsoValue.equals(regex)) {
                ((AbstractStringAssert)Assertions.assertThat((String)jsoValue).withFailMessage(this.dumpComparisonAtKeyDiffer(claimName, regex, jsoValue), new Object[0])).doesNotMatch((CharSequence)regex);
            } else {
                Assertions.fail((String)this.dumpComparisonAtKeyDiffer(claimName, regex, jsoValue));
            }
        }
    }

    private String dumpComparisonAtKeyDiffer(String key, String expected, String received) {
        return this.dumpComparisonBetween("JSON object does match at key '%s'\nExpected:\n%s\n\n--------\n\nReceived:\n%s", key, expected, received);
    }

    private String dumpComparisonBetween(String pattern, String key, String expected, String received) {
        if (key != null) {
            return String.format(pattern, key, expected, received);
        }
        return String.format(pattern, expected, received);
    }

    static class JsonCheckerAssertionError
    extends AssertionError {
        public JsonCheckerAssertionError(String s) {
            super((Object)s);
        }
    }

    static class JsonCheckerConversionException
    extends RuntimeException {
        public JsonCheckerConversionException(String failingJsonString) {
            super("Exception while trying to convert '" + failingJsonString + "' to JSON-Object");
        }
    }
}

