/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.LocalProxyRbelMessageListener;
import de.gematik.test.tiger.common.exceptions.TigerOsException;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.parser.FeatureParser;
import de.gematik.test.tiger.lib.parser.model.gherkin.Feature;
import de.gematik.test.tiger.lib.parser.model.gherkin.Scenario;
import de.gematik.test.tiger.lib.parser.model.gherkin.ScenarioOutline;
import de.gematik.test.tiger.lib.parser.model.gherkin.Step;
import de.gematik.test.tiger.proxy.data.MessageMetaDataDto;
import de.gematik.test.tiger.testenvmgr.env.FeatureUpdate;
import de.gematik.test.tiger.testenvmgr.env.ScenarioUpdate;
import de.gematik.test.tiger.testenvmgr.env.StepUpdate;
import de.gematik.test.tiger.testenvmgr.env.TestResult;
import de.gematik.test.tiger.testenvmgr.env.TigerStatusUpdate;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import net.serenitybdd.core.Serenity;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerCucumberListener
implements ConcurrentEventListener,
Plugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerCucumberListener.class);
    private static String bulmaModalJsScript = null;
    private final Map<URI, Feature> uriFeatureMap = new HashMap<URI, Feature>();
    private final Map<String, Feature> idFeatureMap = new HashMap<String, Feature>();
    private final Map<String, List<Step>> scenarioStepsMap = new HashMap<String, List<Step>>();
    private String currentScenarioId;
    private int currentStepIndex;
    private int currentScenarioDataVariantIndex = -1;
    private List<String> currentScenarioDataVariantKeys = null;
    private List<Map<String, String>> currentScenarioDataVariant = null;
    private int scPassed = 0;
    private int scFailed = 0;
    private final Pattern showSteps = Pattern.compile(".*TGR (zeige|show) ([\\w|\u00fc\u00df ]*)(Banner|banner|text|Text) \"(.*)\"");
    private final EventHandler<TestSourceRead> sourceRead = event -> {
        log.debug("Parsing feature file {}", (Object)event.getUri());
        this.uriFeatureMap.put(event.getUri(), new FeatureParser().parseFeatureFile(event.getUri()));
    };
    private final EventHandler<TestCaseStarted> caseStarted = testcase -> {
        log.debug("Starting scenario {}", (Object)testcase.getTestCase().getName());
        this.currentScenarioId = testcase.getTestCase().getId().toString();
        Feature feature = this.uriFeatureMap.get(testcase.getTestCase().getUri());
        this.idFeatureMap.computeIfAbsent(this.currentScenarioId, id -> feature);
        String scenarioName = testcase.getTestCase().getName();
        Scenario scenario = feature.getScenario(scenarioName, testcase.getTestCase().getLocation().getLine());
        scenario.setId(this.currentScenarioId);
        this.scenarioStepsMap.computeIfAbsent(this.currentScenarioId, id -> scenario.getSteps());
        this.processDataVariantsForScenarioOutlines(scenario);
        if (feature.getBackground() != null && this.currentScenarioDataVariantIndex < 1) {
            this.scenarioStepsMap.get(this.currentScenarioId).addAll(0, feature.getBackground().getSteps());
        }
        this.informWorkflowUiAboutCurrentScenario(feature, scenario);
        this.currentStepIndex = 0;
        LocalProxyRbelMessageListener.clearMessages();
    };
    private final EventHandler<TestStepStarted> stepStarted = event -> {
        Step currentStep;
        String stepText;
        Matcher m;
        if (!(event.getTestStep() instanceof PickleStepTestStep)) {
            return;
        }
        log.debug("Processing step {}", (Object)this.currentStepIndex);
        if (TigerDirector.getLibConfig().isActivateWorkflowUi() && (m = this.showSteps.matcher(stepText = String.join((CharSequence)"\n", (currentStep = this.getCurrentStep(this.currentScenarioId, this.currentStepIndex)).getLines()))).find()) {
            TigerDirector.getTigerTestEnvMgr().receiveTestEnvUpdate(TigerStatusUpdate.builder().bannerColor(m.group(2)).bannerMessage(m.group(4)).build());
        }
        ++this.currentStepIndex;
    };
    private final EventHandler<TestStepFinished> stepFinished = event -> {
        if (!(event.getTestStep() instanceof PickleStepTestStep)) {
            return;
        }
        log.debug("Finished step {}", (Object)this.currentStepIndex);
        if (TigerDirector.getLibConfig().isAddCurlCommandsForRaCallsToReport() && TigerDirector.isSerenityAvailable() && TigerDirector.curlLoggingFilter != null) {
            TigerDirector.curlLoggingFilter.printToReport();
        }
        this.informWorkflowUiAboutCurrentStep(this.currentScenarioId, event.getResult().getStatus().name());
    };
    private final EventHandler<TestCaseFinished> caseFinished = testcase -> {
        String scenarioStatus;
        log.info("Finished scenario {}", (Object)testcase.getTestCase().getName());
        String scenarioName = testcase.getTestCase().getName();
        URI scenarioUri = testcase.getTestCase().getUri();
        switch (scenarioStatus = testcase.getResult().getStatus().toString()) {
            case "PASSED": {
                ++this.scPassed;
                break;
            }
            case "FAILED": {
                ++this.scFailed;
            }
        }
        log.info("------------ STATUS: {} passed {}", (Object)this.scPassed, this.scFailed > 0 ? this.scFailed + " failed" : "");
        this.createRbelLogReport(scenarioName, scenarioUri);
        this.scenarioStepsMap.remove(this.currentScenarioId);
        if (this.currentScenarioDataVariantIndex != -1 && this.currentScenarioDataVariantIndex + 1 == this.currentScenarioDataVariant.size()) {
            this.currentScenarioDataVariantIndex = -1;
        }
    };

    public void setEventPublisher(EventPublisher eventPublisher) {
        eventPublisher.registerHandlerFor(TestSourceRead.class, this.sourceRead);
        eventPublisher.registerHandlerFor(TestCaseStarted.class, this.caseStarted);
        eventPublisher.registerHandlerFor(TestStepStarted.class, this.stepStarted);
        eventPublisher.registerHandlerFor(TestStepFinished.class, this.stepFinished);
        eventPublisher.registerHandlerFor(TestCaseFinished.class, this.caseFinished);
    }

    private void informWorkflowUiAboutCurrentScenario(Feature feature, Scenario scenario) {
        TigerDirector.getTigerTestEnvMgr().receiveTestEnvUpdate(TigerStatusUpdate.builder().featureMap(new LinkedHashMap<String, FeatureUpdate>(Map.of(feature.getName(), FeatureUpdate.builder().description(feature.getName()).scenarios(new LinkedHashMap<String, ScenarioUpdate>(Map.of(this.mapScenarioToScenarioUpdateMap(scenario), ScenarioUpdate.builder().description(scenario.getName()).variantIndex(this.currentScenarioDataVariantIndex).exampleKeys(this.currentScenarioDataVariantIndex != -1 ? this.currentScenarioDataVariantKeys : null).exampleList(this.currentScenarioDataVariantIndex != -1 ? this.currentScenarioDataVariant.get(this.currentScenarioDataVariantIndex) : null).steps(this.mapStepsToStepUpdateMap(scenario.getSteps(), line -> scenario instanceof ScenarioOutline && this.currentScenarioDataVariantIndex != -1 ? this.replaceLineWithCurrentDataVariantValues((String)line) : line)).build()))).build()))).build());
    }

    private String mapScenarioToScenarioUpdateMap(Scenario scenario) {
        if (scenario instanceof ScenarioOutline && this.currentScenarioDataVariantIndex != -1) {
            return this.currentScenarioDataVariantIndex + "-" + scenario.getId();
        }
        return scenario.getId();
    }

    private String replaceLineWithCurrentDataVariantValues(String line) {
        String parsedLine = line;
        for (String key : this.currentScenarioDataVariantKeys) {
            parsedLine = parsedLine.replace("<" + key + ">", this.currentScenarioDataVariant.get(this.currentScenarioDataVariantIndex).get(key));
        }
        return parsedLine;
    }

    @NotNull
    private Map<String, StepUpdate> mapStepsToStepUpdateMap(List<Step> steps, Function<String, String> postProduction) {
        HashMap<String, StepUpdate> map = new HashMap<String, StepUpdate>();
        for (int stepIndex = 0; stepIndex < steps.size(); ++stepIndex) {
            if (map.put(Integer.toString(stepIndex), StepUpdate.builder().description(postProduction.apply(String.join((CharSequence)"\n", steps.get(stepIndex).getLines()))).status(TestResult.PENDING).stepIndex(stepIndex).build()) == null) continue;
            throw new IllegalStateException("Duplicate key");
        }
        return map;
    }

    private void processDataVariantsForScenarioOutlines(Scenario tigerScenario) {
        if (tigerScenario instanceof ScenarioOutline) {
            if (this.currentScenarioDataVariantIndex == -1) {
                this.currentScenarioDataVariant = ((ScenarioOutline)tigerScenario).getExamplesAsList();
                this.currentScenarioDataVariantKeys = ((ScenarioOutline)tigerScenario).getExampleKeys();
                this.currentScenarioDataVariantIndex = 0;
            } else {
                ++this.currentScenarioDataVariantIndex;
            }
        } else {
            this.currentScenarioDataVariantIndex = -1;
            this.currentScenarioDataVariant = null;
        }
    }

    private Step getCurrentStep(String scenarioId, Integer stepIndex) {
        Step currentStep = this.scenarioStepsMap.get(scenarioId).get(stepIndex);
        if (this.currentScenarioDataVariantIndex != -1) {
            List<String> parsedLines = currentStep.getLines().stream().map(this::replaceLineWithCurrentDataVariantValues).collect(Collectors.toList());
            currentStep = new Step(currentStep.getKeyword(), parsedLines);
        }
        return currentStep;
    }

    private void informWorkflowUiAboutCurrentStep(String scenarioId, String status) {
        Feature feature = this.idFeatureMap.get(this.currentScenarioId);
        Scenario scenario = feature.getScenarioById(scenarioId);
        Step currentStep = this.getCurrentStep(scenarioId, this.currentStepIndex - 1);
        TigerStatusUpdate.TigerStatusUpdateBuilder builder = TigerStatusUpdate.builder();
        Matcher m = this.showSteps.matcher(currentStep.getLines().get(0));
        if (m.find()) {
            Color col;
            try {
                col = !m.group(2).trim().isEmpty() ? (Color)Color.class.getDeclaredField(RbelAnsiColors.seekColor((String)m.group(2).trim()).name().toUpperCase()).get(null) : Color.BLACK;
            }
            catch (Exception ignored) {
                col = Color.BLACK;
            }
            builder.bannerMessage(m.group(4)).bannerColor(String.format("#%06X", 0xFFFFFF & col.getRGB()));
        }
        List stepMessagesMetaDataList = new ArrayList<RbelElement>(LocalProxyRbelMessageListener.getStepRbelMessages()).stream().map(MessageMetaDataDto::createFrom).collect(Collectors.toList());
        TigerDirector.getTigerTestEnvMgr().receiveTestEnvUpdate(builder.featureMap(new LinkedHashMap<String, FeatureUpdate>(Map.of(feature.getName(), FeatureUpdate.builder().description(feature.getName()).scenarios(new LinkedHashMap<String, ScenarioUpdate>(Map.of(this.mapScenarioToScenarioUpdateMap(scenario), ScenarioUpdate.builder().description(scenario.getName()).variantIndex(this.currentScenarioDataVariantIndex).exampleKeys(this.currentScenarioDataVariantIndex != -1 ? this.currentScenarioDataVariantKeys : Collections.emptyList()).exampleList(this.currentScenarioDataVariantIndex != -1 ? this.currentScenarioDataVariant.get(this.currentScenarioDataVariantIndex) : Collections.emptyMap()).steps(new HashMap<String, StepUpdate>(Map.of(String.valueOf(this.currentStepIndex - 1), StepUpdate.builder().description(String.join((CharSequence)"\n", currentStep.getLines())).status(TestResult.valueOf((String)status)).stepIndex(this.currentStepIndex - 1).rbelMetaData(stepMessagesMetaDataList).build()))).build()))).build()))).build());
        LocalProxyRbelMessageListener.getStepRbelMessages().clear();
    }

    private void createRbelLogReport(String scenarioName, URI scenarioUri) {
        try {
            File folder = Paths.get("target", "rbellogs").toFile();
            if (!folder.exists() && !folder.mkdirs()) {
                throw new TigerOsException("Unable to create folder '" + folder.getAbsolutePath() + "'");
            }
            RbelHtmlRenderer rbelRenderer = new RbelHtmlRenderer();
            rbelRenderer.setSubTitle("<p><b>" + scenarioName + "</b>&nbsp&nbsp;" + (String)(this.currentScenarioDataVariantIndex != -1 ? "<button class=\"js-modal-trigger\" data-target=\"modal-data-variant\">Variant " + (this.currentScenarioDataVariantIndex + 1) + "</button>" : "") + "</p><p><i>" + scenarioUri + "</i></p>");
            String html = rbelRenderer.doRender(LocalProxyRbelMessageListener.getMessages());
            if (this.currentScenarioDataVariantIndex != -1) {
                StringBuilder modal = new StringBuilder("<div id=\"modal-data-variant\" class=\"modal\">\n  <div class=\"modal-background\"></div>\n  <div class=\"modal-content\">\n    <div class=\"box\"><h2>Scenario Data</h2><table class=\"table is-striped is-hoverable is-fullwidth\">\n");
                for (Map.Entry<String, String> entry : this.currentScenarioDataVariant.get(this.currentScenarioDataVariantIndex).entrySet()) {
                    modal.append("<tr><th>").append(entry.getKey()).append("</th><td>").append(entry.getValue()).append("</td></tr>");
                }
                modal.append("    </table></div>\n</div>\n</div>\n");
                if (bulmaModalJsScript == null) {
                    bulmaModalJsScript = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/js/bulma-modal.js"), (Charset)StandardCharsets.UTF_8);
                }
            }
            String name = this.getFileNameFor(scenarioName, this.currentScenarioDataVariantIndex);
            File logFile = Paths.get("target", "rbellogs", name).toFile();
            FileUtils.writeStringToFile((File)logFile, (String)html, (Charset)StandardCharsets.UTF_8);
            if (TigerDirector.isSerenityAvailable()) {
                Serenity.recordReportData().asEvidence().withTitle("RBellog " + (this.currentScenarioDataVariantIndex + 1)).downloadable().fromFile(logFile.toPath());
            }
            log.info("Saved HTML report of scenario '{}' to {}", (Object)scenarioName, (Object)logFile.getAbsolutePath());
        }
        catch (Exception e) {
            log.error("Unable to create/save rbel log for scenario " + scenarioName, (Throwable)e);
        }
    }

    @NotNull
    public String getFileNameFor(String scenarioName, int dataVariantIndex) {
        Object name = scenarioName;
        String map = "\u00e4a\u00c4A\u00f6o\u00d6O\u00fcu\u00dcU\u00dfs _(_)_[_]_{_}_<_>_|_$_%_&_/_\\_?_:_*_\"_";
        for (int i = 0; i < "\u00e4a\u00c4A\u00f6o\u00d6O\u00fcu\u00dcU\u00dfs _(_)_[_]_{_}_<_>_|_$_%_&_/_\\_?_:_*_\"_".length(); i += 2) {
            name = ((String)name).replace("\u00e4a\u00c4A\u00f6o\u00d6O\u00fcu\u00dcU\u00dfs _(_)_[_]_{_}_<_>_|_$_%_&_/_\\_?_:_*_\"_".charAt(i), "\u00e4a\u00c4A\u00f6o\u00d6O\u00fcu\u00dcU\u00dfs _(_)_[_]_{_}_<_>_|_$_%_&_/_\\_?_:_*_\"_".charAt(i + 1));
        }
        if (((String)name).length() > 100) {
            name = ((String)name).substring(0, 60) + UUID.nameUUIDFromBytes(((String)name).getBytes(StandardCharsets.UTF_8));
        }
        if (dataVariantIndex != -1) {
            name = (String)name + "_" + (dataVariantIndex + 1);
        }
        return (String)name + ".html";
    }

    @Generated
    public Map<URI, Feature> getUriFeatureMap() {
        return this.uriFeatureMap;
    }

    @Generated
    public Map<String, Feature> getIdFeatureMap() {
        return this.idFeatureMap;
    }

    @Generated
    public Map<String, List<Step>> getScenarioStepsMap() {
        return this.scenarioStepsMap;
    }

    @Generated
    public String getCurrentScenarioId() {
        return this.currentScenarioId;
    }

    @Generated
    public int getCurrentStepIndex() {
        return this.currentStepIndex;
    }

    @Generated
    public int getCurrentScenarioDataVariantIndex() {
        return this.currentScenarioDataVariantIndex;
    }

    @Generated
    public List<String> getCurrentScenarioDataVariantKeys() {
        return this.currentScenarioDataVariantKeys;
    }

    @Generated
    public List<Map<String, String>> getCurrentScenarioDataVariant() {
        return this.currentScenarioDataVariant;
    }

    @Generated
    public int getScPassed() {
        return this.scPassed;
    }

    @Generated
    public int getScFailed() {
        return this.scFailed;
    }

    @Generated
    public Pattern getShowSteps() {
        return this.showSteps;
    }

    @Generated
    public EventHandler<TestSourceRead> getSourceRead() {
        return this.sourceRead;
    }

    @Generated
    public EventHandler<TestCaseStarted> getCaseStarted() {
        return this.caseStarted;
    }

    @Generated
    public EventHandler<TestStepStarted> getStepStarted() {
        return this.stepStarted;
    }

    @Generated
    public EventHandler<TestStepFinished> getStepFinished() {
        return this.stepFinished;
    }

    @Generated
    public EventHandler<TestCaseFinished> getCaseFinished() {
        return this.caseFinished;
    }
}

