/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.rbel;

import com.google.common.collect.ImmutableList;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelHttpHeaderFacet;
import de.gematik.rbellogger.data.facet.RbelHttpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.util.RbelPathExecutor;
import de.gematik.test.tiger.LocalProxyRbelMessageListener;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import de.gematik.test.tiger.lib.TigerLibraryException;
import de.gematik.test.tiger.lib.rbel.RequestParameter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.xml.transform.Source;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.Diff;

public class RbelMessageValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelMessageValidator.class);
    private static final Map<String, Function<DiffBuilder, DiffBuilder>> diffOptionMap = new HashMap<String, Function<DiffBuilder, DiffBuilder>>();
    private static final List<String> emptyPath;
    protected RbelElement currentRequest;
    protected RbelElement currentResponse;

    public RbelMessageValidator() {
        TigerJexlExecutor.registerAdditionalNamespace((String)"rbel", (Object)new JexlToolbox());
    }

    public List<RbelElement> getRbelMessages() {
        return LocalProxyRbelMessageListener.getValidatableRbelMessages();
    }

    public void clearRBelMessages() {
        LocalProxyRbelMessageListener.getValidatableRbelMessages().clear();
    }

    public void filterRequestsAndStoreInContext(RequestParameter requestParameter) {
        int waitsec = TigerGlobalConfiguration.readIntegerOptional((String)"tiger.rbel.request.timeout").orElse(5);
        this.currentRequest = this.findRequestByDescription(requestParameter);
        try {
            Awaitility.await((String)"Waiting for matching response").atMost((long)waitsec, TimeUnit.SECONDS).pollInterval(500L, TimeUnit.MILLISECONDS).until(() -> this.getRbelMessages().stream().filter(e -> e.hasFacet(RbelHttpResponseFacet.class)).filter(resp -> ((RbelHttpResponseFacet)resp.getFacetOrFail(RbelHttpResponseFacet.class)).getRequest() == this.currentRequest).peek(rbelElement -> {
                this.currentResponse = rbelElement;
            }).findAny().isPresent());
        }
        catch (ConditionTimeoutException cte) {
            log.error("Missing response message to filtered request!\n\n{}", (Object)this.currentRequest.getRawStringContent());
            throw new TigerLibraryException("Missing response message to filtered request!", new Object[]{cte});
        }
    }

    protected RbelElement findRequestByDescription(RequestParameter requestParameter) {
        int waitsec = TigerGlobalConfiguration.readIntegerOptional((String)"tiger.rbel.request.timeout").orElse(5);
        AtomicReference candidate = new AtomicReference();
        try {
            Awaitility.await((String)"Waiting for matching request").atMost((long)waitsec, TimeUnit.SECONDS).pollDelay(0L, TimeUnit.SECONDS).pollInterval(400L, TimeUnit.MILLISECONDS).until(() -> {
                Optional<RbelElement> found = this.filterRequests(requestParameter);
                found.ifPresent(candidate::set);
                return found.isPresent();
            });
        }
        catch (ConditionTimeoutException cte) {
            log.error("Didn't find any matching request!");
            this.printAllPathsOfMessages(this.getRbelMessages());
            if (requestParameter.getRbelPath() == null) {
                throw new AssertionError((Object)("No request with path '" + requestParameter.getPath() + "' found in messages"));
            }
            throw new AssertionError((Object)("No request with path '" + requestParameter.getPath() + "' and rbelPath '" + requestParameter.getRbelPath() + "' matching '" + StringUtils.abbreviate((String)requestParameter.getValue(), (int)300) + "' found in messages"));
        }
        return (RbelElement)candidate.get();
    }

    protected Optional<RbelElement> filterRequests(RequestParameter requestParameter) {
        List<RbelElement> msgs = this.getRbelMessages();
        if (requestParameter.isStartFromLastRequest()) {
            RbelElement prevRequest = this.getCurrentRequest();
            int idx = -1;
            for (int i = 0; i < msgs.size(); ++i) {
                if (msgs.get(i) != prevRequest) continue;
                idx = i;
                break;
            }
            msgs = new ArrayList<RbelElement>(msgs.subList(idx + 2, msgs.size()));
        }
        String hostFilter = TigerGlobalConfiguration.readString((String)"tiger.rbel.request.filter.host", (String)"");
        String methodFilter = TigerGlobalConfiguration.readString((String)"tiger.rbel.request.filter.method", (String)"");
        List<RbelElement> candidateMessages = msgs.stream().filter(el -> el.hasFacet(RbelHttpRequestFacet.class)).filter(req -> this.doesPathOfMessageMatch((RbelElement)req, requestParameter.getPath())).filter(req -> hostFilter == null || hostFilter.isEmpty() || this.doesHostMatch((RbelElement)req, hostFilter)).filter(req -> methodFilter == null || methodFilter.isEmpty() || this.doesMethodMatch((RbelElement)req, methodFilter)).collect(Collectors.toList());
        if (candidateMessages.isEmpty()) {
            return Optional.empty();
        }
        if (StringUtils.isEmpty((CharSequence)requestParameter.getRbelPath())) {
            if (candidateMessages.size() > 1) {
                String warnMsg = requestParameter.isFilterPreviousRequest() ? "last" : "first";
                log.warn("Found more then one candidate message. Returning " + warnMsg + " message. This may not be deterministic!");
                this.printAllPathsOfMessages(candidateMessages);
            }
            return Optional.of(requestParameter.isFilterPreviousRequest() ? (RbelElement)candidateMessages.get(candidateMessages.size() - 1) : (RbelElement)candidateMessages.get(0));
        }
        if (requestParameter.isFilterPreviousRequest()) {
            Collections.reverse(candidateMessages);
        }
        for (RbelElement candidateMessage : candidateMessages) {
            List pathExecutionResult = new RbelPathExecutor(candidateMessage, requestParameter.getRbelPath()).execute();
            if (pathExecutionResult.isEmpty()) continue;
            if (StringUtils.isEmpty((CharSequence)requestParameter.getValue())) {
                return Optional.of(candidateMessage);
            }
            String content = pathExecutionResult.stream().map(RbelElement::getRawStringContent).map(String::trim).collect(Collectors.joining());
            try {
                if (content.equals(requestParameter.getValue()) || content.matches(requestParameter.getValue()) || Pattern.compile(requestParameter.getValue(), 32).matcher(content).matches()) {
                    return Optional.of(candidateMessage);
                }
                log.info("Found rbel node but \n'" + StringUtils.abbreviate((String)content, (int)300) + "' didnt match\n'" + StringUtils.abbreviate((String)requestParameter.getValue(), (int)300) + "'");
            }
            catch (Exception ex) {
                log.error("Failure while trying to apply regular expression '" + requestParameter.getValue() + "'!", (Throwable)ex);
            }
        }
        return Optional.empty();
    }

    public boolean doesPathOfMessageMatch(RbelElement req, String path) {
        try {
            boolean match;
            URI uri = new URI(req.getFacet(RbelHttpRequestFacet.class).map(RbelHttpRequestFacet::getPath).map(RbelElement::getRawStringContent).orElse(""));
            boolean bl = match = uri.getPath().equals(path) || uri.getPath().matches(path);
            if (!match && emptyPath.contains(path) && emptyPath.contains(uri.getPath())) {
                match = true;
            }
            return match;
        }
        catch (URISyntaxException e) {
            return false;
        }
        catch (PatternSyntaxException rte) {
            log.error("Error while parsing regex!", (Throwable)rte);
            return false;
        }
    }

    public boolean doesHostMatch(RbelElement req, String hostFilter) {
        try {
            String host = ((RbelHttpHeaderFacet)((RbelHttpMessageFacet)req.getFacetOrFail(RbelHttpMessageFacet.class)).getHeader().getFacetOrFail(RbelHttpHeaderFacet.class)).get((Object)"Host").getRawStringContent();
            return host.equals(hostFilter) || host.matches(hostFilter);
        }
        catch (RuntimeException rte) {
            log.error("Probable error while parsing regex!", (Throwable)rte);
            return false;
        }
    }

    public boolean doesMethodMatch(RbelElement req, String method) {
        try {
            String reqMethod = ((RbelHttpRequestFacet)req.getFacetOrFail(RbelHttpRequestFacet.class)).getMethod().getRawStringContent().toUpperCase();
            return method.equals(reqMethod) || method.matches(reqMethod);
        }
        catch (RuntimeException rte) {
            log.error("Probable error while parsing regex!", (Throwable)rte);
            return false;
        }
    }

    private void printAllPathsOfMessages(List<RbelElement> msgs) {
        log.info("Found the following {} messages:\n{} ", (Object)msgs.size(), (Object)msgs.stream().map(msg -> msg.getFacet(RbelHttpRequestFacet.class)).filter(Optional::isPresent).map(Optional::get).map(req -> "=>\t" + req.getPathAsString() + " : " + req.getChildElements()).collect(Collectors.joining("\n")));
    }

    public void compareXMLStructure(String test, String oracle, List<Function<DiffBuilder, DiffBuilder>> diffOptions) {
        ArrayList diffs = new ArrayList();
        Source srcTest = Input.from((Object)test).build();
        Source srcOracle = Input.from((Object)oracle).build();
        DiffBuilder db = DiffBuilder.compare((Object)srcOracle).withTest((Object)srcTest);
        for (Function<DiffBuilder, DiffBuilder> src : diffOptions) {
            db = src.apply(db);
        }
        db = db.checkForSimilar();
        db.withDifferenceEvaluator((comparison, outcome) -> {
            if (outcome != ComparisonResult.EQUAL && (comparison.getType() == ComparisonType.NAMESPACE_URI || comparison.getType() == ComparisonType.NAMESPACE_PREFIX)) {
                return ComparisonResult.SIMILAR;
            }
            return outcome;
        });
        Diff diff = db.build();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)diff.hasDifferences()).withFailMessage("XML tree mismatch!\n" + diff, new Object[0])).isFalse();
    }

    public void compareXMLStructure(String test, String oracle) {
        this.compareXMLStructure(test, oracle, Collections.emptyList());
    }

    public void compareXMLStructure(String test, String oracle, String diffOptionCSV) {
        ArrayList<Function<DiffBuilder, DiffBuilder>> diffOptions = new ArrayList<Function<DiffBuilder, DiffBuilder>>();
        Arrays.stream(diffOptionCSV.split(",")).map(String::trim).forEach(srcClassId -> {
            Assertions.assertThat(diffOptionMap).containsKey(srcClassId);
            diffOptions.add(diffOptionMap.get(srcClassId));
        });
        this.compareXMLStructure(test, oracle, diffOptions);
    }

    public RbelElement findElementInCurrentResponse(String rbelPath) {
        try {
            List elems = this.currentResponse.findRbelPathMembers(rbelPath);
            ((ListAssert)Assertions.assertThat((List)elems).withFailMessage("No node matching path '" + rbelPath + "'!", new Object[0])).isNotEmpty();
            ((ListAssert)Assertions.assertThat((List)elems).withFailMessage("Expected exactly one match fpr path '" + rbelPath + "'!", new Object[0])).hasSize(1);
            return (RbelElement)elems.get(0);
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Unable to find element in last response for rbel path '" + rbelPath + "'"));
        }
    }

    public List<RbelElement> findElementsInCurrentResponse(String rbelPath) {
        try {
            List elems = this.currentResponse.findRbelPathMembers(rbelPath);
            Assertions.assertThat((List)elems).isNotEmpty();
            return elems;
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Unable to find element in last response for rbel path '" + rbelPath + "'"));
        }
    }

    @Generated
    public RbelElement getCurrentRequest() {
        return this.currentRequest;
    }

    @Generated
    public RbelElement getCurrentResponse() {
        return this.currentResponse;
    }

    static {
        diffOptionMap.put("nocomment", DiffBuilder::ignoreComments);
        diffOptionMap.put("txtignoreempty", DiffBuilder::ignoreElementContentWhitespace);
        diffOptionMap.put("txttrim", DiffBuilder::ignoreWhitespace);
        diffOptionMap.put("txtnormalize", DiffBuilder::normalizeWhitespace);
        emptyPath = ImmutableList.of((Object)"", (Object)"/");
    }

    public class JexlToolbox {
        public String currentResponseAsString(String rbelPath) {
            return RbelMessageValidator.this.findElementInCurrentResponse(rbelPath).getRawStringContent();
        }

        public String currentResponseAsString() {
            return RbelMessageValidator.this.currentResponse.getRawStringContent();
        }

        public RbelElement currentResponse(String rbelPath) {
            return RbelMessageValidator.this.findElementInCurrentResponse(rbelPath);
        }

        public RbelElement lastResponse() {
            return RbelMessageValidator.this.currentResponse;
        }
    }
}

