/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.parser;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import de.gematik.test.tiger.lib.parser.ITestParser;
import de.gematik.test.tiger.lib.parser.TestParserException;
import de.gematik.test.tiger.lib.parser.model.Testcase;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaTestParser
implements ITestParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JavaTestParser.class);
    private final Map<String, List<Testcase>> parsedTestcasesPerAfo = new HashMap<String, List<Testcase>>();
    private final Map<String, Testcase> parsedTestcases = new HashMap<String, Testcase>();
    private final Map<String, Testcase> unreferencedTestcases = new HashMap<String, Testcase>();

    @Override
    public void parseDirectory(File rootDir) {
        if (rootDir == null) {
            log.warn("Invalid test source NULL root dir");
        } else {
            File[] files = rootDir.listFiles();
            if (files == null) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Invalid test source root dir %s", rootDir.getAbsolutePath()));
                }
            } else {
                Arrays.asList(files).forEach(f -> {
                    if (f.isDirectory()) {
                        this.parseDirectory((File)f);
                    } else if (f.getName().endsWith(".java")) {
                        this.inspectFile((File)f);
                    }
                });
            }
        }
    }

    private void inspectFile(File f) {
        try (FileInputStream in = new FileInputStream(f);){
            CompilationUnit cu = StaticJavaParser.parse((InputStream)in);
            new MethodVisitor(this).visit(cu, null);
        }
        catch (IOException ioex) {
            throw new TestParserException("Unable to parse " + f.getAbsolutePath(), ioex);
        }
    }

    @Override
    public Map<String, Testcase> getTestcasesWithoutAfo() {
        return this.unreferencedTestcases;
    }

    @Override
    @Generated
    public Map<String, List<Testcase>> getParsedTestcasesPerAfo() {
        return this.parsedTestcasesPerAfo;
    }

    @Override
    @Generated
    public Map<String, Testcase> getParsedTestcases() {
        return this.parsedTestcases;
    }

    @Generated
    public Map<String, Testcase> getUnreferencedTestcases() {
        return this.unreferencedTestcases;
    }

    private static class MethodVisitor
    extends VoidVisitorAdapter<Object> {
        private final JavaTestParser parser;

        MethodVisitor(JavaTestParser parser) {
            this.parser = parser;
        }

        private static String getFullyQualifiedName(ClassOrInterfaceDeclaration testClass) {
            return testClass.getParentNode().flatMap(MethodVisitor::getClass).map(parentClass -> MethodVisitor.getFullyQualifiedName(parentClass) + "." + testClass.getNameAsString()).orElseGet(() -> MethodVisitor.getCompilationUnit((Node)testClass).flatMap(CompilationUnit::getPackageDeclaration).map(NodeWithName::getNameAsString).map(packageName -> packageName + "." + testClass.getNameAsString()).orElse(testClass.getNameAsString()));
        }

        private static Optional<ClassOrInterfaceDeclaration> getClass(Node method) {
            Node clazz = method;
            while (!(clazz instanceof ClassOrInterfaceDeclaration)) {
                Optional cpn = clazz.getParentNode();
                if (cpn.isPresent()) {
                    clazz = (Node)cpn.get();
                    continue;
                }
                return Optional.empty();
            }
            return Optional.of((ClassOrInterfaceDeclaration)clazz);
        }

        private static Optional<CompilationUnit> getCompilationUnit(Node clazz) {
            Node pkgs = clazz;
            while (!(pkgs instanceof CompilationUnit)) {
                Optional pn = pkgs.getParentNode();
                if (pn.isPresent()) {
                    pkgs = (Node)pn.get();
                    continue;
                }
                return Optional.empty();
            }
            return Optional.of((CompilationUnit)pkgs);
        }

        public void visit(MethodDeclaration n, Object args) {
            this.visitMethodAndAddAfoToTestcaseListIfPresent(n);
        }

        private void visitMethodAndAddAfoToTestcaseListIfPresent(MethodDeclaration n) {
            String methodname = n.getNameAsString();
            boolean test = n.getAnnotations().stream().filter(ano -> "Test".equals(ano.getNameAsString())).map(ano -> true).findAny().orElse(false);
            if (test) {
                String clazzname = MethodVisitor.getFullyQualifiedName((ClassOrInterfaceDeclaration)n.getParentNode().orElseThrow(() -> new TestParserException(String.format("Internal Error. Test Method has no parent node. Method name is %s!", methodname))));
                Testcase tc = new Testcase();
                tc.setClazz(clazzname);
                tc.setMethod(methodname);
                this.parser.parsedTestcases.putIfAbsent(tc.getClazz() + ":" + tc.getMethod(), tc);
                AtomicReference<Boolean> ref = new AtomicReference<Boolean>(false);
                n.getAnnotations().stream().filter(afo -> "Afo".equals(afo.getNameAsString())).forEach(afo -> {
                    ref.set(true);
                    this.addTestCaseToAfo(tc, (AnnotationExpr)afo);
                });
                if (!ref.get().booleanValue()) {
                    this.parser.unreferencedTestcases.putIfAbsent(tc.getClazz() + ":" + tc.getMethod(), tc);
                }
            }
        }

        private void addTestCaseToAfo(Testcase tc, AnnotationExpr afo) {
            if (!(afo instanceof SingleMemberAnnotationExpr)) {
                throw new TestParserException("Unsupported Afo Annotation detected in " + tc.getClazz() + ":" + tc.getMethod() + "!");
            }
            String id = ((SingleMemberAnnotationExpr)afo).getMemberValue().asStringLiteralExpr().asString();
            this.parser.parsedTestcasesPerAfo.computeIfAbsent(id, k -> new ArrayList());
            this.parser.parsedTestcasesPerAfo.get(id).add(tc);
        }
    }
}

