/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.parser;

import de.gematik.test.tiger.lib.parser.FeatureParser;
import de.gematik.test.tiger.lib.parser.ITestParser;
import de.gematik.test.tiger.lib.parser.model.Testcase;
import de.gematik.test.tiger.lib.parser.model.gherkin.Feature;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberTestParser
implements ITestParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CucumberTestParser.class);
    private static final String AFO_TOKEN = "@Afo";
    private final Map<String, List<Testcase>> parsedTestcasesPerAfo = new HashMap<String, List<Testcase>>();
    private final Map<String, Testcase> parsedTestcases = new HashMap<String, Testcase>();
    private final Map<String, Testcase> unreferencedTestcases = new HashMap<String, Testcase>();

    @Override
    public void parseDirectory(File rootDir) {
        if (rootDir == null) {
            log.warn("Invalid test source NULL root dir");
        } else {
            File[] files = rootDir.listFiles();
            if (files == null) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Invalid test source root dir %s", rootDir.getAbsolutePath()));
                }
            } else {
                Arrays.stream(files).filter(f -> f.isFile() && f.getName().endsWith(".feature")).forEach(this::inspectFile);
                Arrays.stream(files).filter(File::isDirectory).forEach(this::parseDirectory);
            }
        }
    }

    private void inspectFile(File f) {
        Feature feature = new FeatureParser().parseFeatureFile(f);
        feature.getScenarios().forEach(ch -> {
            Testcase tc = new Testcase();
            tc.setFeatureName(feature.getName());
            tc.setScenarioName(ch.getName());
            tc.setClazz(this.convertToId(feature.getName()));
            tc.setMethod(this.convertToId(ch.getName()));
            tc.setPath(feature.getFileName());
            this.parsedTestcases.putIfAbsent(tc.getClazz() + ":" + tc.getMethod(), tc);
            AtomicReference<Boolean> ref = new AtomicReference<Boolean>(false);
            ch.getTags().stream().filter(tag -> tag.getName().equals(AFO_TOKEN)).forEach(afotag -> {
                String afoid = afotag.getParameter();
                this.parsedTestcasesPerAfo.computeIfAbsent(afoid, k -> new ArrayList());
                this.parsedTestcasesPerAfo.get(afoid).add(tc);
                ref.set(true);
            });
            if (!ref.get().booleanValue()) {
                this.unreferencedTestcases.putIfAbsent(tc.getClazz() + ":" + tc.getMethod(), tc);
            }
        });
        log.info("      Found " + feature.getScenarios().size() + " scenarios in " + f.getAbsolutePath());
    }

    private String convertToId(String name) {
        String chars = " ;,.+*~\\/!$()[]{}";
        for (int i = 0; i < " ;,.+*~\\/!$()[]{}".length(); ++i) {
            name = name.replace(" ;,.+*~\\/!$()[]{}".charAt(i), '-');
        }
        return name.toLowerCase();
    }

    @Override
    public Map<String, Testcase> getTestcasesWithoutAfo() {
        return this.unreferencedTestcases;
    }

    @Override
    @Generated
    public Map<String, List<Testcase>> getParsedTestcasesPerAfo() {
        return this.parsedTestcasesPerAfo;
    }

    @Override
    @Generated
    public Map<String, Testcase> getParsedTestcases() {
        return this.parsedTestcases;
    }

    @Generated
    public Map<String, Testcase> getUnreferencedTestcases() {
        return this.unreferencedTestcases;
    }
}

