/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.rbel;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.test.tiger.LocalProxyRbelMessageListener;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.lib.rbel.RbelMessageValidator;
import de.gematik.test.tiger.lib.rbel.RequestParameter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.xmlunit.XMLUnitException;

public class RbelMessageValidatorTest {
    @Test
    public void testPathEqualsWithRelativePath_OK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath("/foo/bar?sch=mar"), "/foo/bar")).isTrue();
    }

    @Test
    public void testPathEqualsWithUrl_OK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath("http://bl.ub/foo/bar?sch=mar"), "/foo/bar")).isTrue();
    }

    @Test
    public void testPathMatchingWithUrlLeading_OK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath("http://bl.ub/foo/bar?sch=mar"), "\\/.*\\/bar")).isTrue();
    }

    @Test
    public void testPathMatchingWithUrlTrailing_OK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath("http://bl.ub/foo/bar?sch=mar"), "\\/foo\\/.*")).isTrue();
    }

    @Test
    public void testPathMatchingWithUrlInMid_OK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath("http://bl.ub/foo/bar/test?sch=mar"), "\\/foo\\/.*/test")).isTrue();
    }

    @Test
    public void testPathMatchingWithNotMatchRegex_NOK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath("http://bl.ub/foo/bar/test?sch=mar"), "/foo/.*/[test]")).isFalse();
    }

    @Test
    public void testPathMatchingWithInvalidRegex_NOK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath("http://bl.ub/foo/bar/test?sch=mar"), "[")).isFalse();
    }

    @Test
    public void testInvalidPathMatching_NOK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath("file$:."), "/foo/.*")).isFalse();
    }

    private RbelElement buildRequestWithPath(String path) {
        RbelElement rbelElement = new RbelElement(null, null);
        rbelElement.addFacet((RbelFacet)RbelHttpRequestFacet.builder().path(new RbelElement(path.getBytes(), null)).build());
        return rbelElement;
    }

    @Test
    public void testHostMatching_OK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesHostMatch(this.buildRequestFromCurlFile("getRequestLocalhost.curl"), "localhost:8080")).isTrue();
    }

    @Test
    public void testHostMatchingRegex_OK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesHostMatch(this.buildRequestFromCurlFile("getRequestLocalhost.curl"), "local.*:8080")).isTrue();
    }

    @Test
    public void testHostMatchingRegexNotMatching_OK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesHostMatch(this.buildRequestFromCurlFile("getRequestLocalhost.curl"), "eitzen.*")).isFalse();
    }

    @Test
    public void testHostMatchingInvalidRegex_NOK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesHostMatch(this.buildRequestFromCurlFile("getRequestLocalhost.curl"), "[")).isFalse();
    }

    @Test
    public void testMethodMatching_OK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesMethodMatch(this.buildRequestFromCurlFile("getRequestLocalhost.curl"), "GET")).isTrue();
    }

    @Test
    public void testMethodMatchingNotMatching_OK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesMethodMatch(this.buildRequestFromCurlFile("getRequestLocalhost.curl"), "POST")).isFalse();
    }

    private RbelElement buildRequestFromCurlFile(String curlFileName) {
        String curlMessage = this.readCurlFromFileWithCorrectedLineBreaks(curlFileName, StandardCharsets.UTF_8);
        return RbelLogger.build().getRbelConverter().convertElement(curlMessage, null);
    }

    private RbelElement buildResponseFromCurlFile(String curlFileName, RbelElement request) {
        String curlMessage = this.readCurlFromFileWithCorrectedLineBreaks(curlFileName, StandardCharsets.UTF_8);
        RbelElement message = RbelLogger.build().getRbelConverter().convertElement(curlMessage, null);
        message.addOrReplaceFacet((RbelFacet)((RbelHttpResponseFacet)message.getFacet(RbelHttpResponseFacet.class).get()).toBuilder().request(request).build());
        return message;
    }

    private String readCurlFromFileWithCorrectedLineBreaks(String fileName, Charset charset) {
        try {
            return FileUtils.readFileToString((File)new File("src/test/resources/testdata/sampleCurlMessages/" + fileName), (Charset)charset).replaceAll("(?<!\\r)\\n", "\r\n");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to read curl file", ioe);
        }
    }

    @Test
    public void testSourceTestInvalid_NOK() {
        Assertions.assertThatThrownBy(() -> new RbelMessageValidator().compareXMLStructure("<root><header></header><body><!-- test comment-- --></body>", "<root><header></header><body></body></root>")).isInstanceOf(XMLUnitException.class);
    }

    @Test
    public void testSourceOracleInvalid_NOK() {
        Assertions.assertThatThrownBy(() -> new RbelMessageValidator().compareXMLStructure("<root><header></header><body><!-- test comment --></body></root>", "<root><header></header><body></body>")).isInstanceOf(XMLUnitException.class);
    }

    @Test
    public void testSourceNoComment_OK() {
        new RbelMessageValidator().compareXMLStructure("<root><header></header><body><!-- test comment --></body></root>", "<root><header></header><body></body></root>", "nocomment");
    }

    @Test
    public void testSourceNoCommetTxtTrim_OK() {
        new RbelMessageValidator().compareXMLStructure("<root><header></header><body>test     <!-- test comment --></body></root>", "<root><header></header><body>test</body></root>", "nocomment,txttrim");
    }

    @Test
    public void testSourceNoCommetTxtTrim2_OK() {
        new RbelMessageValidator().compareXMLStructure("<root><header></header><body>    test     <!-- test comment --></body></root>", "<root><header></header><body>test</body></root>", "nocomment,txttrim");
    }

    @Test
    public void testSourceNoCommetTxtTrim3_OK() {
        new RbelMessageValidator().compareXMLStructure("<root><header></header><body>    test xxx    <!-- test comment --></body></root>", "<root><header></header><body>test xxx</body></root>", "nocomment,txttrim");
    }

    @Test
    public void testSourceNoCommetTxtTrim4_OK() {
        Assertions.assertThatThrownBy(() -> new RbelMessageValidator().compareXMLStructure("<root><header></header><body>    test   xxx    <!-- test comment --></body></root>", "<root><header></header><body>test xxx</body></root>", "nocomment,txttrim")).isInstanceOf(AssertionError.class);
    }

    @Test
    public void testSourceNoCommetTxtNormalize_OK() {
        new RbelMessageValidator().compareXMLStructure("<root><header></header><body>  test    xxxx   </body>  <!-- test comment --></root>", "<root><header></header><body>test xxxx </body></root>", "nocomment,txtnormalize");
    }

    @Test
    public void testSourceAttrOrder_OK() {
        new RbelMessageValidator().compareXMLStructure("<root><header></header><body attr1='1'   attr2='2'></body></root>", "<root><header></header><body attr2='2' attr1='1'></body></root>");
    }

    @ParameterizedTest
    @CsvSource(value={"http://server, ''", "http://server/, /", "http://server, /", "http://server/, ''"})
    public void testEmptyPathMatching(String url, String path) {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath(url), path)).isTrue();
    }

    @ParameterizedTest
    @CsvSource(value={"http://server/blu/, /", "http://server/, /bla", "http://server/bla, ''"})
    public void testPathOfMessageMatch_NOK(String url, String path) {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath(url), path)).isFalse();
    }

    @Test
    public void testFilterRequests_OK() {
        this.addSomeMessagesToTigerTestHooks();
        RbelMessageValidator validator = new RbelMessageValidator();
        validator.filterRequestsAndStoreInContext(RequestParameter.builder().path(".*").build());
        RbelElement request = validator.currentRequest;
        org.junit.jupiter.api.Assertions.assertTrue((boolean)validator.doesHostMatch(request, "localhost:8080"));
    }

    @Test
    public void testFilterRequestsWrongPath_OK() {
        this.addSomeMessagesToTigerTestHooks();
        RbelMessageValidator validator = new RbelMessageValidator();
        Assertions.assertThatThrownBy(() -> validator.filterRequestsAndStoreInContext(RequestParameter.builder().path("/NOWAY.*").build())).isInstanceOf(AssertionError.class);
    }

    @Test
    public void testFilterRequestsNextRequest_OK() {
        this.addSomeMessagesToTigerTestHooks();
        RbelMessageValidator validator = new RbelMessageValidator();
        validator.filterRequestsAndStoreInContext(RequestParameter.builder().path(".*").build());
        validator.filterRequestsAndStoreInContext(RequestParameter.builder().path(".*").startFromLastRequest(true).build());
        RbelElement request = validator.currentRequest;
        org.junit.jupiter.api.Assertions.assertTrue((boolean)validator.doesHostMatch(request, "eitzen.at:80"));
    }

    @Test
    public void testFilterRequestsRbelPath_OK() {
        this.addSomeMessagesToTigerTestHooks();
        RbelMessageValidator validator = new RbelMessageValidator();
        validator.filterRequestsAndStoreInContext(RequestParameter.builder().path(".*").rbelPath("$.header.User-Agent").value("mypersonalagent").build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)validator.doesHostMatch(validator.currentRequest, "eitzen.at:80"));
    }

    @Test
    public void testFilterRequestsRbelPathNotMatching_OK() {
        this.addSomeMessagesToTigerTestHooks();
        RbelMessageValidator validator = new RbelMessageValidator();
        Assertions.assertThatThrownBy(() -> validator.filterRequestsAndStoreInContext(RequestParameter.builder().path(".*").rbelPath("$.header.User-Agent").value("mypersonalagentXXXX").build())).isInstanceOf(AssertionError.class);
    }

    @Test
    public void testFilterRequestsRbelPathRegex_OK() {
        this.addSomeMessagesToTigerTestHooks();
        RbelMessageValidator validator = new RbelMessageValidator();
        validator.filterRequestsAndStoreInContext(RequestParameter.builder().path(".*").rbelPath("$.header.User-Agent").value("mypersonal.*").build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)validator.doesHostMatch(validator.currentRequest, "eitzen.at:80"));
    }

    @Test
    public void testFilterRequestsAttachResponseCorrectly_OK() {
        this.addSomeMessagesToTigerTestHooks();
        RbelMessageValidator validator = new RbelMessageValidator();
        validator.filterRequestsAndStoreInContext(RequestParameter.builder().path(".*").rbelPath("$.header.User-Agent").value("mypersonal.*").build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)validator.doesHostMatch(validator.currentRequest, "eitzen.at:80"));
        Assertions.assertThat((String)((RbelHttpResponseFacet)validator.currentResponse.getFacet(RbelHttpResponseFacet.class).get()).getResponseCode().getRawStringContent()).isEqualTo("500");
    }

    private void addSomeMessagesToTigerTestHooks() {
        TigerGlobalConfiguration.putValue((String)"tiger.rbel.request.timeout", (int)1);
        LocalProxyRbelMessageListener.getValidatableRbelMessages().clear();
        RbelElement request = this.buildRequestFromCurlFile("getRequestLocalhost.curl");
        LocalProxyRbelMessageListener.getValidatableRbelMessages().add(request);
        LocalProxyRbelMessageListener.getValidatableRbelMessages().add(this.buildResponseFromCurlFile("htmlMessage.curl", request));
        request = this.buildRequestFromCurlFile("getRequestEitzenAt.curl");
        LocalProxyRbelMessageListener.getValidatableRbelMessages().add(request);
        LocalProxyRbelMessageListener.getValidatableRbelMessages().add(this.buildResponseFromCurlFile("htmlMessageEitzenAt.curl", request));
    }
}

