/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue;

import de.gematik.test.tiger.common.banner.Banner;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.lib.TigerDirector;
import io.cucumber.java.de.Dann;
import io.cucumber.java.de.Gegebensei;
import io.cucumber.java.de.Wenn;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerGlue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerGlue.class);

    @Wenn(value="TGR setze globale Variable {string} auf {string} setzen")
    @When(value="TGR set global variable {string} to {string}")
    public void ctxtISetGlobalVariableTo(String key, String value) {
        TigerGlobalConfiguration.putValue((String)TigerGlobalConfiguration.resolvePlaceholders((String)key), (String)TigerGlobalConfiguration.resolvePlaceholders((String)value));
    }

    @Wenn(value="TGR setze lokale Variable {string} auf {string} setzen")
    @When(value="TGR set local variable {string} to {string}")
    public void ctxtISetLocalVariableTo(String key, String value) {
        TigerGlobalConfiguration.putValue((String)TigerGlobalConfiguration.resolvePlaceholders((String)key), (String)TigerGlobalConfiguration.resolvePlaceholders((String)value), (SourceType)SourceType.THREAD_CONTEXT);
    }

    @Dann(value="TGR pr\u00fcfe Variable {string} stimmt \u00fcberein mit {string}")
    @Then(value="TGR assert variable {string} matches {string}")
    public void ctxtAssertVariableMatches(String key, String regex) {
        String resolvedKey = TigerGlobalConfiguration.resolvePlaceholders((String)key);
        Optional optionalValue = TigerGlobalConfiguration.readStringOptional((String)resolvedKey);
        ((OptionalAssert)Assertions.assertThat((Optional)optionalValue).withFailMessage("Wanted to assert value of key {} (resolved to {}) but couldn't find it!", new Object[]{key, resolvedKey})).isPresent();
        if (!Objects.equals(optionalValue.get(), regex)) {
            Assertions.assertThat((String)((String)optionalValue.get())).matches((CharSequence)regex);
        }
    }

    @Dann(value="TGR pr\u00fcfe Variable {string} ist unbekannt")
    @Then(value="TGR assert variable {string} is unknown")
    public void ctxtAssertVariableUnknown(String key) {
        String resolvedKey = TigerGlobalConfiguration.resolvePlaceholders((String)key);
        Optional optionalValue = TigerGlobalConfiguration.readStringOptional((String)resolvedKey);
        ((OptionalAssert)Assertions.assertThat((Optional)optionalValue).withFailMessage("Wanted to assert value of key {} (resolved to {}) was unset but found value {}!", new Object[]{key, resolvedKey, optionalValue})).isEmpty();
    }

    @Gegebensei(value="TGR zeige {word} Banner {string}")
    @Given(value="TGR show {word} banner {string}")
    public void tgrShowColoredBanner(String color, String text) {
        log.info("\n" + Banner.toBannerStrWithCOLOR((String)text, (String)color.toUpperCase()));
    }

    @Gegebensei(value="TGR zeige {word} Text {string}")
    @Given(value="TGR show {word} text {string}")
    public void tgrShowColoredText(String color, String text) {
        log.info("\n" + Banner.toTextStr((String)text, (String)color.toUpperCase()));
    }

    @Gegebensei(value="TGR zeige Banner {string}")
    @Given(value="TGR show banner {string}")
    public void tgrIWantToShowBanner(String text) {
        log.info("\n" + Banner.toBannerStrWithCOLOR((String)text, (String)"WHITE"));
    }

    @When(value="TGR wait for user abort")
    @Wenn(value="TGR warte auf Abbruch")
    public void tgrWaitForUserAbort() {
        TigerDirector.waitForQuit();
    }
}

