/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger;

import de.gematik.test.tiger.TigerCucumberListener;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.testenvmgr.controller.EnvStatusController;
import de.gematik.test.tiger.testenvmgr.data.TigerEnvStatusDto;
import de.gematik.test.tiger.testenvmgr.env.FeatureUpdate;
import de.gematik.test.tiger.testenvmgr.env.ScenarioUpdate;
import de.gematik.test.tiger.testenvmgr.env.StepUpdate;
import de.gematik.test.tiger.testenvmgr.env.TestResult;
import io.cucumber.plugin.event.Argument;
import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.Step;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestTigerCucumberListener {
    private TigerCucumberListener listener;
    private static EnvStatusController envStatusController;
    private final String featureName = "Authentifiziere Anwendung am IDP Server";
    private final UUID scenarioId = UUID.randomUUID();
    private final String scenarioName = "Auth - Gutfall - Validiere Claims";
    private final UUID scenarioOutlineId = UUID.randomUUID();
    private final String scenarioOutlineName = "Auth - Fehlende Parameter alle anderen";
    private final String featureFilePath = "src/test/resources/testdata/parser/bdd/authentication.feature";
    private final URI featureUri = new File("src/test/resources/testdata/parser/bdd/authentication.feature").toURI();

    @BeforeAll
    public static void startTiger() {
        TigerDirector.start();
        envStatusController = new EnvStatusController(TigerDirector.getTigerTestEnvMgr());
    }

    @BeforeEach
    public void initListener() {
        this.listener = new TigerCucumberListener();
        envStatusController.getStatus().getFeatureMap().clear();
    }

    @Test
    public void testCaseStartedSimpleScenario() throws IOException {
        TestSourceRead event = new TestSourceRead(Instant.now(), this.featureUri, IOUtils.toString((URI)this.featureUri, (Charset)StandardCharsets.UTF_8));
        this.listener.getSourceRead().receive((Object)event);
        Assertions.assertThat((Map)this.listener.getIdFeatureMap()).hasSize(0);
        Assertions.assertThat((List)this.listener.getCurrentFeature().getScenarios()).hasSize(7);
        TestCaseStarted startedEvent = new TestCaseStarted(Instant.now(), (TestCase)new TestcaseAdapter());
        this.listener.getCaseStarted().receive((Object)startedEvent);
        Assertions.assertThat((Map)this.listener.getIdFeatureMap()).containsKey((Object)this.scenarioId.toString());
        Assertions.assertThat((Map)this.listener.getScenarioStepsMap()).containsKey((Object)this.scenarioId.toString());
        Assertions.assertThat((String)this.listener.getCurrentScenarioId()).isEqualTo(this.scenarioId.toString());
        Assertions.assertThat((int)this.listener.getCurrentScenarioDataVariantIndex()).isEqualTo(-1);
        TigerEnvStatusDto status = envStatusController.getStatus();
        Assertions.assertThat((Map)status.getFeatureMap()).containsOnlyKeys((Object[])new String[]{"Authentifiziere Anwendung am IDP Server"});
        LinkedHashMap scenarios = ((FeatureUpdate)status.getFeatureMap().get("Authentifiziere Anwendung am IDP Server")).getScenarios();
        Assertions.assertThat((Map)scenarios).hasSize(1);
        Assertions.assertThat((String)((ScenarioUpdate)scenarios.get(this.scenarioId.toString())).getDescription()).isEqualTo("Auth - Gutfall - Validiere Claims");
    }

    @Test
    public void testCaseStartedScenarioOutline() throws IOException {
        TestSourceRead event = new TestSourceRead(Instant.now(), this.featureUri, IOUtils.toString((URI)this.featureUri, (Charset)StandardCharsets.UTF_8));
        this.listener.getSourceRead().receive((Object)event);
        Assertions.assertThat((Map)this.listener.getIdFeatureMap()).hasSize(0);
        Assertions.assertThat((List)this.listener.getCurrentFeature().getScenarios()).hasSize(7);
        TestCaseStarted startedEvent = new TestCaseStarted(Instant.now(), (TestCase)new ScenarioOutlineTestCaseAdapter());
        this.listener.getCaseStarted().receive((Object)startedEvent);
        Assertions.assertThat((Map)this.listener.getIdFeatureMap()).containsKey((Object)this.scenarioOutlineId.toString());
        Assertions.assertThat((Map)this.listener.getScenarioStepsMap()).containsKey((Object)this.scenarioOutlineId.toString());
        Assertions.assertThat((String)this.listener.getCurrentScenarioId()).isEqualTo(this.scenarioOutlineId.toString());
        Assertions.assertThat((int)this.listener.getCurrentScenarioDataVariantIndex()).isEqualTo(0);
        Assertions.assertThat((List)this.listener.getCurrentScenarioDataVariant()).hasSize(7);
        Assertions.assertThat((List)this.listener.getCurrentScenarioDataVariantKeys()).contains((Object[])new String[]{"http_code", "err_id", "err", "client_id", "scope", "code_challenge", "code_challenge_method", "redirect_uri", "state", "nonce", "response_type"});
        TigerEnvStatusDto status = envStatusController.getStatus();
        Assertions.assertThat((Map)status.getFeatureMap()).containsOnlyKeys((Object[])new String[]{"Authentifiziere Anwendung am IDP Server"});
        LinkedHashMap scenarios = ((FeatureUpdate)status.getFeatureMap().get("Authentifiziere Anwendung am IDP Server")).getScenarios();
        Assertions.assertThat((Map)scenarios).hasSize(1);
        Assertions.assertThat((String)((ScenarioUpdate)scenarios.get("0-" + this.scenarioOutlineId)).getDescription()).isEqualTo("Auth - Fehlende Parameter alle anderen");
        Assertions.assertThat((int)((ScenarioUpdate)scenarios.get("0-" + this.scenarioOutlineId)).getVariantIndex()).isEqualTo(0);
        this.listener.getCaseStarted().receive((Object)startedEvent);
        Assertions.assertThat((Map)this.listener.getIdFeatureMap()).containsKey((Object)this.scenarioOutlineId.toString());
        Assertions.assertThat((Map)this.listener.getScenarioStepsMap()).containsKey((Object)this.scenarioOutlineId.toString());
        Assertions.assertThat((String)this.listener.getCurrentScenarioId()).isEqualTo(this.scenarioOutlineId.toString());
        Assertions.assertThat((int)this.listener.getCurrentScenarioDataVariantIndex()).isEqualTo(1);
        status = envStatusController.getStatus();
        scenarios = ((FeatureUpdate)status.getFeatureMap().get("Authentifiziere Anwendung am IDP Server")).getScenarios();
        Assertions.assertThat((Map)scenarios).hasSize(2);
        Assertions.assertThat((String)((ScenarioUpdate)scenarios.get("0-" + this.scenarioOutlineId)).getDescription()).isEqualTo("Auth - Fehlende Parameter alle anderen");
        Assertions.assertThat((int)((ScenarioUpdate)scenarios.get("0-" + this.scenarioOutlineId)).getVariantIndex()).isEqualTo(0);
        Assertions.assertThat((String)((ScenarioUpdate)scenarios.get("1-" + this.scenarioOutlineId)).getDescription()).isEqualTo("Auth - Fehlende Parameter alle anderen");
        Assertions.assertThat((int)((ScenarioUpdate)scenarios.get("1-" + this.scenarioOutlineId)).getVariantIndex()).isEqualTo(1);
    }

    @Test
    public void testStepsHandling() throws IOException {
        TestSourceRead event = new TestSourceRead(Instant.now(), this.featureUri, IOUtils.toString((URI)this.featureUri, (Charset)StandardCharsets.UTF_8));
        this.listener.getSourceRead().receive((Object)event);
        TestcaseAdapter testCase = new TestcaseAdapter();
        TestCaseStarted startedEvent = new TestCaseStarted(Instant.now(), (TestCase)testCase);
        this.listener.getCaseStarted().receive((Object)startedEvent);
        TestStepStarted stepStartedEvent = new TestStepStarted(Instant.now(), (TestCase)testCase, (TestStep)new TestStepAdapter());
        this.listener.getStepStarted().receive((Object)stepStartedEvent);
        this.listener.getStepFinsihed().receive((Object)new TestStepFinished(Instant.now(), (TestCase)testCase, (TestStep)new TestStepAdapter(), new Result(Status.PASSED, Duration.ofMillis(500L), null)));
        Assertions.assertThat((int)this.listener.getCurrentStepIndex()).isEqualTo(1);
        this.listener.getStepStarted().receive((Object)stepStartedEvent);
        this.listener.getStepFinsihed().receive((Object)new TestStepFinished(Instant.now(), (TestCase)testCase, (TestStep)new TestStepAdapter(), new Result(Status.FAILED, Duration.ofMillis(500L), null)));
        Assertions.assertThat((int)this.listener.getCurrentStepIndex()).isEqualTo(2);
        TigerEnvStatusDto status = envStatusController.getStatus();
        Assertions.assertThat((Map)status.getFeatureMap()).containsOnlyKeys((Object[])new String[]{"Authentifiziere Anwendung am IDP Server"});
        ScenarioUpdate scenario = (ScenarioUpdate)((FeatureUpdate)status.getFeatureMap().get("Authentifiziere Anwendung am IDP Server")).getScenarios().get(this.scenarioId.toString());
        Assertions.assertThat((Comparable)((StepUpdate)scenario.getSteps().get("0")).getStatus()).isEqualTo((Object)TestResult.PASSED);
        Assertions.assertThat((Comparable)((StepUpdate)scenario.getSteps().get("1")).getStatus()).isEqualTo((Object)TestResult.FAILED);
    }

    @Test
    public void testCaseFinished() throws IOException {
        TestSourceRead event = new TestSourceRead(Instant.now(), this.featureUri, IOUtils.toString((URI)this.featureUri, (Charset)StandardCharsets.UTF_8));
        this.listener.getSourceRead().receive((Object)event);
        TestcaseAdapter testCase = new TestcaseAdapter();
        TestCaseStarted startedEvent = new TestCaseStarted(Instant.now(), (TestCase)testCase);
        this.listener.getCaseStarted().receive((Object)startedEvent);
        TestStepStarted stepStartedEvent = new TestStepStarted(Instant.now(), (TestCase)testCase, (TestStep)new TestStepAdapter());
        this.listener.getStepStarted().receive((Object)stepStartedEvent);
        this.listener.getStepFinsihed().receive((Object)new TestStepFinished(Instant.now(), (TestCase)testCase, (TestStep)new TestStepAdapter(), new Result(Status.FAILED, Duration.ofMillis(500L), null)));
        TestCaseFinished finishedEvent = new TestCaseFinished(Instant.now(), (TestCase)testCase, new Result(Status.PASSED, Duration.ofMillis(500L), null));
        this.listener.getCaseFinished().receive((Object)finishedEvent);
        Assertions.assertThat((Map)this.listener.getScenarioStepsMap()).doesNotContainKey((Object)this.scenarioId.toString());
        Assertions.assertThat((int)this.listener.getScFailed()).isEqualTo(0);
        Assertions.assertThat((int)this.listener.getScPassed()).isEqualTo(1);
        File logFile = new File("target/rbellogs/" + this.listener.getFileNameFor("Auth - Gutfall - Validiere Claims", -1));
        Assertions.assertThat((File)logFile).exists();
        ((AbstractStringAssert)Assertions.assertThat((File)logFile).content(StandardCharsets.UTF_8).hasSizeGreaterThan(800)).contains(new CharSequence[]{"Auth - Gutfall - Validiere Claims"});
        TigerEnvStatusDto status = envStatusController.getStatus();
        Assertions.assertThat((Map)status.getFeatureMap()).containsOnlyKeys((Object[])new String[]{"Authentifiziere Anwendung am IDP Server"});
        ScenarioUpdate scenario = (ScenarioUpdate)((FeatureUpdate)status.getFeatureMap().get("Authentifiziere Anwendung am IDP Server")).getScenarios().get(this.scenarioId.toString());
        Assertions.assertThat((Comparable)((StepUpdate)scenario.getSteps().get("0")).getStatus()).isEqualTo((Object)TestResult.FAILED);
        finishedEvent = new TestCaseFinished(Instant.now(), (TestCase)testCase, new Result(Status.FAILED, Duration.ofMillis(500L), null));
        this.listener.getCaseFinished().receive((Object)finishedEvent);
        Assertions.assertThat((int)this.listener.getScFailed()).isEqualTo(1);
        Assertions.assertThat((int)this.listener.getScPassed()).isEqualTo(1);
    }

    private class ScenarioOutlineTestCaseAdapter
    extends TestcaseAdapter {
        private ScenarioOutlineTestCaseAdapter() {
        }

        @Override
        public Integer getLine() {
            return 164;
        }

        @Override
        public Location getLocation() {
            return new Location(164, 21);
        }

        @Override
        public String getName() {
            return "Auth - Fehlende Parameter alle anderen";
        }

        @Override
        public UUID getId() {
            return TestTigerCucumberListener.this.scenarioOutlineId;
        }
    }

    private class TestcaseAdapter
    implements TestCase {
        private TestcaseAdapter() {
        }

        public Integer getLine() {
            return 60;
        }

        public Location getLocation() {
            return new Location(60, 13);
        }

        public String getKeyword() {
            return null;
        }

        public String getName() {
            return "Auth - Gutfall - Validiere Claims";
        }

        public String getScenarioDesignation() {
            return null;
        }

        public List<String> getTags() {
            return null;
        }

        public List<TestStep> getTestSteps() {
            return null;
        }

        public URI getUri() {
            return TestTigerCucumberListener.this.featureUri;
        }

        public UUID getId() {
            return TestTigerCucumberListener.this.scenarioId;
        }
    }

    private static class TestStepAdapter
    implements PickleStepTestStep {
        private final UUID stepUuid = UUID.randomUUID();

        private TestStepAdapter() {
        }

        public String getCodeLocation() {
            return "featurefile:43";
        }

        public UUID getId() {
            return this.stepUuid;
        }

        public String getPattern() {
            return null;
        }

        public Step getStep() {
            return null;
        }

        public List<Argument> getDefinitionArgument() {
            return null;
        }

        public StepArgument getStepArgument() {
            return null;
        }

        public int getStepLine() {
            return 0;
        }

        public URI getUri() {
            return null;
        }

        public String getStepText() {
            return "a step text";
        }
    }
}

