/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.proxy;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.test.tiger.lib.proxy.RbelMessageProvider;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRbelMessageProvider {
    @Test
    public void testTriggerNewReceivedMessageOK() {
        RbelMessageProvider rmProvider = new RbelMessageProvider();
        rmProvider.triggerNewReceivedMessage(this.buildMessageWithContent("TestMessage"));
        Assertions.assertThat((String)((RbelElement)rmProvider.getMessages().get(0)).getRawStringContent()).contains(new CharSequence[]{"TestMessage"});
    }

    @Test
    public void testTriggerNewReceivedMessageTwoOK() {
        RbelMessageProvider rmProvider = new RbelMessageProvider();
        rmProvider.triggerNewReceivedMessage(this.buildMessageWithContent("TestMessage1"));
        rmProvider.triggerNewReceivedMessage(this.buildMessageWithContent("TestMessage2"));
        Assertions.assertThat((List)rmProvider.getMessages()).hasSize(2);
        Assertions.assertThat((String)((RbelElement)rmProvider.getMessages().get(0)).getRawStringContent()).contains(new CharSequence[]{"TestMessage1"});
        Assertions.assertThat((String)((RbelElement)rmProvider.getMessages().get(1)).getRawStringContent()).contains(new CharSequence[]{"TestMessage2"});
    }

    @Test
    public void testWaitForMessageOK() {
        RbelMessageProvider rmProvider = new RbelMessageProvider();
        rmProvider.triggerNewReceivedMessage(this.buildMessageWithContent("TestMessage1"));
        long startms = System.currentTimeMillis();
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
            rmProvider.triggerNewReceivedMessage(this.buildMessageWithContent("TestMessage2"));
        }).start();
        List msgs = rmProvider.getMessages();
        Assertions.assertThat((List)msgs).hasSize(1);
        rmProvider.waitForMessage();
        long endms = System.currentTimeMillis();
        Assertions.assertThat((long)(endms - startms)).isGreaterThan(1000L);
        Assertions.assertThat((List)rmProvider.getMessages()).hasSize(2);
        Assertions.assertThat((String)((RbelElement)rmProvider.getMessages().get(0)).getRawStringContent()).contains(new CharSequence[]{"TestMessage1"});
        Assertions.assertThat((String)((RbelElement)rmProvider.getMessages().get(1)).getRawStringContent()).contains(new CharSequence[]{"TestMessage2"});
    }

    @Test
    public void testWaitForMessageStartStepOK() {
        RbelMessageProvider rmProvider = new RbelMessageProvider();
        rmProvider.triggerNewReceivedMessage(this.buildMessageWithContent("TestMessage1"));
        long startms = System.currentTimeMillis();
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
            rmProvider.clearMessageQueue();
        }).start();
        List msgs = rmProvider.getMessages();
        Assertions.assertThat((List)msgs).hasSize(1);
        rmProvider.waitForMessage();
        long endms = System.currentTimeMillis();
        Assertions.assertThat((long)(endms - startms)).isGreaterThan(1000L);
        msgs = rmProvider.getMessages();
        Assertions.assertThat((List)msgs).isEmpty();
    }

    @Test
    public void testStartStepOK() {
        RbelMessageProvider rmProvider = new RbelMessageProvider();
        rmProvider.triggerNewReceivedMessage(this.buildMessageWithContent("TestMessage1"));
        rmProvider.triggerNewReceivedMessage(this.buildMessageWithContent("TestMessage2"));
        List msgs = rmProvider.getMessages();
        Assertions.assertThat((List)msgs).hasSize(2);
        Assertions.assertThat((String)((RbelElement)msgs.get(0)).getRawStringContent()).contains(new CharSequence[]{"TestMessage1"});
        Assertions.assertThat((String)((RbelElement)msgs.get(1)).getRawStringContent()).contains(new CharSequence[]{"TestMessage2"});
        rmProvider.clearMessageQueue();
        msgs = rmProvider.getMessages();
        Assertions.assertThat((List)msgs).isEmpty();
    }

    @Test
    public void jexlToolboxTest() {
        RbelMessageProvider rmProvider = new RbelMessageProvider();
        rmProvider.triggerNewReceivedMessage(this.buildMessageWithContent("TestMessage1"));
        rmProvider.triggerNewReceivedMessage(this.buildMessageWithContent("TestMessage2"));
    }

    private RbelElement buildMessageWithContent(String messageBody) {
        return RbelElement.builder().rawContent(messageBody.getBytes(StandardCharsets.UTF_8)).build();
    }
}

