/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.parser;

import de.gematik.test.tiger.lib.parser.FeatureParser;
import de.gematik.test.tiger.lib.parser.model.gherkin.Feature;
import de.gematik.test.tiger.lib.parser.model.gherkin.Scenario;
import de.gematik.test.tiger.lib.parser.model.gherkin.ScenarioOutline;
import de.gematik.test.tiger.lib.parser.model.gherkin.Step;
import java.nio.file.Paths;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFeatureParser {
    @Test
    public void testGermanKeywords() {
        FeatureParser p = new FeatureParser();
        Feature f = p.parseFeatureFile(Paths.get("src", "test", "resources", "testdata", "parser", "bdd", "german.feature").toFile());
        Assertions.assertThat((Object)f.getBackground()).isNotNull();
        Assertions.assertThat((List)f.getBackground().getSteps()).hasSize(10);
        Assertions.assertThat((List)f.getScenarios()).hasSize(4);
        Scenario s0 = (Scenario)f.getScenarios().get(0);
        Assertions.assertThat((String)s0.getDescription()).isEqualTo("Beschreibung1");
        Assertions.assertThat((String)s0.getName()).isEqualTo("B");
        Assertions.assertThat((List)s0.getSteps()).hasSize(10);
        Assertions.assertThat((String)((String)((Step)s0.getSteps().get(2)).getLines().get(0))).isEqualTo("Gegeben seien 2");
        ScenarioOutline s1 = (ScenarioOutline)f.getScenarios().get(1);
        Assertions.assertThat((String)s1.getDescription()).isEqualTo("Beschreibung2");
        Assertions.assertThat((List)s1.getSteps()).hasSize(10);
        Assertions.assertThat((List)s1.getExamples().getLines()).hasSize(3);
        Scenario s2 = (Scenario)f.getScenarios().get(2);
        Assertions.assertThat((String)s2.getDescription()).isEmpty();
        Assertions.assertThat((String)s2.getName()).isEqualTo("D");
        Assertions.assertThat((List)s2.getSteps()).hasSize(10);
    }

    @Test
    public void testSameNamesForScenario() {
        FeatureParser featureParser = new FeatureParser();
        Feature f = featureParser.parseFeatureFile(Paths.get("src", "test", "resources", "testdata", "parser", "bdd", "ScenarioWithSameName.feature").toFile());
        Assertions.assertThat((Object)f.getBackground()).isNull();
        Assertions.assertThat((List)f.getScenarios()).hasSize(2);
        f.getScenarios().forEach(gherkinStruct -> Assertions.assertThat((String)gherkinStruct.getName()).isEqualTo("Simple first test"));
        Scenario s0 = (Scenario)f.getScenarios().get(0);
        Assertions.assertThat((List)s0.getSteps()).hasSize(4);
        Assertions.assertThat((Integer)s0.getLineNumber()).isEqualTo(3);
        Scenario s1 = (Scenario)f.getScenarios().get(1);
        Assertions.assertThat((List)s1.getSteps()).hasSize(5);
        Assertions.assertThat((Integer)s1.getLineNumber()).isEqualTo(10);
    }
}

