/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.json;

import de.gematik.test.tiger.lib.json.JsonChecker;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.json.JSONObject;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonCheckerTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonCheckerTest.class);
    final JsonChecker check = new JsonChecker();

    private static Stream<Arguments> provideDataForMatchingJsonObjects() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Match json: extra field, optional field", "{ attr1: 'val1' }", "{ attr1: 'val1', ____attr2: 'val2' } ", Optional.empty(), true}), Arguments.of((Object[])new Object[]{"Match json: optional field", "{ attr1:'val1', attr2:'val2' }", "{ attr1: 'val1', ____attr2: 'val2' }", Optional.empty(), true}), Arguments.of((Object[])new Object[]{"Match json: optional field with regex value", "{ attr1:'val1', attr2:'val2' }", "{ attr1: 'val1', ____attr2: 'v.*' }", Optional.empty(), true}), Arguments.of((Object[])new Object[]{"Match json: optional field with incorrect regex value", "{ attr1:'val1', attr2:'val2' }", "{ attr1: 'val1', ____attr2: 'valXXX' }", Optional.of(AssertionError.class), true}), Arguments.of((Object[])new Object[]{"Match json: optional field with incorrect regex value", "{ attr1:'val1', attr2:'val2' }", "{ attr1: 'val1', ____attr2: 'v?\\\\d' }", Optional.of(AssertionError.class), true}), Arguments.of((Object[])new Object[]{"Match json: missing field, optional field, extra attributes checked", "{ attr1: 'val1', attr3: 'val3' }", "{ attr1: 'val1', ____attr2: 'val2' }", Optional.of(AssertionError.class), true}), Arguments.of((Object[])new Object[]{"Match json: missing field, optional field, extra attributes not checked", "{ attr1: 'val1', attr3: 'val3' }", "{ attr1: 'val1', ____attr2: 'val2' }", Optional.empty(), false}), Arguments.of((Object[])new Object[]{"Match json: missing fields, extra attributes not checked", "{ attr1: 'val1', attr3: 'val3', attr4:'val4' }", "{ attr1: 'val1'}", Optional.empty(), false}), Arguments.of((Object[])new Object[]{"Match json: invalid oracle string", "{ attr1: 'val1', attr3: 'val3' }", "{ attr1: 'val1', ____attr2: 'val2' ::::  }", Optional.of(JsonChecker.JsonCheckerConversionException.class), false}), Arguments.of((Object[])new Object[]{"Match json: invalid json", "{ attr1: 'val1', attr3: 'val3' :::: }", "{ attr1: 'val1', ____attr2: 'val2'  }", Optional.of(JsonChecker.JsonCheckerConversionException.class), false}), Arguments.of((Object[])new Object[]{"Match json: null value is equal to $NULL", "{ attr1: 'val1', attr3: null }", "{ attr1: 'val1', attr3: '$NULL'}", Optional.empty(), true}), Arguments.of((Object[])new Object[]{"Match json: nested object, valid", "{ attr1: { sub1: 'val1' }, attr2:'val2' }", "{ attr1: { sub1: 'val1' }, attr2:'val2' }", Optional.empty(), true}), Arguments.of((Object[])new Object[]{"Match json: nested object, correct regex", "{ attr1: { sub1: 'val1' }, attr2:'val2' }", "{ attr1: { sub1: 'v.*1' }, attr2: 'val2' }", Optional.empty(), true}), Arguments.of((Object[])new Object[]{"Match json: nested value equal to $NULL", "{ attr1: { sub1: null }, attr2:'val2' }", "{ attr1: { sub1: '$NULL' }, attr2: 'val2' }", Optional.empty(), true}), Arguments.of((Object[])new Object[]{"Match json: nested object, incorrect regex", "{ attr1: { sub1: 'val1' }, attr2:'val2' }", "{ attr1: { sub1: 'val1xxxx' }, attr2: 'val2' }", Optional.of(AssertionError.class), true}), Arguments.of((Object[])new Object[]{"Match json: nested object, incorrect regex", "{ attr1: { sub1: 'val1' }, attr2:'val2' }", "{ attr1: { sub1: 'xxx.*' }, attr2: 'val2' }", Optional.of(AssertionError.class), true}), Arguments.of((Object[])new Object[]{"Match json: ignore value of the key", "{ attr1: 'val1', attr3: 'val3' }", "{ attr1: 'val1', attr3: \"${json-unit.ignore}\"} }", Optional.empty(), true}), Arguments.of((Object[])new Object[]{"Match json: equals tested before regex", "{ attr1: '\\\\d+', attr3: 'val3' }", "{ attr1: '\\\\d+', attr3: 'val3' }", Optional.empty(), true}), Arguments.of((Object[])new Object[]{"Match json: ignore value of the nested key", "{ attr1: { sub1: 'val1' }, attr2:'val2' }", "{ attr1: { sub1: \"${json-unit.ignore}\" }, attr2:'val2' }", Optional.empty(), true}), Arguments.of((Object[])new Object[]{"Match json: missing fields in a nested array, extra attributes not checked", "{id:1,name:'Joe',friends:[{id:2,name:'Pat',pets:['dog']},{id:3,name:'Sue',pets:['cat','fish']}],pets:[]}", "{id:1,name:'Joe'}", Optional.empty(), false}), Arguments.of((Object[])new Object[]{"Match json: missing field in a nested array, extra attributes checked", "{id:1,name:'Joe',friends:[{id:2,name:'Pat',pets:['dog']},{id:3,name:'Sue',pets:['cat','fish']}],pets:[]}", "{id:1,name:'Joe',pets:[]}", Optional.of(AssertionError.class), true}), Arguments.of((Object[])new Object[]{"Match json: ignore value of a bigger nested key", "{id:1,name:'Joe',friends:[{id:2,name:'Pat',pets:['dog']},{id:3,name:'Sue',pets:['cat','fish']}],pets:[]}", "{id:1,name:'Joe',friends:\"${json-unit.ignore}\" ,pets:[]}", Optional.empty(), true}), Arguments.of((Object[])new Object[]{"Match json: nested array", "{id:1,name:'Joe',friends:[{id:2,name:'Pat',pets:['dog']},{id:3,name:'Sue',pets:['cat','fish']}],pets:[]}", "{id:1,name:'Joe',friends:[{id:2,name:'Pat',pets:['dog']},{id:3,name:'Sue',pets:['cat','fish']}],pets:[]}", Optional.empty(), true}), Arguments.of((Object[])new Object[]{"Match json: nested array, lenient mode", "{id:1,name:'Joe',friends:[{id:2,name:'Pat',pets:['dog']},{id:3,name:'Sue',pets:['cat','fish']}],pets:[]}", "{id:1,name:'Joe',friends:[{pets:['dog'],id:2,name:'Pat'},{pets:['cat','fish'],id:3,name:'Sue'}],pets:[]}", Optional.empty(), true}), Arguments.of((Object[])new Object[]{"Match json: nested array, $NULL value", "{id:1,name:'Joe',friends:null,pets:[]}", "{id:1,name:'Joe',friends:'$NULL',pets:[]}", Optional.empty(), true}));
    }

    private static Stream<Arguments> provideDataForMatchingJsonAttributes() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Match value to key: absolute match", "{ attr1: 'val1', attr3: 'val3' }", "attr3", "val3", Optional.empty()}), Arguments.of((Object[])new Object[]{"Match value to key: null value", "{ attr1: 'val1', attr3: null }", "attr3", null, Optional.empty()}), Arguments.of((Object[])new Object[]{"Match value to key: null value, $REMOVE", "{ attr1: 'val1', attr3: null }", "attr3", "$REMOVE", Optional.of(AssertionError.class)}), Arguments.of((Object[])new Object[]{"Match value to key: no null value", "{ attr1: 'val1', attr3: 'val3' }", "attr3", null, Optional.of(AssertionError.class)}), Arguments.of((Object[])new Object[]{"Match value to key: using $REMOVE", "{ attr1: 'val1', attr5: 'val3' }", "attr3", "$REMOVE", Optional.empty()}), Arguments.of((Object[])new Object[]{"Match value to key: using $REMOVE, key exists", "{ attr1: 'val1', attr3: 'val3' }", "attr3", "$REMOVE", Optional.of(AssertionError.class)}), Arguments.of((Object[])new Object[]{"Match value to key: with correct regex", "{ attr1: 'val1', attr3: 'val3' }", "attr3", "v.*", Optional.empty()}), Arguments.of((Object[])new Object[]{"Match value to key: with incorrect regex", "{ attr1: 'val1', attr3: 'val3' }", "attr3", "val3XXXX", Optional.of(AssertionError.class)}), Arguments.of((Object[])new Object[]{"Match value to key: with incorrect regex", "{ attr1: 'val1', attr3: 'val3' }", "attr3", "xxx.*", Optional.of(AssertionError.class)}), Arguments.of((Object[])new Object[]{"Match value to key: nested object, check nested key", "{ attr1: { sub1: 'val1' }, attr2:'val2' }", "attr1", "{\"sub1\":\"val1\"}", Optional.empty()}), Arguments.of((Object[])new Object[]{"Match value to key: nested object, $REMOVE, key exists", "{ attr1: { sub1: 'val1' }, attr2:'val2' }", "attr1", "$REMOVE", Optional.of(AssertionError.class)}), Arguments.of((Object[])new Object[]{"Match value to key: nested object, $REMOVE, key exists", "{ attr1: { sub1: 'val1' }, attr2:'val2' }", "attr1", "$REMOVE", Optional.of(AssertionError.class)}), Arguments.of((Object[])new Object[]{"Match value to key: nested object, $REMOVE, no key exists", "{ attr2: { sub1: 'val1' }, attr5:'val2' }", "attr1", "$REMOVE", Optional.empty()}), Arguments.of((Object[])new Object[]{"Match value to key: nested object, regex for second value correct", "{ attr1: { sub1: 'val1' }, attr2:'val2' }", "attr2", "v.*", Optional.empty()}), Arguments.of((Object[])new Object[]{"Match value to key: nested array, get value", "{id:1,name:'Joe',friends:[{id:2,name:'Pat',pets:['dog']},{id:3,name:'Sue',pets:['cat','fish']}],pets:[]}", "friends", "[{\"pets\":[\"dog\"],\"name\":\"Pat\",\"id\":2},{\"pets\":[\"cat\",\"fish\"],\"name\":\"Sue\",\"id\":3}]", Optional.empty()}), Arguments.of((Object[])new Object[]{"Match value to key: nested array, $REMOVE, key exists", "{id:1,name:'Joe',friends:[{id:2,name:'Pat',pets:['dog']},{id:3,name:'Sue',pets:['cat','fish']}],pets:[]}", "friends", "$REMOVE", Optional.of(AssertionError.class)}), Arguments.of((Object[])new Object[]{"Match value to key: extra field, $REMOVE, no key exists", "{id:1,name:'Joe',friends:[{id:2,name:'Pat',pets:['dog']},{id:3,name:'Sue',pets:['cat','fish']}],pets:[]}", "names", "$REMOVE", Optional.empty()}));
    }

    private static Stream<Arguments> provideDataForNotMatchingJsonAttributes() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Not match value to key: key matches value", "{ attr1: 'val1', attr3: 'val3' }", "attr3", "val3", Optional.of(AssertionError.class)}), Arguments.of((Object[])new Object[]{"Not match value to key: key matches null", "{ attr1: 'val1', attr3: null }", "attr3", null, Optional.of(AssertionError.class)}), Arguments.of((Object[])new Object[]{"Not match value to key: key not matches Optional.empty()", "{ attr1: 'val1', attr3: 'val3' }", "attr3", null, Optional.empty()}), Arguments.of((Object[])new Object[]{"Not match value to key: $REMOVE, no key present", "{ attr1: 'val1', attr5: 'val3' }", "attr3", "$REMOVE", Optional.of(AssertionError.class)}), Arguments.of((Object[])new Object[]{"Not match value to key: $REMOVE, key present", "{ attr1: 'val1', attr3: 'val3' }", "attr3", "$REMOVE", Optional.empty()}), Arguments.of((Object[])new Object[]{"Not match value to key: regex for value incorrect", "{ attr1: 'val1', attr3: 'val3' }", "attr3", "val3XXXX", Optional.empty()}), Arguments.of((Object[])new Object[]{"Not match value to key: regex for value correct", "{ attr1: 'val1', attr3: 'val3' }", "attr3", "v.*", Optional.of(AssertionError.class)}), Arguments.of((Object[])new Object[]{"Not match value to key: regex for value incorrect", "{ attr1: 'val1', attr3: 'val3' }", "attr3", "xxx.*", Optional.empty()}));
    }

    @ParameterizedTest
    @MethodSource(value={"provideDataForMatchingJsonObjects"})
    public void testMatchOContainInAnyOrderJsonObjects(String testInfo, String jsonStr, String oracleStr, Optional<Class<Error>> exception, boolean checkExtraAttributes) {
        log.info(testInfo);
        if (exception.isEmpty()) {
            this.check.assertJsonObjectShouldMatchOrContainInAnyOrder(jsonStr, oracleStr, checkExtraAttributes);
        } else {
            Assertions.assertThatThrownBy(() -> this.check.assertJsonObjectShouldMatchOrContainInAnyOrder(jsonStr, oracleStr, checkExtraAttributes)).isInstanceOf(exception.get());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"provideDataForMatchingJsonAttributes"})
    public void testJsonAttributeShouldMatch(String testInfo, String jsonObject, String claimName, String regex, Optional<Class<Error>> exception) {
        log.info(testInfo);
        if (exception.isEmpty()) {
            this.check.assertJsonAttributeShouldMatch(new JSONObject(jsonObject), claimName, regex);
        } else {
            Assertions.assertThatThrownBy(() -> this.check.assertJsonAttributeShouldMatch(new JSONObject(jsonObject), claimName, regex)).isInstanceOf(exception.get());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"provideDataForNotMatchingJsonAttributes"})
    public void testJsonAttributeShouldNotMatch(String testInfo, String jsonObject, String claimName, String regex, Optional<Class<Error>> exception) {
        log.info(testInfo);
        if (exception.isEmpty()) {
            this.check.assertJsonAttributeShouldNotMatch(new JSONObject(jsonObject), claimName, regex);
        } else {
            Assertions.assertThatThrownBy(() -> this.check.assertJsonAttributeShouldNotMatch(new JSONObject(jsonObject), claimName, regex)).isInstanceOf(exception.get());
        }
    }

    @ParameterizedTest
    @CsvSource(value={"N_o_T a {{{ j[[son; {\"correct\":\"json\"}; N_o_T", "{\"correct\":\"json\"}; N_o_T a {{{ j[[son; N_o_T", "{\"array\":\"json\"}; {\"array\":[1,2,3]}; Expected an 'JSONArray' at key 'array', but found 'String'", "{\"array\":[1,2,3]}; {\"array\":\"json\"}; Expected an 'String' at key 'array', but found 'JSONArray'"}, delimiter=59)
    public void testMatchOContainInAnyOrderJsonObjects(String jsonStr, String oracleStr, String exceptionShouldContain) {
        Assertions.assertThatThrownBy(() -> this.check.assertJsonObjectShouldMatchOrContainInAnyOrder(jsonStr, oracleStr, true)).hasMessageContaining(exceptionShouldContain);
    }
}

