/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.rbel;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.test.tiger.lib.rbel.RbelMessageValidator;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.xmlunit.XMLUnitException;

public class RbelMessageValidatorTest {
    @Test
    public void testPathEqualsWithRelativePath_OK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath("/foo/bar?sch=mar"), "/foo/bar")).isTrue();
    }

    @Test
    public void testPathEqualsWithUrl_OK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath("http://bl.ub/foo/bar?sch=mar"), "/foo/bar")).isTrue();
    }

    @Test
    public void testPathMatchingWithUrlLeading_OK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath("http://bl.ub/foo/bar?sch=mar"), "\\/.*\\/bar")).isTrue();
    }

    @Test
    public void testPathMatchingWithUrlTrailing_OK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath("http://bl.ub/foo/bar?sch=mar"), "\\/foo\\/.*")).isTrue();
    }

    @Test
    public void testPathMatchingWithUrlInMid_OK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath("http://bl.ub/foo/bar/test?sch=mar"), "\\/foo\\/.*/test")).isTrue();
    }

    @Test
    public void testPathMatchingWithInvalidRegex_NOK() {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath("http://bl.ub/foo/bar/test?sch=mar"), "/foo/.*/[test]")).isFalse();
    }

    private RbelElement buildRequestWithPath(String path) {
        RbelElement rbelElement = new RbelElement(null, null);
        rbelElement.addFacet((RbelFacet)RbelHttpRequestFacet.builder().path(new RbelElement(path.getBytes(), null)).build());
        return rbelElement;
    }

    @Test
    public void testSourceTestInvalid_NOK() {
        Assertions.assertThatThrownBy(() -> new RbelMessageValidator().compareXMLStructure("<root><header></header><body><!-- test comment-- --></body>", "<root><header></header><body></body></root>")).isInstanceOf(XMLUnitException.class);
    }

    @Test
    public void testSourceOracleInvalid_NOK() {
        Assertions.assertThatThrownBy(() -> new RbelMessageValidator().compareXMLStructure("<root><header></header><body><!-- test comment --></body></root>", "<root><header></header><body></body>")).isInstanceOf(XMLUnitException.class);
    }

    @Test
    public void testSourceNoComment_OK() {
        new RbelMessageValidator().compareXMLStructure("<root><header></header><body><!-- test comment --></body></root>", "<root><header></header><body></body></root>", "nocomment");
    }

    @Test
    public void testSourceNoCommetTxtTrim_OK() {
        new RbelMessageValidator().compareXMLStructure("<root><header></header><body>test     <!-- test comment --></body></root>", "<root><header></header><body>test</body></root>", "nocomment,txttrim");
    }

    @Test
    public void testSourceNoCommetTxtTrim2_OK() {
        new RbelMessageValidator().compareXMLStructure("<root><header></header><body>    test     <!-- test comment --></body></root>", "<root><header></header><body>test</body></root>", "nocomment,txttrim");
    }

    @Test
    public void testSourceNoCommetTxtTrim3_OK() {
        new RbelMessageValidator().compareXMLStructure("<root><header></header><body>    test xxx    <!-- test comment --></body></root>", "<root><header></header><body>test xxx</body></root>", "nocomment,txttrim");
    }

    @Test
    public void testSourceNoCommetTxtTrim4_OK() {
        Assertions.assertThatThrownBy(() -> new RbelMessageValidator().compareXMLStructure("<root><header></header><body>    test   xxx    <!-- test comment --></body></root>", "<root><header></header><body>test xxx</body></root>", "nocomment,txttrim")).isInstanceOf(AssertionError.class);
    }

    @Test
    public void testSourceNoCommetTxtNormalize_OK() {
        new RbelMessageValidator().compareXMLStructure("<root><header></header><body>  test    xxxx   </body>  <!-- test comment --></root>", "<root><header></header><body>test xxxx </body></root>", "nocomment,txtnormalize");
    }

    @Test
    public void testSourceAttrOrder_OK() {
        new RbelMessageValidator().compareXMLStructure("<root><header></header><body attr1='1'   attr2='2'></body></root>", "<root><header></header><body attr2='2' attr1='1'></body></root>");
    }

    @ParameterizedTest
    @CsvSource(value={"http://server, ''", "http://server/, /", "http://server, /", "http://server/, ''"})
    public void testEmptyPathMatching(String url, String path) {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath(url), path)).isTrue();
    }

    @ParameterizedTest
    @CsvSource(value={"http://server/blu/, /", "http://server/, /bla", "http://server/bla, ''"})
    public void testPathOfMessageMatch_NOK(String url, String path) {
        Assertions.assertThat((boolean)new RbelMessageValidator().doesPathOfMessageMatch(this.buildRequestWithPath(url), path)).isFalse();
    }
}

