/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelXmlFacet;
import de.gematik.rbellogger.util.RbelPathExecutor;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.lib.json.JsonChecker;
import de.gematik.test.tiger.lib.rbel.RbelMessageValidator;
import io.cucumber.java.de.Dann;
import io.cucumber.java.de.Gegebensei;
import io.cucumber.java.de.Wenn;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RBelValidatorGlue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RBelValidatorGlue.class);
    static final RbelMessageValidator rbelValidator = new RbelMessageValidator();

    public static RbelMessageValidator getRbelValidator() {
        return rbelValidator;
    }

    @Gegebensei(value="TGR setze Anfrage Timeout auf {int} Sekunden")
    @Given(value="TGR set request wait timeout to {int} seconds")
    public void tgrSetRequestWaitTimeout(int waitsec) {
        TigerGlobalConfiguration.putValue((String)"tiger.rbel.request.timeout", (Object)waitsec, (SourceType)SourceType.TEST_CONTEXT);
    }

    @Wenn(value="TGR l\u00f6sche aufgezeichnete Nachrichten")
    @When(value="TGR clear recorded messages")
    public void tgrClearRecordedMessages() {
        rbelValidator.clearRBelMessages();
    }

    @Wenn(value="TGR filtere Anfragen nach Server {string}")
    @When(value="TGR filter requests based on host {string}")
    public void tgrFilterBasedOnHost(String hostname) {
        TigerGlobalConfiguration.putValue((String)"tiger.rbel.request.filter.host", (String)hostname, (SourceType)SourceType.TEST_CONTEXT);
    }

    @Wenn(value="TGR filtere Anfragen nach HTTP Methode {string}")
    @When(value="TGR filter requests based on method {string}")
    public void tgrFilterBasedOnMethod(String method) {
        TigerGlobalConfiguration.putValue((String)"tiger.rbel.request.filter.method", (String)method.toUpperCase(), (SourceType)SourceType.TEST_CONTEXT);
    }

    @Wenn(value="TGR l\u00f6sche den gesetzten HTTP Methodenfilter")
    @When(value="TGR reset request method filter")
    public void tgrResetRequestMethodFilter() {
        TigerGlobalConfiguration.putValue((String)"tiger.rbel.request.filter.method", null, (SourceType)SourceType.TEST_CONTEXT);
    }

    @Wenn(value="TGR finde die erste Anfrage mit Pfad {string}")
    @When(value="TGR find request to path {string}")
    public void findRequestToPath(String path) {
        String parsedPath = TigerGlobalConfiguration.resolvePlaceholders((String)path);
        rbelValidator.filterRequestsAndStoreInContext(parsedPath, null, null, false);
    }

    @Wenn(value="TGR finde die erste Anfrage mit Pfad {string} und Knoten {string} der mit {string} \u00fcbereinstimmt")
    @When(value="TGR find request to path {string} with {string} matching {string}")
    public void findRequestToPathWithCommand(String path, String rbelPath, String value) {
        String parsedPath = TigerGlobalConfiguration.resolvePlaceholders((String)path);
        String parsedRbelPath = TigerGlobalConfiguration.resolvePlaceholders((String)rbelPath);
        String parsedValue = TigerGlobalConfiguration.resolvePlaceholders((String)value);
        rbelValidator.filterRequestsAndStoreInContext(parsedPath, parsedRbelPath, parsedValue, false);
    }

    @Wenn(value="TGR finde die n\u00e4chste Anfrage mit dem Pfad {string}")
    @When(value="TGR find next request to path {string}")
    public void findNextRequestToPath(String path) {
        String parsedPath = TigerGlobalConfiguration.resolvePlaceholders((String)path);
        rbelValidator.filterRequestsAndStoreInContext(parsedPath, null, null, true);
    }

    @Wenn(value="TGR finde die n\u00e4chste Anfrage mit Pfad {string} und Knoten {string} der mit {string} \u00fcbereinstimmt")
    @When(value="TGR find next request to path {string} with {string} matching {string}")
    public void findNextRequestToPathWithCommand(String path, String rbelPath, String value) {
        String parsedPath = TigerGlobalConfiguration.resolvePlaceholders((String)path);
        String parsedRbelPath = TigerGlobalConfiguration.resolvePlaceholders((String)rbelPath);
        String parsedValue = TigerGlobalConfiguration.resolvePlaceholders((String)value);
        rbelValidator.filterRequestsAndStoreInContext(parsedPath, parsedRbelPath, parsedValue, true);
    }

    @Wenn(value="TGR finde eine Nachricht mit Knoten {string} der mit {string} \u00fcbereinstimmt")
    @When(value="TGR any message with attribute {string} matches {string}")
    public void findAnyMessageAttributeMatches(String rbelPath, String value) {
        String parsedValue = TigerGlobalConfiguration.resolvePlaceholders((String)value);
        rbelValidator.getRbelMessages().stream().filter(msg -> ((RbelElement)new RbelPathExecutor(msg, rbelPath).execute().get(0)).getRawStringContent().equals(parsedValue)).findAny().orElseThrow(() -> new AssertionError((Object)("No message with matching value '" + value + "' at path '" + rbelPath + "'")));
    }

    @Dann(value="TGR speichere Wert des Knotens {string} der aktuellen Antwort in der Variable {string}")
    @Then(value="TGR store current response node text value at {string} in variable {string}")
    public void storeCurrentResponseNodeTextValueInVariable(String rbelPath, String varName) {
        String text = rbelValidator.findElemsInLastResponse(rbelPath).stream().map(RbelElement::getRawStringContent).map(String::trim).collect(Collectors.joining());
        String key = varName;
        TigerGlobalConfiguration.putValue((String)key, (String)text, (SourceType)SourceType.TEST_CONTEXT);
        log.info(String.format("Storing '%s' in variable '%s'", text, key));
    }

    @Dann(value="TGR ersetze {string} mit {string} im Inhalt der Variable {string}")
    @Then(value="TGR replace {string} with {string} in content of variable {string}")
    public void replaceContentOfVariable(String regexPattern, String replace, String varName) {
        String key = varName;
        String content = TigerGlobalConfiguration.readString((String)key, null);
        String newContent = content.replaceAll(regexPattern, replace);
        TigerGlobalConfiguration.putValue((String)key, (String)newContent, (SourceType)SourceType.TEST_CONTEXT);
        log.info(String.format("Modified content in variable '%s' to '%s'", key, newContent));
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort stimmt im Body \u00fcberein mit:")
    @Then(value="TGR current response body matches")
    public void currentResponseBodyMatches(String docString) {
        String parsedDocString = TigerGlobalConfiguration.resolvePlaceholders((String)docString);
        this.currentResponseMessageAtMatches("$.body", parsedDocString);
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort stimmt im Knoten {string} \u00fcberein mit {string}")
    @Then(value="TGR current response with attribute {string} matches {string}")
    public void currentResponseMessageAttributeMatches(String rbelPath, String value) {
        String parsedValue;
        String parsedRbelPath = TigerGlobalConfiguration.resolvePlaceholders((String)rbelPath);
        String text = rbelValidator.findElemsInLastResponse(parsedRbelPath).stream().map(RbelElement::getRawStringContent).map(String::trim).collect(Collectors.joining());
        if (!text.equals(parsedValue = TigerGlobalConfiguration.resolvePlaceholders((String)value))) {
            Assertions.assertThat((String)text).matches(Pattern.compile(parsedValue, 40));
        }
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort im Knoten {string} stimmt \u00fcberein mit:")
    @Then(value="TGR current response at {string} matches")
    public void currentResponseMessageAtMatchesDocString(String rbelPath, String docString) {
        String parsedRbelPath = TigerGlobalConfiguration.resolvePlaceholders((String)rbelPath);
        String parsedDocString = TigerGlobalConfiguration.resolvePlaceholders((String)docString);
        this.currentResponseMessageAtMatches(parsedRbelPath, parsedDocString);
    }

    @Then(value="TGR current response at {string} matches {string}")
    public void currentResponseMessageAtMatches(String rbelPath, String value) {
        String parsedRbelPath = TigerGlobalConfiguration.resolvePlaceholders((String)rbelPath);
        String parsedValue = TigerGlobalConfiguration.resolvePlaceholders((String)value);
        this.currentResponseMessageAttributeMatches(parsedRbelPath, parsedValue);
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort im Knoten {string} stimmt als {word} \u00fcberein mit:")
    @Then(value="TGR current response at {string} matches as {word}")
    public void currentResponseAtMatchesAsJson(String rbelPath, String mode, String oracleDocStr) {
        String parsedRbelPath = TigerGlobalConfiguration.resolvePlaceholders((String)rbelPath);
        String parsedOracleDocStr = TigerGlobalConfiguration.resolvePlaceholders((String)oracleDocStr);
        switch (mode.toUpperCase()) {
            case "JSON": {
                new JsonChecker().assertJsonObjectShouldMatchOrContainInAnyOrder(rbelValidator.findElemInLastResponse(parsedRbelPath).getRawStringContent(), parsedOracleDocStr, false);
                break;
            }
            case "XML": {
                RbelElement el = rbelValidator.findElemInLastResponse(parsedRbelPath);
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)el.hasFacet(RbelXmlFacet.class)).withFailMessage("Node '" + rbelPath + "' is not XML", new Object[0])).isTrue();
                rbelValidator.compareXMLStructure(el.getRawStringContent(), parsedOracleDocStr);
            }
        }
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort im Knoten {string} stimmt als XML mit folgenden diff Optionen {string} \u00fcberein mit:")
    @Then(value="TGR current response at {string} matches as XML and diff options {string}")
    public void currentResponseAtMatchesAsXMLAndDiffOptions(String rbelPath, String diffOptionsCSV, String xmlDocStr) {
        String parsedRbelPath = TigerGlobalConfiguration.resolvePlaceholders((String)rbelPath);
        String parsedXmlDocStr = TigerGlobalConfiguration.resolvePlaceholders((String)xmlDocStr);
        RbelElement el = rbelValidator.findElemInLastResponse(parsedRbelPath);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)el.hasFacet(RbelXmlFacet.class)).withFailMessage("Node '" + rbelPath + "' is not XML", new Object[0])).isTrue();
        rbelValidator.compareXMLStructure(el.getRawStringContent(), parsedXmlDocStr, diffOptionsCSV);
    }
}

