/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.reports;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit5.WireMockRuntimeInfo;
import com.github.tomakehurst.wiremock.junit5.WireMockTest;
import de.gematik.test.tiger.hooks.TigerTestHooks;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.reports.RestAssuredLogToCurlCommandParser;
import de.gematik.test.tiger.lib.reports.TigerRestAssuredCurlLoggingFilter;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.test.util.ReflectionTestUtils;

@WireMockTest
public class TestRestAssuredLogToCurlCommandParser {
    @BeforeEach
    public void setup(WireMockRuntimeInfo remoteServer) {
        remoteServer.getWireMock().register(WireMock.get((String)"/foo").willReturn(WireMock.aResponse().withBody("bor")));
        remoteServer.getWireMock().register(WireMock.get((String)"/faa").willReturn(WireMock.aResponse().withBody("bar")));
        remoteServer.getWireMock().register(WireMock.post((String)"/fuu").willReturn(WireMock.aResponse().withBody("buu")));
        remoteServer.getWireMock().register(WireMock.post((String)"/fyy").willReturn(WireMock.aResponse().withBody("byy")));
        TigerDirector.start();
    }

    @Test
    public void testMultipleRequestsSplitCorrectly(WireMockRuntimeInfo remoteServer) {
        TigerDirector.start();
        TigerDirector.getLibConfig().setAddCurlCommandsForRaCallsToReport(true);
        TigerTestHooks.registerRestAssuredFilter();
        ((Response)RestAssured.with().get(remoteServer.getHttpBaseUrl() + "/foo", new Object[0])).andReturn();
        ((Response)RestAssured.with().post(remoteServer.getHttpBaseUrl() + "/fuu", new Object[0])).andReturn();
        ((Response)RestAssured.with().post(remoteServer.getHttpBaseUrl() + "/fyy", new Object[0])).andReturn();
        ((Response)RestAssured.with().get(remoteServer.getHttpBaseUrl() + "/faa", new Object[0])).andReturn();
        Assertions.assertThat((List)RestAssuredLogToCurlCommandParser.convertRestAssuredLogToCurlCalls((String)this.getCurlLog())).hasSize(4);
    }

    @Test
    public void testSingleRequestsSplitCorrectly(WireMockRuntimeInfo remoteServer) {
        TigerDirector.start();
        TigerDirector.getLibConfig().setAddCurlCommandsForRaCallsToReport(true);
        TigerTestHooks.registerRestAssuredFilter();
        ((Response)RestAssured.with().get(remoteServer.getHttpBaseUrl() + "/foo", new Object[0])).andReturn();
        Assertions.assertThat((List)RestAssuredLogToCurlCommandParser.convertRestAssuredLogToCurlCalls((String)this.getCurlLog())).hasSize(1);
    }

    @Test
    public void testPostToCurl(WireMockRuntimeInfo remoteServer) {
        TigerDirector.start();
        TigerDirector.getLibConfig().setAddCurlCommandsForRaCallsToReport(true);
        TigerTestHooks.registerRestAssuredFilter();
        ((Response)RestAssured.with().post(remoteServer.getHttpBaseUrl() + "/fuu", new Object[0])).andReturn();
        String raLog = this.getCurlLog();
        String log = (String)RestAssuredLogToCurlCommandParser.convertRestAssuredLogToCurlCalls((String)raLog).get(0);
        String curlCmd = RestAssuredLogToCurlCommandParser.parseCurlCommandFromRestAssuredLog((String)log);
        Assertions.assertThat((String)curlCmd).isEqualTo("curl -v -H \"Accept: */*\" -H \"Content-Type: application/x-www-form-urlencoded; charset=ISO-8859-1\" -X POST \"" + remoteServer.getHttpBaseUrl() + "/fuu\" ");
    }

    @Test
    public void testGetToCurl(WireMockRuntimeInfo remoteServer) {
        TigerDirector.start();
        TigerDirector.getLibConfig().setAddCurlCommandsForRaCallsToReport(true);
        TigerTestHooks.registerRestAssuredFilter();
        ((Response)RestAssured.with().get(remoteServer.getHttpBaseUrl() + "/foo", new Object[0])).andReturn();
        String raLog = this.getCurlLog();
        String log = (String)RestAssuredLogToCurlCommandParser.convertRestAssuredLogToCurlCalls((String)raLog).get(0);
        String curlCmd = RestAssuredLogToCurlCommandParser.parseCurlCommandFromRestAssuredLog((String)log);
        Assertions.assertThat((String)curlCmd).isEqualTo("curl -v -H \"Accept: */*\" -X GET \"" + remoteServer.getHttpBaseUrl() + "/foo\" ");
    }

    private String getCurlLog() {
        return String.valueOf(((Optional)ReflectionTestUtils.getField(TigerTestHooks.class, (String)"curlLoggingFilter")).map(o -> ReflectionTestUtils.getField((Object)o, TigerRestAssuredCurlLoggingFilter.class, (String)"outputStream")).map(Object::toString).orElseThrow());
    }
}

