/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib;

import com.github.stefanbirkner.systemlambda.SystemLambda;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.exception.TigerStartupException;
import de.gematik.test.tiger.testenvmgr.InsecureTrustAllManager;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.config.Configuration;
import de.gematik.test.tiger.testenvmgr.servers.TigerServer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.springframework.boot.test.system.CapturedOutput;
import org.springframework.boot.test.system.OutputCaptureExtension;

@ExtendWith(value={OutputCaptureExtension.class})
public class TestTigerDirector {
    @BeforeEach
    public void init() {
        TigerDirector.testUninitialize();
    }

    @AfterEach
    public void clearProperties() {
        System.clearProperty("TIGER_TESTENV_CFGFILE");
        TigerGlobalConfiguration.reset();
    }

    @Test
    public void tigerActiveNotSet_TigerDirectorShouldThrowException() {
        System.setProperty("TIGER_TESTENV_CFGFILE", "src/test/resources/testdata/simpleIdp.yaml");
        Assertions.assertThat((boolean)TigerDirector.isInitialized()).isFalse();
        Assertions.assertThatThrownBy(TigerDirector::getTigerTestEnvMgr).isInstanceOf(TigerStartupException.class);
        Assertions.assertThatThrownBy(TigerDirector::getProxySettings).isInstanceOf(TigerStartupException.class);
    }

    @Test
    public void testDirectorSimpleIdp() {
        System.setProperty("TIGER_TESTENV_CFGFILE", "src/test/resources/testdata/simpleIdp2.yaml");
        TigerDirector.start();
        Assertions.assertThat((boolean)TigerDirector.isInitialized()).isTrue();
        Assertions.assertThat((Object)TigerDirector.getTigerTestEnvMgr()).isNotNull();
        Assertions.assertThat((Object)TigerDirector.getTigerTestEnvMgr().getLocalTigerProxy()).isNotNull();
        Assertions.assertThat((String)TigerDirector.getTigerTestEnvMgr().getLocalTigerProxy().getBaseUrl()).startsWith((CharSequence)"http://localhost");
        Assertions.assertThat((Object)TigerDirector.getTigerTestEnvMgr().getLocalTigerProxy().getRbelLogger()).isNotNull();
        Assertions.assertThat((Map)((TigerServer)TigerDirector.getTigerTestEnvMgr().getServers().get("idp2-simple")).getConfiguration().getDockerOptions().getPorts()).hasSize(1);
        Assertions.assertThat((Integer)((Integer)((TigerServer)TigerDirector.getTigerTestEnvMgr().getServers().get("idp2-simple")).getConfiguration().getDockerOptions().getPorts().get(8080))).isNotNull();
    }

    @Test
    public void testDirectorDisabledProxy(CapturedOutput capturedOutput) {
        System.setProperty("TIGER_TESTENV_CFGFILE", "src/test/resources/testdata/proxyDisabled.yaml");
        TigerDirector.start();
        System.out.println("PROXY:" + System.getProperty("http.proxyHost") + " / " + System.getProperty("https.proxyHost"));
        System.out.println("PORTS:" + System.getProperty("http.proxyPort") + " / " + System.getProperty("https.proxyPort"));
        Assertions.assertThat((boolean)TigerDirector.isInitialized()).isTrue();
        Assertions.assertThat((Object)TigerDirector.getTigerTestEnvMgr()).isNotNull();
        Assertions.assertThat((Object)TigerDirector.getTigerTestEnvMgr().getLocalTigerProxy()).isNotNull();
        URL url = new URL("http://idp-rise-tu-noproxy");
        URLConnection con = url.openConnection();
        InsecureTrustAllManager.allowAllSsl((URLConnection)con);
        con.setConnectTimeout(1000);
        Assertions.assertThat((String)capturedOutput.getOut()).contains(new CharSequence[]{"SKIPPING TIGER PROXY settings..."});
        Assertions.assertThatThrownBy(con::connect).isInstanceOf(Exception.class);
    }

    @Test
    public void testRouteHasHttpsEndpointURLConnection_certificateShouldBeVerified() {
        System.setProperty("TIGER_TESTENV_CFGFILE", "src/test/resources/testdata/proxyEnabled.yaml");
        TigerDirector.start();
        System.out.println("PROXY:" + System.getProperty("http.proxyHost") + " / " + System.getProperty("https.proxyHost"));
        System.out.println("PORTS:" + System.getProperty("http.proxyPort") + " / " + System.getProperty("https.proxyPort"));
        URL url = new URL("https://github.com/");
        URLConnection con = url.openConnection();
        InsecureTrustAllManager.allowAllSsl((URLConnection)con);
        con.connect();
    }

    @Test
    public void testDirectorFalsePathToYaml() {
        System.setProperty("TIGER_TESTENV_CFGFILE", "non/existing/file.yaml");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(TigerDirector::start).isInstanceOf(TigerConfigurationException.class)).hasMessageContaining("non/existing/file.yaml");
    }

    @ParameterizedTest
    @CsvSource(value={"http.proxyHost, https.proxyHost, http.proxyPort, https.proxyPort"})
    public void testLocalProxyActiveSetByDefault(String httpHost, String httpsHost, String httpPort, String httpsPort, CapturedOutput capturedOutput) {
        System.setProperty("TIGER_TESTENV_CFGFILE", "src/test/resources/testdata/proxyEnabled.yaml");
        TigerDirector.start();
        System.out.println("PROXY:" + System.getProperty(httpHost) + " / " + System.getProperty(httpsHost));
        System.out.println("PORTS:" + System.getProperty(httpHost) + " / " + System.getProperty(httpsPort));
        Assertions.assertThat((String)capturedOutput.getOut()).contains(new CharSequence[]{"SETTING TIGER PROXY..."});
        Assertions.assertThat((String)System.getProperty(httpHost)).isNotNull();
        Assertions.assertThat((String)System.getProperty(httpsHost)).isNotNull();
        Assertions.assertThat((String)System.getProperty(httpPort)).isNotNull();
        Assertions.assertThat((String)System.getProperty(httpsPort)).isNotNull();
        Assertions.assertThat((boolean)TigerDirector.getTigerTestEnvMgr().getConfiguration().isLocalProxyActive()).isTrue();
    }

    @Test
    public void checkComplexKeyOverriding() throws Exception {
        Configuration config = (Configuration)SystemLambda.withEnvironmentVariable((String)"TIGER_TESTENV_SERVERS_IDP_EXTERNALJAROPTIONS_ARGUMENTS_0", (String)"foobar").and("TIGER_TESTENV_CFGFILE", "src/test/resources/testdata/idpError.yaml").execute(() -> {
            TigerGlobalConfiguration.reset();
            return (Configuration)TigerGlobalConfiguration.instantiateConfigurationBean(Configuration.class, (String[])new String[]{"TIGER_TESTENV"});
        });
        Assertions.assertThat((String)((String)((CfgServer)config.getServers().get("idp")).getExternalJarOptions().getArguments().get(0))).isEqualTo("foobar");
    }
}

