/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.parser;

import de.gematik.test.tiger.lib.parser.ITestResultParser;
import de.gematik.test.tiger.lib.parser.TestParserException;
import de.gematik.test.tiger.lib.parser.model.Result;
import de.gematik.test.tiger.lib.parser.model.TestResult;
import de.gematik.test.tiger.lib.parser.model.Testcase;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import lombok.Generated;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityTestResultParser
implements ITestResultParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SerenityTestResultParser.class);

    @Override
    public void parseDirectoryForResults(Map<String, TestResult> results, File rootDir) {
        if (rootDir == null) {
            log.warn("Invalid test source NULL root dir");
        } else {
            File[] files = rootDir.listFiles();
            if (files == null) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Invalid test source root dir %s", rootDir.getAbsolutePath()));
                }
            } else {
                Arrays.stream(files).filter(f -> f.isFile() && f.getName().endsWith(".json")).forEach(f -> this.inspectFileForResults((File)f, results));
            }
        }
    }

    private void inspectFileForResults(File f, Map<String, TestResult> results) {
        if (f.getName().equals("requirements.json")) {
            return;
        }
        try {
            String gherkin = Files.readString(f.toPath());
            JSONObject jso = new JSONObject(gherkin);
            TestResult tr = new TestResult();
            this.setTestCaseClassNMethod(jso, tr);
            if (jso.has("tags")) {
                JSONArray tags = jso.getJSONArray("tags");
                tr.setPolarionID(IntStream.range(0, tags.length()).mapToObj(arg_0 -> ((JSONArray)tags).getJSONObject(arg_0)).filter(tag -> Objects.equals(tag.getString("type"), "TCID")).map(tag -> tag.getString("name")).findAny().orElse(null));
            }
            tr.setStatus(this.mapSerenityStatus(jso.getString("result")));
            if (tr.getStatus() == Result.ERROR || tr.getStatus() == Result.FAILED) {
                JSONObject jsoErr;
                if (jso.has("exception")) {
                    jsoErr = jso.getJSONObject("exception");
                } else if (jso.has("testFailureCause")) {
                    jsoErr = jso.getJSONObject("testFailureCause");
                } else {
                    throw new TestParserException("Unable to find failure/error details in " + jso.toString(2));
                }
                if (jsoErr.has("message")) {
                    tr.setErrmessage(jsoErr.getString("message"));
                } else {
                    tr.setErrmessage(jso.getString("testFailureSummary"));
                }
                tr.setErrdetails("");
                tr.setErrtype(jsoErr.getString("errorType"));
            }
            if (jso.has("startTime")) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.nXXXXX'['z']'");
                ZonedDateTime zonedDateTime = ZonedDateTime.parse(jso.getString("startTime"), formatter);
                tr.setStartms(zonedDateTime.toInstant().toEpochMilli());
                tr.setEndms(tr.getStartms() + (long)jso.getInt("duration") * 1000L);
            }
            results.put(tr.getClazz() + ":" + tr.getMethod(), tr);
        }
        catch (IOException | JSONException ioe) {
            log.error("Failed to parse BDD file " + f.getAbsolutePath(), ioe);
        }
    }

    private void setTestCaseClassNMethod(JSONObject jso, Testcase tc) {
        String id = jso.getString("id");
        String[] idarr = id.split(";");
        tc.setClazz(String.join((CharSequence)".", Arrays.copyOf(idarr, idarr.length - 1)));
        tc.setMethod(idarr[idarr.length - 1]);
        tc.setFeatureName(jso.getJSONObject("userStory").getString("storyName"));
        tc.setScenarioName(jso.getString("title"));
        tc.setPath(jso.getJSONObject("userStory").getString("path"));
    }

    private Result mapSerenityStatus(String serenityStatus) {
        switch (serenityStatus) {
            case "FAILURE": {
                return Result.FAILED;
            }
            case "ERROR": {
                return Result.ERROR;
            }
            case "SUCCESS": {
                return Result.PASSED;
            }
            case "SKIPPED": {
                return Result.SKIPPED;
            }
        }
        return Result.UNKNOWN;
    }
}

