/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.monitor;

import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.lib.parser.model.gherkin.Step;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import lombok.Generated;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorUI
extends JFrame {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitorUI.class);
    private JLabel message;
    private JButton quitButton;
    private boolean clickedQuitBtn = false;
    private final Pattern showSteps = Pattern.compile(".*TGR (zeige|show) ([\\w|\u00fc|\u00df]*) (Banner|banner|text|Text) \"(.*)\"");

    public static Optional<MonitorUI> getMonitor() {
        try {
            return Optional.of(new MonitorUI());
        }
        catch (HeadlessException hex) {
            log.warn("Unable to start Monitor UI on a headless server!", (Throwable)hex);
            return Optional.empty();
        }
    }

    private MonitorUI() {
        this.initUI();
        EventQueue.invokeLater(() -> this.setVisible(true));
    }

    private void initUI() {
        URL url = this.getClass().getResource("/tiger-500.png");
        this.quitButton = new JButton("Quit");
        this.quitButton.addActionListener(event -> {
            this.clickedQuitBtn = true;
        });
        this.message = new JLabel("Starting up ...");
        Container pane = this.getContentPane();
        BorderLayout bl = new BorderLayout(5, 5);
        pane.setLayout(bl);
        if (url != null) {
            ImageIcon icon = new ImageIcon(url);
            icon.setImage(icon.getImage().getScaledInstance(130, 130, 1));
            pane.add((Component)new JLabel(icon), "West");
        } else {
            pane.add((Component)new JLabel("TIger"), "West");
        }
        pane.add((Component)this.message, "Center");
        this.setAlwaysOnTop(true);
        this.setMinimumSize(new Dimension(600, 150));
        this.setLocationRelativeTo(null);
    }

    public void updateStep(Step step) {
        this.setMessage(String.join((CharSequence)"\n", step.getLines()));
    }

    private void setMessage(String stepText) {
        Matcher m = this.showSteps.matcher(stepText);
        if (m.find()) {
            try {
                Color color = (Color)Color.class.getDeclaredField(RbelAnsiColors.seekColor((String)m.group(2)).name().toUpperCase()).get(null);
                if (color == Color.YELLOW || color == Color.ORANGE || color == Color.PINK || color == Color.MAGENTA || color == Color.CYAN || color == Color.GREEN || color == Color.WHITE) {
                    this.message.setBackground(Color.BLACK);
                } else {
                    this.message.setBackground(Color.WHITE);
                }
                this.message.setForeground(color);
            }
            catch (IllegalAccessException | NoSuchFieldException ignored) {
                this.message.setForeground(Color.BLACK);
                this.message.setBackground(Color.WHITE);
            }
            this.message.setText(m.group(4));
        }
        if (stepText.endsWith("TGR warte auf Abbruch")) {
            this.clickedQuitBtn = false;
            this.getContentPane().add((Component)this.quitButton, "East");
            this.pack();
        }
    }

    public void waitForQuit(String appName) {
        this.message.setForeground(Color.RED);
        this.message.setBackground(Color.WHITE);
        this.message.setText("Bitte auf QUIT dr\u00fccken um " + appName + " zu beenden!");
        Awaitility.await().atMost(24L, TimeUnit.HOURS).pollDelay(200L, TimeUnit.MILLISECONDS).until(() -> this.clickedQuitBtn);
    }
}

