/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib;

import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.banner.Banner;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.hooks.TigerTestHooks;
import de.gematik.test.tiger.lib.TigerLibConfig;
import de.gematik.test.tiger.lib.TigerLibraryException;
import de.gematik.test.tiger.lib.exception.TigerStartupException;
import de.gematik.test.tiger.lib.monitor.MonitorUI;
import de.gematik.test.tiger.lib.parser.model.gherkin.Step;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import io.restassured.RestAssured;
import io.restassured.filter.Filter;
import java.awt.HeadlessException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerDirector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerDirector.class);
    private static TigerTestEnvMgr tigerTestEnvMgr;
    private static Optional<MonitorUI> optionalMonitorUI;
    private static boolean initialized;

    public static synchronized void startMonitorUITestEnvMgrAndTigerProxy(TigerLibConfig config) {
        TigerTestHooks.assertTigerActive();
        if (config.activateMonitorUI) {
            try {
                optionalMonitorUI = MonitorUI.getMonitor();
            }
            catch (HeadlessException hex) {
                log.error("Unable to start Monitor UI on a headless server!", (Throwable)hex);
            }
        }
        log.info("\n" + Banner.toBannerStr((String)"STARTING TESTENV MGR...", (String)RbelAnsiColors.BLUE_BOLD.toString()));
        tigerTestEnvMgr = new TigerTestEnvMgr();
        tigerTestEnvMgr.setUpEnvironment();
        TigerProxyConfiguration tpCfg = tigerTestEnvMgr.getConfiguration().getTigerProxy();
        if (tpCfg.isSkipTrafficEndpointsSubscription()) {
            log.info("Trying to late connect to traffic endpoints...");
            tigerTestEnvMgr.getLocalTigerProxy().subscribeToTrafficEndpoints(tpCfg);
        }
        if (tigerTestEnvMgr.getLocalTigerProxy() != null && tigerTestEnvMgr.getConfiguration().isLocalProxyActive()) {
            if (System.getProperty("http.proxyHost") != null || System.getProperty("https.proxyHost") != null) {
                log.info(Ansi.colorize((String)"SKIPPING TIGER PROXY settings as System Property is set already...", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
            } else {
                log.info(Ansi.colorize((String)"SETTING TIGER PROXY...", (RbelAnsiColors)RbelAnsiColors.BLUE_BOLD));
                System.setProperty("http.proxyHost", "localhost");
                System.setProperty("http.proxyPort", "" + tigerTestEnvMgr.getLocalTigerProxy().getPort());
                System.setProperty("http.nonProxyHosts", "localhost|127.0.0.1");
                System.setProperty("https.proxyHost", "localhost");
                System.setProperty("https.proxyPort", "" + tigerTestEnvMgr.getLocalTigerProxy().getPort());
                TigerDirector.setupSerenityRest();
            }
        } else {
            log.info(Ansi.colorize((String)"SKIPPING TIGER PROXY settings...", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
        }
        initialized = true;
        log.info("\n" + Banner.toBannerStr((String)"DIRECTOR STARTUP OK", (String)RbelAnsiColors.GREEN_BOLD.toString()));
    }

    private static void setupSerenityRest() {
        RestAssured.filters((requestSpec, responseSpec, ctx) -> {
            try {
                log.trace("Sending Request " + requestSpec.getMethod() + " " + requestSpec.getURI() + " via proxy " + requestSpec.getProxySpecification());
                return ctx.next(requestSpec, responseSpec);
            }
            catch (Exception e) {
                throw new TigerSerenityRestException("Error while retrieving " + requestSpec.getMethod() + " " + requestSpec.getURI() + " via proxy " + requestSpec.getProxySpecification(), e);
            }
        }, (Filter[])new Filter[0]);
    }

    public static synchronized boolean isInitialized() {
        return initialized;
    }

    public static TigerTestEnvMgr getTigerTestEnvMgr() {
        TigerDirector.assertThatTigerIsInitialized();
        return tigerTestEnvMgr;
    }

    public static void synchronizeTestCasesWithPolarion() {
        TigerDirector.assertThatTigerIsInitialized();
        if (TigerGlobalConfiguration.readBoolean((String)"TIGER_SYNC_TESTCASES", (boolean)false)) {
            try {
                Method polarionToolBoxMain = Class.forName("de.gematik.polarion.toolbox.ToolBox").getDeclaredMethod("main", String[].class);
                String[] args = new String[]{"-m", "tcimp", "-dryrun"};
                log.info("Syncing test cases with Polarion...");
                polarionToolBoxMain.invoke(null, (Object[])args);
                log.info("Test cases synched with Polarion...");
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new TigerLibraryException("Unable to access Polarion Toolbox! Be sure to have it included in mvn dependencies.", new Object[]{e});
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new TigerLibraryException("Unable to call Polarion Toolbox's main method!", new Object[]{e});
            }
        }
    }

    public static void createAfoRepoort() {
        TigerDirector.assertThatTigerIsInitialized();
    }

    public static String getProxySettings() {
        TigerDirector.assertThatTigerIsInitialized();
        if (tigerTestEnvMgr.getLocalTigerProxy() == null || !tigerTestEnvMgr.getConfiguration().isLocalProxyActive()) {
            return null;
        }
        return tigerTestEnvMgr.getLocalTigerProxy().getBaseUrl();
    }

    public static void waitForQuit() {
        optionalMonitorUI.ifPresentOrElse(monitor -> monitor.waitForQuit("Tiger Testsuite"), () -> TigerTestEnvMgr.waitForQuit((String)"Tiger Testsuite"));
    }

    public static void updateStepInMonitor(Step step) {
        optionalMonitorUI.ifPresent(monitor -> monitor.updateStep(step));
    }

    private static void assertThatTigerIsInitialized() {
        if (!TigerGlobalConfiguration.readBoolean((String)"TIGER_ACTIVE")) {
            throw new TigerStartupException("Tiger test environment has not been initialized,as the TIGER_ACTIVE environment variable is not set to '1'.");
        }
        if (!initialized) {
            throw new TigerStartupException("Tiger test environment has not been initialized. Did you call TigerDirector.beforeTestRun before starting test run?");
        }
    }

    static void testUninitialize() {
        initialized = false;
        tigerTestEnvMgr = null;
        System.clearProperty("TIGER_ACTIVE");
        System.clearProperty("TIGER_TESTENV_CFGFILE");
        System.clearProperty("http.proxyHost");
        System.clearProperty("https.proxyHost");
        System.clearProperty("http.proxyPort");
        System.clearProperty("https.proxyPort");
        TigerGlobalConfiguration.reset();
    }

    static {
        optionalMonitorUI = Optional.empty();
        initialized = false;
    }

    private static class TigerSerenityRestException
    extends RuntimeException {
        public TigerSerenityRestException(String s, Exception e) {
            super(s, e);
        }
    }
}

