/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.hooks;

import de.gematik.rbellogger.RbelOptions;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.banner.Banner;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.TigerLibConfig;
import de.gematik.test.tiger.lib.exception.TigerStartupException;
import de.gematik.test.tiger.lib.parser.FeatureParser;
import de.gematik.test.tiger.lib.parser.TestParserException;
import de.gematik.test.tiger.lib.parser.model.gherkin.Feature;
import de.gematik.test.tiger.lib.parser.model.gherkin.Scenario;
import de.gematik.test.tiger.lib.parser.model.gherkin.ScenarioOutline;
import de.gematik.test.tiger.lib.parser.model.gherkin.Step;
import de.gematik.test.tiger.lib.proxy.RbelMessageProvider;
import de.gematik.test.tiger.proxy.IRbelMessageListener;
import io.cucumber.java.After;
import io.cucumber.java.AfterStep;
import io.cucumber.java.Before;
import io.cucumber.java.BeforeStep;
import io.cucumber.java.Status;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import net.serenitybdd.core.Serenity;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerTestHooks {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerTestHooks.class);
    private static boolean initialized = false;
    private static final List<RbelElement> validatableRbelMessages = new ArrayList<RbelElement>();
    private static boolean rbelListenerAdded = false;
    private static final List<RbelElement> rbelMessages = new ArrayList<RbelElement>();
    private static final RbelMessageProvider rbelMessageListener = new RbelMessageProvider(){

        @Override
        public void triggerNewReceivedMessage(RbelElement e) {
            rbelMessages.add(e);
            validatableRbelMessages.add(e);
        }
    };
    private static final Map<URI, Feature> uriFeatureMap = new HashMap<URI, Feature>();
    private static final Map<String, List<Step>> scenarioStepsMap = new HashMap<String, List<Step>>();
    private static int currentStepIndex;
    private static final Map<String, Status> scenarioStatus;
    private static int scPassed;
    private static int scFailed;
    private static int currentDataVariantIndex;
    private static List<String> currentDataVariantKeys;
    private static List<Map<String, String>> currentDataVariant;

    @Before(order=100)
    public void parseFeatureFileAndResetRbelLog(io.cucumber.java.Scenario scenario) {
        TigerTestHooks.assertTigerActive();
        if (!initialized) {
            this.initializeTiger();
        }
        if (scenario != null) {
            Scenario tigerScenario;
            Feature feature = uriFeatureMap.computeIfAbsent(scenario.getUri(), uri -> new FeatureParser().parseFeatureFile((URI)uri));
            scenarioStepsMap.computeIfAbsent(scenario.getId(), id -> feature.getScenarios().stream().filter(sc -> sc.getName().equals(scenario.getName())).map(Scenario.class::cast).map(Scenario::getSteps).findAny().orElseThrow(() -> new TestParserException(String.format("Unable to obtain test steps for scenario %s in feature file %s", scenario.getName(), scenario.getUri()))));
            if (feature.getBackground() != null) {
                scenarioStepsMap.get(scenario.getId()).addAll(0, feature.getBackground().getSteps());
            }
            if ((tigerScenario = feature.getScenario(scenario.getName())) instanceof ScenarioOutline) {
                if (currentDataVariantIndex == -1) {
                    currentDataVariant = ((ScenarioOutline)tigerScenario).getExamplesAsList();
                    currentDataVariantKeys = ((ScenarioOutline)tigerScenario).getExampleKeys();
                    currentDataVariantIndex = 0;
                } else {
                    ++currentDataVariantIndex;
                }
            } else {
                currentDataVariantIndex = -1;
                currentDataVariant = null;
            }
            currentStepIndex = 0;
        } else {
            log.warn("No scenario has been provided, running in no cucumber mode!");
            currentStepIndex = -1;
        }
        rbelMessages.clear();
        if (!rbelListenerAdded && TigerDirector.getTigerTestEnvMgr().getLocalTigerProxy() != null) {
            TigerDirector.getTigerTestEnvMgr().getLocalTigerProxy().addRbelMessageListener((IRbelMessageListener)rbelMessageListener);
            rbelListenerAdded = true;
        }
    }

    private void initializeTiger() {
        TigerLibConfig config;
        if (!TigerGlobalConfiguration.readBoolean((String)"TIGER_NOLOGO", (boolean)false)) {
            try {
                log.info("\n" + IOUtils.toString((InputStream)Objects.requireNonNull(TigerDirector.class.getResourceAsStream("/tiger2-logo.ansi")), (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new TigerStartupException("Unable to read tiger logo!");
            }
        }
        log.info("\n" + Banner.toBannerStr((String)"READING TIGER LIB CONFIG...", (String)RbelAnsiColors.BLUE_BOLD.toString()));
        File cfgFile = new File("tiger.yml");
        if (!cfgFile.exists()) {
            cfgFile = new File("tiger.yaml");
        }
        if (cfgFile.exists()) {
            try {
                TigerGlobalConfiguration.readFromYaml((String)FileUtils.readFileToString((File)cfgFile, (Charset)StandardCharsets.UTF_8), (String[])new String[]{"TIGER_LIB"});
            }
            catch (IOException e) {
                throw new TigerStartupException("Error while reading configuration file '" + cfgFile.getAbsolutePath(), e);
            }
            config = (TigerLibConfig)TigerGlobalConfiguration.instantiateConfigurationBean(TigerLibConfig.class, (String[])new String[]{"TIGER_LIB"});
        } else {
            log.warn("No Tiger configuration file found (tiger.yaml, tiger.yml)! Continuing with default values");
            config = new TigerLibConfig();
        }
        if (config.isRbelPathDebugging()) {
            RbelOptions.activateRbelPathDebugging();
        } else {
            RbelOptions.deactivateRbelPathDebugging();
        }
        if (config.isRbelAnsiColors()) {
            RbelOptions.activateAnsiColors();
        } else {
            RbelOptions.deactivateAnsiColors();
        }
        TigerDirector.startMonitorUITestEnvMgrAndTigerProxy(config);
        initialized = true;
    }

    @BeforeStep
    public void forwardToUiMonitor(io.cucumber.java.Scenario scenario) {
        TigerTestHooks.assertTigerActive();
        Step currentStep = scenarioStepsMap.get(scenario.getId()).get(currentStepIndex);
        if (currentDataVariantIndex != -1) {
            List<String> parsedLines = currentStep.getLines().stream().map(line -> {
                String parsedLine = line;
                for (String key : currentDataVariantKeys) {
                    parsedLine = parsedLine.replace("<" + key + ">", currentDataVariant.get(currentDataVariantIndex).get(key));
                }
                return parsedLine;
            }).collect(Collectors.toList());
            currentStep = new Step(currentStep.getKeyword(), parsedLines);
        }
        log.info("CurrentStep: " + String.join((CharSequence)"\n", currentStep.getLines()));
        TigerDirector.updateStepInMonitor(currentStep);
        ++currentStepIndex;
    }

    @AfterStep
    public void addStatusIfStepFailed(io.cucumber.java.Scenario scenario) {
        TigerTestHooks.assertTigerActive();
        if (scenario.isFailed() && !scenarioStatus.containsKey(scenario.getId())) {
            scenarioStatus.put(scenario.getId(), scenario.getStatus());
        }
    }

    @After
    public void saveRbelMessagesToFile(io.cucumber.java.Scenario scenario) {
        TigerTestHooks.assertTigerActive();
        scenarioStepsMap.remove(scenario.getId());
        switch (scenario.getStatus()) {
            case PASSED: {
                ++scPassed;
                break;
            }
            case FAILED: {
                ++scFailed;
            }
        }
        log.info("------------ STATUS: {} passed {}", (Object)scPassed, scFailed > 0 ? scFailed + " failed" : "");
        File folder = Paths.get("target", "rbellogs").toFile();
        if (!folder.exists() && !folder.mkdirs()) {
            Assertions.assertThat((File)folder).exists();
        }
        try {
            RbelHtmlRenderer rbelRenderer = new RbelHtmlRenderer();
            rbelRenderer.setSubTitle("<p><b>" + scenario.getName() + "</b>&nbsp&nbsp;<u>" + (currentDataVariantIndex + 1) + "</u></p><p><i>" + scenario.getUri() + "</i></p>");
            String html = rbelRenderer.doRender(rbelMessages);
            Object name = scenario.getName();
            String map = "\u00e4a\u00c4A\u00f6o\u00d6O\u00fcu\u00dcU\u00dfs _(_)_[_]_{_}_<_>_|_$_%_&_/_\\_?_:_*_\"_";
            for (int i = 0; i < "\u00e4a\u00c4A\u00f6o\u00d6O\u00fcu\u00dcU\u00dfs _(_)_[_]_{_}_<_>_|_$_%_&_/_\\_?_:_*_\"_".length(); i += 2) {
                name = ((String)name).replace("\u00e4a\u00c4A\u00f6o\u00d6O\u00fcu\u00dcU\u00dfs _(_)_[_]_{_}_<_>_|_$_%_&_/_\\_?_:_*_\"_".charAt(i), "\u00e4a\u00c4A\u00f6o\u00d6O\u00fcu\u00dcU\u00dfs _(_)_[_]_{_}_<_>_|_$_%_&_/_\\_?_:_*_\"_".charAt(i + 1));
            }
            if (((String)name).length() > 100) {
                name = ((String)name).substring(0, 60) + UUID.nameUUIDFromBytes(((String)name).getBytes(StandardCharsets.UTF_8));
            }
            if (currentDataVariantIndex != -1) {
                name = (String)name + "_" + (currentDataVariantIndex + 1);
            }
            File logFile = Paths.get("target", "rbellogs", (String)name + ".html").toFile();
            FileUtils.writeStringToFile((File)logFile, (String)html, (Charset)StandardCharsets.UTF_8);
            Serenity.recordReportData().asEvidence().withTitle("RBellog " + (currentDataVariantIndex + 1)).downloadable().fromFile(logFile.toPath());
            log.info("Saved HTML report to " + logFile.getAbsolutePath());
        }
        catch (IOException e) {
            log.error("Unable to create/save rbel log for scenario " + scenario.getName());
        }
    }

    public static void assertTigerActive() {
        if (!TigerGlobalConfiguration.readBoolean((String)"TIGER_ACTIVE")) {
            log.error(Ansi.colorize((String)"TIGER_ACTIVE is not set to '1'. ABORTING Tiger hook!", (RbelAnsiColors)RbelAnsiColors.RED_BOLD_BRIGHT));
            throw new TigerStartupException("TIGER_ACTIVE is not set to '1'. ABORTING Tiger hook!");
        }
    }

    @Generated
    public static List<RbelElement> getValidatableRbelMessages() {
        return validatableRbelMessages;
    }

    static {
        scenarioStatus = new HashMap<String, Status>();
        scPassed = 0;
        scFailed = 0;
        currentDataVariantIndex = -1;
        currentDataVariantKeys = null;
        currentDataVariant = null;
    }
}

