/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.parser;

import de.gematik.test.tiger.lib.parser.ITestResultParser;
import de.gematik.test.tiger.lib.parser.model.Result;
import de.gematik.test.tiger.lib.parser.model.TestResult;
import java.io.File;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilderFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JUnitTestResultParser
implements ITestResultParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JUnitTestResultParser.class);

    @Override
    public void parseDirectoryForResults(Map<String, TestResult> results, File rootDir) {
        if (rootDir == null) {
            log.warn("Invalid NULL test result root dir");
        } else if (rootDir.listFiles() == null) {
            if (log.isWarnEnabled()) {
                log.warn(String.format("Invalid test result root dir %s", rootDir.getAbsolutePath()));
            }
        } else {
            Arrays.asList(Objects.requireNonNull(rootDir.listFiles())).forEach(f -> {
                if (f.getName().startsWith("TEST-") && f.getName().endsWith(".xml")) {
                    this.parseJunitXMLResult((File)f, results);
                }
            });
        }
    }

    private void parseJunitXMLResult(File file, Map<String, TestResult> results) {
        block3: {
            try {
                DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
                df.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                df.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                Document doc = df.newDocumentBuilder().parse(file);
                NodeList suites = doc.getElementsByTagName("testsuite");
                for (int i = 0; i < suites.getLength(); ++i) {
                    this.parseTestSuite((Element)suites.item(i), results);
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn(String.format("Failure while parsing result file %s", file.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private void parseTestSuite(Element suite, Map<String, TestResult> results) {
        LocalDateTime start = null;
        if (suite.hasAttribute("timestamp")) {
            start = LocalDateTime.parse(suite.getAttribute("timestamp").split(" ")[0], DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
        }
        NodeList tcs = suite.getChildNodes();
        for (int i = 0; i < tcs.getLength(); ++i) {
            Node tc = tcs.item(i);
            if (!tc.getNodeName().equals("testcase")) continue;
            TestResult tr = this.parseTestCase((Element)tc);
            tr.setSuite(suite.getAttribute("name"));
            if (start != null && !((Element)tc).getAttribute("time").isBlank()) {
                tr.setStartms(start.toInstant(ZoneOffset.UTC).toEpochMilli());
                start = start.plus((long)(1000.0 * (double)Float.parseFloat(((Element)tc).getAttribute("time"))), ChronoUnit.MILLIS);
                tr.setEndms(start.toInstant(ZoneOffset.UTC).toEpochMilli());
            } else {
                tr.setStartms(0L);
                tr.setEndms(0L);
            }
            tr.setPolarionID(tr.getMethod());
            results.put(tr.getClazz() + ":" + tr.getMethod(), tr);
        }
    }

    private TestResult parseTestCase(Element tc) {
        TestResult tr = new TestResult();
        tr.setClazz(tc.getAttribute("classname"));
        tr.setMethod(tc.getAttribute("name"));
        NodeList details = tc.getChildNodes();
        if (details.getLength() == 0) {
            tr.setStatus(Result.PASSED);
        } else {
            for (int i = 0; i < details.getLength(); ++i) {
                if (details.item(i) instanceof Text) continue;
                Element detail = (Element)details.item(i);
                boolean parseAttr = false;
                switch (detail.getNodeName()) {
                    case "failure": {
                        tr.setStatus(Result.FAILED);
                        parseAttr = true;
                        break;
                    }
                    case "error": {
                        tr.setStatus(Result.ERROR);
                        parseAttr = true;
                        break;
                    }
                    case "skipped": {
                        tr.setStatus(Result.SKIPPED);
                        parseAttr = true;
                        break;
                    }
                    case "system-out": {
                        tr.setErrsysout(detail.getTextContent());
                        break;
                    }
                    case "system-err": {
                        tr.setErrsyserr(detail.getTextContent());
                        break;
                    }
                    default: {
                        tr.setStatus(Result.UNKNOWN);
                    }
                }
                if (!parseAttr) continue;
                tr.setErrmessage(detail.getAttribute("message"));
                tr.setErrtype(detail.getAttribute("type"));
                tr.setErrdetails(detail.getTextContent());
            }
        }
        return tr;
    }
}

