/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.hooks;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.test.tiger.common.OsEnvironment;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.parser.FeatureParser;
import de.gematik.test.tiger.lib.parser.TestParserException;
import de.gematik.test.tiger.lib.parser.model.gherkin.Feature;
import de.gematik.test.tiger.lib.parser.model.gherkin.Scenario;
import de.gematik.test.tiger.lib.parser.model.gherkin.Step;
import de.gematik.test.tiger.lib.proxy.RbelMessageProvider;
import de.gematik.test.tiger.proxy.IRbelMessageListener;
import io.cucumber.java.After;
import io.cucumber.java.AfterStep;
import io.cucumber.java.Before;
import io.cucumber.java.BeforeStep;
import io.cucumber.java.Status;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.serenitybdd.core.Serenity;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerTestHooks {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerTestHooks.class);
    private static final Map<URI, Feature> uriFeatureMap = new HashMap<URI, Feature>();
    private static final Map<String, List<Step>> scenarioStepsMap = new HashMap<String, List<Step>>();
    private static final Map<String, Integer> scenarioStepsIdxMap = new HashMap<String, Integer>();
    private static final Map<String, Status> scenarioStatus = new HashMap<String, Status>();
    private static boolean rbelListenerAdded = false;
    private static final List<RbelElement> rbelMessages = new ArrayList<RbelElement>();
    private static final List<RbelElement> validatableRbelMessages = new ArrayList<RbelElement>();
    private static final RbelMessageProvider rbelMessageListener = new RbelMessageProvider(){

        @Override
        public void triggerNewReceivedMessage(RbelElement e) {
            rbelMessages.add(e);
            validatableRbelMessages.add(e);
        }
    };
    private static final Map<String, List<io.cucumber.java.Scenario>> processedScenarios = new HashMap<String, List<io.cucumber.java.Scenario>>();
    private static int scPassed = 0;
    private static int scFailed = 0;

    @Before(order=100)
    public void loadFeatureFileNResetRbelLog(io.cucumber.java.Scenario scenario) {
        if (!OsEnvironment.getAsBoolean((String)"TIGER_ACTIVE")) {
            throw new AssertionError((Object)"TIGER_ACTIVE is not set to '1'. ABORTING Tiger hook!");
        }
        if (!TigerDirector.isInitialized()) {
            TigerDirector.beforeTestRun();
        }
        Feature feature = uriFeatureMap.computeIfAbsent(scenario.getUri(), uri -> new FeatureParser().parseFeatureFile((URI)uri));
        scenarioStepsMap.computeIfAbsent(scenario.getId(), id -> feature.getScenarios().stream().filter(sc -> sc.getName().equals(scenario.getName())).map(Scenario.class::cast).map(Scenario::getSteps).findAny().orElseThrow(() -> new TestParserException(String.format("Unable to obtain test steps for scenario %s in feature file %s", scenario.getName(), scenario.getUri()))));
        if (feature.getBackground() != null) {
            scenarioStepsMap.get(scenario.getId()).addAll(0, feature.getBackground().getSteps());
        }
        scenarioStepsIdxMap.put(scenario.getId(), 0);
        rbelMessages.clear();
        if (!TigerDirector.isInitialized()) {
            System.setProperty("TIGER_ACTIVE", "1");
            System.setProperty("TIGER_TESTENV_CFGFILE", "src/test/resources/testdata/noServersActive.yaml");
            TigerDirector.beforeTestRun();
        }
        if (!rbelListenerAdded && TigerDirector.getTigerTestEnvMgr().getLocalTigerProxy() != null) {
            TigerDirector.getTigerTestEnvMgr().getLocalTigerProxy().addRbelMessageListener((IRbelMessageListener)rbelMessageListener);
            rbelListenerAdded = true;
        }
    }

    @BeforeStep
    public void beforeStep(io.cucumber.java.Scenario scenario) {
        if (!OsEnvironment.getAsBoolean((String)"TIGER_ACTIVE")) {
            log.error("TIGER_ACTIVE is not set to '1'. ABORTING Tiger hook!");
            return;
        }
        int idx = scenarioStepsIdxMap.get(scenario.getId());
        log.info("\u001b[32m\u001b[1mExecuting step " + String.join((CharSequence)"\r\n", scenarioStepsMap.get(scenario.getId()).get(idx).getLines()) + "\u001b[0m");
    }

    @AfterStep
    public void afterStep(io.cucumber.java.Scenario scenario) {
        if (!OsEnvironment.getAsBoolean((String)"TIGER_ACTIVE")) {
            log.error("TIGER_ACTIVE is not set to '1'. ABORTING Tiger hook!");
            return;
        }
        int idx = scenarioStepsIdxMap.get(scenario.getId());
        if (scenario.isFailed() && !scenarioStatus.containsKey(scenario.getId())) {
            scenarioStatus.put(scenario.getId(), scenario.getStatus());
            log.info("\u001b[31m\u001b[1mFailed @ step " + String.join((CharSequence)"\r\n", scenarioStepsMap.get(scenario.getId()).get(idx).getLines()) + "\u001b[0m");
        }
        scenarioStepsIdxMap.put(scenario.getId(), idx + 1);
    }

    @After
    public void purgeFeatureFileAndSaveRbelLog(io.cucumber.java.Scenario scenario) {
        if (!OsEnvironment.getAsBoolean((String)"TIGER_ACTIVE")) {
            log.error("TIGER_ACTIVE is not set to '1'. ABORTING Tiger hook!");
            return;
        }
        scenarioStepsMap.remove(scenario.getId());
        switch (scenario.getStatus()) {
            case PASSED: {
                ++scPassed;
                break;
            }
            case FAILED: {
                ++scFailed;
            }
        }
        if (scFailed > 0) {
            log.error("------------ STATUS: {} passed  {} failed", (Object)scPassed, (Object)scFailed);
        } else {
            log.info("------------ STATUS: {} passed", (Object)scPassed);
        }
        File folder = Paths.get("target", "rbellogs").toFile();
        if (!folder.exists() && !folder.mkdirs()) {
            Assertions.assertThat((File)folder).exists();
        }
        String scenarioId = scenario.getUri().toString() + ":" + scenario.getName();
        processedScenarios.computeIfAbsent(scenarioId, uri -> new ArrayList());
        int dataVariantIdx = processedScenarios.get(scenarioId).size();
        processedScenarios.get(scenarioId).add(scenario);
        RbelHtmlRenderer rbelRenderer = new RbelHtmlRenderer();
        rbelRenderer.setSubTitle("<p><b>" + scenario.getName() + "</b>&nbsp&nbsp;<u>" + (dataVariantIdx + 1) + "</u></p><p><i>" + scenario.getUri() + "</i></p>");
        String html = rbelRenderer.doRender(rbelMessages);
        try {
            Object name = scenario.getName();
            String map = "\u00e4a\u00c4A\u00f6o\u00d6O\u00fcu\u00dcU\u00dfs _(_)_[_]_{_}_<_>_|_$_%_&_/_\\_?_:_*_\"_";
            for (int i = 0; i < "\u00e4a\u00c4A\u00f6o\u00d6O\u00fcu\u00dcU\u00dfs _(_)_[_]_{_}_<_>_|_$_%_&_/_\\_?_:_*_\"_".length(); i += 2) {
                name = ((String)name).replace("\u00e4a\u00c4A\u00f6o\u00d6O\u00fcu\u00dcU\u00dfs _(_)_[_]_{_}_<_>_|_$_%_&_/_\\_?_:_*_\"_".charAt(i), "\u00e4a\u00c4A\u00f6o\u00d6O\u00fcu\u00dcU\u00dfs _(_)_[_]_{_}_<_>_|_$_%_&_/_\\_?_:_*_\"_".charAt(i + 1));
            }
            if (((String)name).length() > 100) {
                name = ((String)name).substring(0, 60) + UUID.nameUUIDFromBytes(((String)name).getBytes(StandardCharsets.UTF_8)).toString();
            }
            if (dataVariantIdx > 0) {
                name = (String)name + "_" + (dataVariantIdx + 1);
            }
            File logFile = Paths.get("target", "rbellogs", (String)name + ".html").toFile();
            FileUtils.writeStringToFile((File)logFile, (String)html, (Charset)StandardCharsets.UTF_8);
            Serenity.recordReportData().asEvidence().withTitle("RBellog " + (dataVariantIdx + 1)).downloadable().fromFile(logFile.toPath());
            log.info("Saved HTML report to " + logFile.getAbsolutePath());
        }
        catch (IOException e) {
            log.error("Unable to save rbel log for scenario " + scenario.getName());
        }
    }

    @Generated
    public static List<RbelElement> getValidatableRbelMessages() {
        return validatableRbelMessages;
    }
}

