/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.rbel;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.util.RbelPathExecutor;
import de.gematik.test.tiger.hooks.TigerTestHooks;
import de.gematik.test.tiger.lib.TigerLibraryException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.transform.Source;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.Diff;

public class RbelMessageValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelMessageValidator.class);
    protected RbelElement lastFilteredRequest;
    protected RbelElement lastResponse;
    private static final Map<String, Function<DiffBuilder, DiffBuilder>> diffOptionMap = new HashMap<String, Function<DiffBuilder, DiffBuilder>>();

    public List<RbelElement> getRbelMessages() {
        return TigerTestHooks.getValidatableRbelMessages();
    }

    public boolean doesPathOfMessageMatch(RbelElement req, String path) {
        try {
            URI uri = new URI(req.getFacet(RbelHttpRequestFacet.class).map(RbelHttpRequestFacet::getPath).map(RbelElement::getRawStringContent).orElse(""));
            return uri.getPath().equals(path) || uri.getPath().matches(path);
        }
        catch (URISyntaxException e) {
            return false;
        }
        catch (RuntimeException rte) {
            log.error("Probable error while parsing regex!", (Throwable)rte);
            return false;
        }
    }

    public void filterRequestsAndStoreInContext(String path, String rbelPath, String value) {
        this.filterGivenRequestsAndStoreInContext(path, rbelPath, value, this.getRbelMessages());
    }

    public void filterGivenRequestsAndStoreInContext(String path, String rbelPath, String value, List<RbelElement> msgs) {
        this.lastFilteredRequest = this.findRequestByDescription(path, rbelPath, value, msgs);
        try {
            Awaitility.await((String)"Waiting for matching response").atMost(5L, TimeUnit.SECONDS).pollInterval(100L, TimeUnit.MILLISECONDS).pollDelay(100L, TimeUnit.MILLISECONDS).until(() -> msgs.stream().filter(e -> e.hasFacet(RbelHttpResponseFacet.class)).filter(resp -> ((RbelHttpResponseFacet)resp.getFacetOrFail(RbelHttpResponseFacet.class)).getRequest() == this.lastFilteredRequest).peek(rbelElement -> {
                this.lastResponse = rbelElement;
            }).findAny().isPresent());
        }
        catch (ConditionTimeoutException cte) {
            throw new TigerLibraryException("Missing response message to filtered request!", new Object[]{cte});
        }
    }

    protected RbelElement findRequestByDescription(String path, String rbelPath, String value, List<RbelElement> msgs) {
        List candidateMessages = msgs.stream().filter(el -> el.hasFacet(RbelHttpRequestFacet.class)).filter(req -> this.doesPathOfMessageMatch((RbelElement)req, path)).collect(Collectors.toList());
        if (candidateMessages.isEmpty()) {
            this.printAllPathsOfMessages(msgs);
            if (rbelPath == null) {
                throw new AssertionError((Object)("No request with path '" + path + "' found in messages"));
            }
            throw new AssertionError((Object)("No request with path '" + path + "' and rbelPath '" + rbelPath + "' matching '" + value + "' found in messages"));
        }
        if (StringUtils.isEmpty((CharSequence)rbelPath)) {
            if (candidateMessages.size() > 1) {
                log.warn("Found more then one candidate message. Returning first message. This may not be deterministic!");
            }
            return (RbelElement)candidateMessages.get(0);
        }
        for (RbelElement candidateMessage : candidateMessages) {
            List pathExecutionResult = new RbelPathExecutor(candidateMessage, rbelPath).execute();
            if (pathExecutionResult.isEmpty()) continue;
            if (StringUtils.isEmpty((CharSequence)value)) {
                return candidateMessage;
            }
            if (pathExecutionResult.isEmpty() || !((RbelElement)pathExecutionResult.get(0)).getRawStringContent().equals(value) && !((RbelElement)pathExecutionResult.get(0)).getRawStringContent().matches(value)) continue;
            return candidateMessage;
        }
        throw new AssertionError((Object)("No request with path '" + path + "' and rbelPath '" + rbelPath + "' matching '" + value + "' found in messages"));
    }

    private void printAllPathsOfMessages(List<RbelElement> msgs) {
        log.info("Found the following messages: " + msgs.stream().map(msg -> msg.getFacet(RbelHttpRequestFacet.class)).filter(Optional::isPresent).map(Optional::get).map(RbelHttpRequestFacet::getPath).map(RbelElement::getRawStringContent).map(path -> "=>\t" + path).collect(Collectors.joining("\n")));
    }

    public void filterNextRequestAndStoreInContext(String path, String rbelPath, String value) {
        List<RbelElement> msgs = this.getRbelMessages();
        RbelElement prevRequest = this.getLastFilteredRequest();
        int idx = -1;
        for (int i = 0; i < msgs.size(); ++i) {
            if (msgs.get(i) != prevRequest) continue;
            idx = i;
            break;
        }
        this.filterGivenRequestsAndStoreInContext(path, rbelPath, value, new ArrayList<RbelElement>(msgs.subList(idx + 2, msgs.size())));
    }

    public void compareXMLStructure(String test, String oracle, List<Function<DiffBuilder, DiffBuilder>> diffOptions) {
        ArrayList diffs = new ArrayList();
        Source srcTest = Input.from((Object)test).build();
        Source srcOracle = Input.from((Object)oracle).build();
        DiffBuilder db = DiffBuilder.compare((Object)srcOracle).withTest((Object)srcTest);
        for (Function<DiffBuilder, DiffBuilder> src : diffOptions) {
            db = src.apply(db);
        }
        db = db.checkForSimilar();
        db.withDifferenceEvaluator((comparison, outcome) -> {
            if (outcome != ComparisonResult.EQUAL && (comparison.getType() == ComparisonType.NAMESPACE_URI || comparison.getType() == ComparisonType.NAMESPACE_PREFIX)) {
                return ComparisonResult.SIMILAR;
            }
            return outcome;
        });
        Diff diff = db.build();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)diff.hasDifferences()).withFailMessage("XML tree mismatch!\n" + diff, new Object[0])).isFalse();
    }

    public void compareXMLStructure(String test, String oracle) {
        this.compareXMLStructure(test, oracle, Collections.emptyList());
    }

    public void compareXMLStructure(String test, String oracle, String diffOptionCSV) {
        ArrayList<Function<DiffBuilder, DiffBuilder>> diffOptions = new ArrayList<Function<DiffBuilder, DiffBuilder>>();
        Arrays.stream(diffOptionCSV.split(",")).map(String::trim).forEach(srcClassId -> {
            Assertions.assertThat(diffOptionMap).containsKey(srcClassId);
            diffOptions.add(diffOptionMap.get(srcClassId));
        });
        this.compareXMLStructure(test, oracle, diffOptions);
    }

    public RbelElement findElemInLastResponse(String rbelPath) {
        try {
            List elems = this.lastResponse.findRbelPathMembers(rbelPath);
            ((ListAssert)Assertions.assertThat((List)elems).withFailMessage("No node matching path '" + rbelPath + "'!", new Object[0])).isNotEmpty();
            ((ListAssert)Assertions.assertThat((List)elems).withFailMessage("Expected exactly one match fpr path '" + rbelPath + "'!", new Object[0])).hasSize(1);
            return (RbelElement)elems.get(0);
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Unable to find element in last response for rbel path '" + rbelPath + "'"));
        }
    }

    @Generated
    public RbelElement getLastFilteredRequest() {
        return this.lastFilteredRequest;
    }

    @Generated
    public RbelElement getLastResponse() {
        return this.lastResponse;
    }

    static {
        diffOptionMap.put("nocomment", DiffBuilder::ignoreComments);
        diffOptionMap.put("txtignoreempty", DiffBuilder::ignoreElementContentWhitespace);
        diffOptionMap.put("txttrim", DiffBuilder::ignoreWhitespace);
        diffOptionMap.put("txtnormalize", DiffBuilder::normalizeWhitespace);
    }
}

