/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.proxy;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.test.tiger.lib.TigerLibraryException;
import de.gematik.test.tiger.proxy.IRbelMessageListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelMessageProvider
implements IRbelMessageListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelMessageProvider.class);
    private final List<RbelElement> messages = new ArrayList<RbelElement>();
    private long timeoutms = 5000L;
    private boolean wait = false;

    public void triggerNewReceivedMessage(RbelElement el) {
        this.messages.add(el);
        this.wait = false;
    }

    public void waitForMessage() {
        this.wait = true;
        long startms = System.currentTimeMillis();
        while (this.wait) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                log.warn("Interruption signaled");
                Thread.currentThread().interrupt();
            }
            if (System.currentTimeMillis() - startms <= this.timeoutms) continue;
            throw new TigerLibraryException("Timeout waiting for rbel message");
        }
    }

    public RbelElement pullMessage() {
        if (this.messages.isEmpty()) {
            this.waitForMessage();
        }
        RbelElement el = this.messages.get(0);
        this.messages.remove(0);
        return el;
    }

    public List<RbelElement> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public void startStep() {
        this.messages.clear();
        this.wait = false;
    }

    public void setTimeoutms(long timeout) {
        this.timeoutms = timeout;
    }
}

