/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.parser.model.gherkin;

import de.gematik.test.tiger.lib.parser.TestParserException;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class Step {
    public static final List<String> KEYWORDS = List.of("When", "Given", "Then", "And", "But", "Examples", "Wenn", "Angenommen", "Gegeben sei", "Gegeben seien", "Dann", "Und", "Aber", "Beispiele");
    private final String keyword;
    private final List<String> lines;

    public static Step fromLine(String line) {
        String kw = Step.getKeyword(line.trim());
        return KEYWORDS.stream().filter(keyword -> keyword.equals(kw)).map(keyword -> new Step((String)keyword, (List<String>)new ArrayList<String>(List.of(line)))).findFirst().orElseThrow(() -> new TestParserException("Unknown Step '" + kw + "'"));
    }

    public static String getKeyword(String line) {
        int colon;
        if ((line.startsWith("Example") || line.startsWith("Beispiele")) && (colon = line.indexOf(":")) != -1) {
            return line.substring(0, colon).replace(" ", "").replace("\t", "");
        }
        return StringUtils.substringBefore((String)line, (String)" ");
    }

    @ConstructorProperties(value={"keyword", "lines"})
    @Generated
    public Step(String keyword, List<String> lines) {
        this.keyword = keyword;
        this.lines = lines;
    }

    @Generated
    public String getKeyword() {
        return this.keyword;
    }

    @Generated
    public List<String> getLines() {
        return this.lines;
    }
}

