/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.writer.tree;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.writer.tree.RbelContentTreeNode;
import de.gematik.test.tiger.common.TokenSubstituteHelper;
import de.gematik.test.tiger.common.config.TigerConfigurationLoader;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import java.util.List;
import java.util.Optional;

public class RbelElementWrapperContentTreeNode
extends RbelContentTreeNode {
    public static RbelElementWrapperContentTreeNode constructFromRbelElement(RbelElement source, TigerConfigurationLoader conversionContext, TigerJexlContext jexlContext) {
        RbelElementWrapperContentTreeNode result = new RbelElementWrapperContentTreeNode();
        result.setContent(RbelElementWrapperContentTreeNode.tryToResolvePlaceholdersIfPresent(source, conversionContext, jexlContext));
        return result;
    }

    private static byte[] tryToResolvePlaceholdersIfPresent(RbelElement source, TigerConfigurationLoader conversionContext, TigerJexlContext jexlContext) {
        String substitutedString;
        String originalString = source.getRawStringContent();
        if (originalString.equals(substitutedString = TokenSubstituteHelper.substitute((String)originalString, (TigerConfigurationLoader)conversionContext, Optional.ofNullable(jexlContext)))) {
            return source.getRawContent();
        }
        return substitutedString.getBytes(source.getElementCharset());
    }

    public static RbelElementWrapperContentTreeNode constructFromValueElement(RbelElement source, TigerConfigurationLoader conversionContext, TigerJexlContext jexlContext) {
        RbelElementWrapperContentTreeNode result = new RbelElementWrapperContentTreeNode();
        result.setContent(TokenSubstituteHelper.substitute((String)source.printValue().orElseGet(source::getRawStringContent), (TigerConfigurationLoader)conversionContext, Optional.ofNullable(jexlContext)).getBytes());
        return result;
    }

    private RbelElementWrapperContentTreeNode() {
        super(new RbelMultiMap<RbelContentTreeNode>(), null);
    }

    @Override
    public List<RbelContentTreeNode> getChildNodes() {
        return List.of();
    }

    public String toString() {
        return "wrappernode:{<node child nodes>, content=" + new String(this.getContent()) + "}";
    }
}

