/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.writer.tree;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.util.RbelPathAble;
import de.gematik.rbellogger.util.RbelPathExecutor;
import de.gematik.rbellogger.writer.RbelContentTreeConverter;
import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.RbelSerializationException;
import de.gematik.rbellogger.writer.RbelSerializationResult;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.exceptions.GenericTigerException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class RbelContentTreeNode
extends RbelPathAble {
    private RbelMultiMap<RbelContentTreeNode> childNodes;
    private final Map<String, String> attributeMap = new HashMap<String, String>();
    private Charset charset;
    private String key;
    private RbelContentType type;
    private RbelContentTreeNode parentNode;
    private byte[] content;

    public RbelContentTreeNode(RbelMultiMap<RbelContentTreeNode> childNodes, byte[] content) {
        this.setContent(content);
        this.setupChildNodes(childNodes);
    }

    public void setRawStringContent(String newContent) {
        this.setContent(newContent.getBytes(this.charset != null ? this.charset : StandardCharsets.UTF_8));
    }

    public void setChildNodes(RbelMultiMap<RbelContentTreeNode> childNodes) {
        this.setupChildNodes(childNodes);
        this.updateAncestorContent();
    }

    public void setChildNodes(List<RbelContentTreeNode> childNodes) {
        this.setupChildNodes(childNodes);
        this.updateAncestorContent();
    }

    public void setupChildNodes(RbelMultiMap<RbelContentTreeNode> childNodes) {
        if (childNodes == null) {
            this.setChildNodes(new RbelMultiMap<RbelContentTreeNode>());
        } else {
            this.childNodes = childNodes;
            this.childNodes.getValues().forEach(e -> ((RbelContentTreeNode)e.getValue()).setParentNode(this));
        }
    }

    public void setupChildNodes(List<RbelContentTreeNode> newChildNodes) {
        this.childNodes.clear();
        newChildNodes.forEach(node -> {
            this.childNodes.put(node.getKey().orElseThrow(), (RbelContentTreeNode)node);
            node.setParentNode(this);
        });
    }

    public void addOrReplaceChild(String key, RbelContentTreeNode newChildNode) {
        this.addOrReplaceUniqueEntry(key, newChildNode);
        newChildNode.setParentNode(this);
        newChildNode.setKey(key);
        this.updateAncestorContent();
    }

    private void addOrReplaceUniqueEntry(String key, RbelContentTreeNode newChildNode) {
        List<RbelContentTreeNode> matchingEntries = this.childNodes.getAll(key);
        if (matchingEntries.size() > 1) {
            throw new UnsupportedOperationException("It was attempted to replace a unique key '%s', but multiple entries with that key existed.".formatted(key));
        }
        if (matchingEntries.size() == 1) {
            this.childNodes = this.childNodes.stream().map(e -> ((String)e.getKey()).equals(key) ? Pair.of((Object)key, (Object)newChildNode) : e).collect(RbelMultiMap.COLLECTOR);
        } else {
            this.childNodes.put(key, newChildNode);
        }
    }

    public void addChild(RbelContentTreeNode newChildNode) {
        if (!this.isListTypeNode()) {
            throw new IllegalArgumentException("The path specified must lead to an array or a list. Currently only JSON arrays are supported.");
        }
        int newIndex = 0;
        String indexAsString = "0";
        while (this.childNodes.containsKey(indexAsString)) {
            indexAsString = Integer.toString(++newIndex);
        }
        this.childNodes.put(indexAsString, newChildNode);
        newChildNode.setParentNode(this);
        newChildNode.setKey(indexAsString);
        this.updateAncestorContent();
    }

    public Map<String, String> attributes() {
        return this.attributeMap;
    }

    public Optional<Boolean> hasTypeOptional(RbelContentType typeToCheck) {
        return Optional.ofNullable(this.getType()).map(t -> t == typeToCheck);
    }

    @Override
    public RbelContentTreeNode getParentNode() {
        return this.parentNode;
    }

    public boolean isRootNode() {
        return this.parentNode == null;
    }

    public Optional<RbelPathAble> getFirst(String key) {
        return this.getChildNodesWithKey().stream().filter(entry -> ((String)entry.getKey()).equals(key)).map(Map.Entry::getValue).map(RbelPathAble.class::cast).findFirst();
    }

    public List<RbelContentTreeNode> getAll(String key) {
        return this.getChildNodesWithKey().stream().filter(entry -> ((String)entry.getKey()).equals(key)).map(Map.Entry::getValue).toList();
    }

    public List<RbelContentTreeNode> getChildNodes() {
        return this.childNodes.getValues().stream().map(Map.Entry::getValue).toList();
    }

    public RbelMultiMap<RbelContentTreeNode> getChildNodesWithKey() {
        return this.childNodes.getValues().stream().collect(RbelMultiMap.COLLECTOR);
    }

    public Optional<RbelContentTreeNode> findElement(String rbelPath) {
        List<RbelContentTreeNode> resultList = this.findRbelPathMembers(rbelPath);
        if (resultList.isEmpty()) {
            return Optional.empty();
        }
        if (resultList.size() == 1) {
            return Optional.of(resultList.get(0));
        }
        throw new RbelPathNotUniqueException("RbelPath '" + rbelPath + "' is not unique! Found " + resultList.size() + " elements, expected only one!");
    }

    public RbelContentTreeNode findRootElement() {
        RbelContentTreeNode result = this;
        RbelContentTreeNode newResult = result.getParentNode();
        while (newResult != null) {
            result = newResult;
            newResult = result.getParentNode();
        }
        return result;
    }

    public List<RbelContentTreeNode> findRbelPathMembers(String rbelPath) {
        return new RbelPathExecutor<RbelContentTreeNode>(this, rbelPath).execute();
    }

    @Override
    @Nullable
    public String getRawStringContent() {
        if (this.content == null) {
            return null;
        }
        return new String(this.content, this.getElementCharset());
    }

    public Optional<RbelContentTreeNode> childNode(String nodeKey) {
        return Optional.ofNullable(this.childNodes.get(nodeKey));
    }

    public Charset getElementCharset() {
        return Optional.ofNullable(this.charset).orElse(StandardCharsets.UTF_8);
    }

    @Override
    public Optional<String> getKey() {
        return Optional.ofNullable(this.key);
    }

    private void updateAncestorContent() {
        this.updateContent();
        if (this.parentNode != null) {
            this.parentNode.updateAncestorContent();
        }
    }

    private void updateContent() {
        if (this.type == RbelContentType.XML) {
            RbelContentTreeNode formerParent = this.parentNode;
            Optional<String> formerKey = this.getKey();
            RbelMultiMap<RbelContentTreeNode> asChildNodes = new RbelMultiMap<RbelContentTreeNode>();
            asChildNodes.put("root", this);
            ((RbelContentTreeNode)asChildNodes.get("root")).setKey("root");
            RbelContentTreeNode tempRootNode = new RbelContentTreeNode(asChildNodes, new byte[0]);
            tempRootNode.setType(RbelContentType.XML);
            String serialization = this.executeSerialisation(tempRootNode, formerParent != null);
            if (formerKey.isPresent()) {
                serialization = serialization.replaceFirst("root", formerKey.get());
                serialization = this.replaceLast(serialization, "root", formerKey.get());
            } else {
                serialization = serialization.replaceFirst("<root>", "");
                serialization = this.replaceLast(serialization, "</root>", "");
            }
            RbelElement updatedRbelElement = new RbelElement(serialization.getBytes(), null);
            RbelContentTreeNode updatedContentTreeNode = new RbelContentTreeConverter(updatedRbelElement, new TigerJexlContext()).convertToContentTree();
            this.content = updatedContentTreeNode.getContent();
            this.setParentNode(formerParent);
            if (formerKey.isPresent()) {
                this.setKey(formerKey.get());
                if (formerParent != null) {
                    formerParent.getChildNodesWithKey().put(formerKey.get(), this);
                }
            } else {
                this.setKey(null);
            }
        } else {
            String serialization = this.executeSerialisation(this, this.parentNode != null);
            RbelElement updatedRbelElement = new RbelElement(serialization.getBytes(), null);
            RbelContentTreeNode updatedContentTreeNode = new RbelContentTreeConverter(updatedRbelElement, new TigerJexlContext()).convertToContentTree();
            this.content = updatedContentTreeNode.getContent();
        }
    }

    private boolean isListTypeNode() {
        return this.attributeMap.containsKey("jsonArray");
    }

    private String replaceLast(String stringToModify, String replacedString, String replacement) {
        int lastIndex = stringToModify.lastIndexOf(replacedString);
        String firstPart = stringToModify.substring(0, lastIndex);
        String lastPart = stringToModify.substring(lastIndex + replacedString.length());
        return firstPart + replacement + lastPart;
    }

    private String executeSerialisation(RbelContentTreeNode node, boolean parentNodePresent) {
        RbelSerializationResult serializationResult = parentNodePresent ? new RbelWriter(RbelLogger.build().getRbelConverter()).renderNode(node, new TigerJexlContext()) : new RbelWriter(RbelLogger.build().getRbelConverter()).serialize(node, new TigerJexlContext());
        if (serializationResult == null) {
            throw new RbelSerializationException("Error when updating RbelContentTreeNode.");
        }
        String serialization = serializationResult.getContentAsString();
        if (serialization == null) {
            throw new RbelSerializationException("Error when updating RbelContentTreeNode.");
        }
        return serialization;
    }

    @Generated
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public RbelContentType getType() {
        return this.type;
    }

    @Generated
    public void setType(RbelContentType type) {
        this.type = type;
    }

    @Generated
    public void setParentNode(RbelContentTreeNode parentNode) {
        this.parentNode = parentNode;
    }

    @Generated
    public byte[] getContent() {
        return this.content;
    }

    @Generated
    public void setContent(byte[] content) {
        this.content = content;
    }

    private static class RbelPathNotUniqueException
    extends GenericTigerException {
        public RbelPathNotUniqueException(String s) {
            super(s);
        }
    }
}

