/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.writer;

import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.RbelSerializationException;
import de.gematik.rbellogger.writer.RbelSerializer;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.rbellogger.writer.tree.RbelContentTreeNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelXmlSerializer
implements RbelSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelXmlSerializer.class);

    @Override
    public byte[] render(RbelContentTreeNode treeRootNode, RbelWriter.RbelWriterInstance rbelWriter) {
        Document document = DocumentHelper.createDocument();
        for (RbelContentTreeNode childNode : treeRootNode.getChildNodes()) {
            this.addNode(childNode, (Branch)document, rbelWriter);
        }
        this.addEncodingInformationIfMissing(document, treeRootNode);
        return this.convertDocumentToString(document, false);
    }

    @Override
    public byte[] renderNode(RbelContentTreeNode treeRootNode, RbelWriter.RbelWriterInstance rbelWriter) {
        Document document = DocumentHelper.createDocument();
        for (RbelContentTreeNode childNode : treeRootNode.getChildNodes()) {
            this.addNode(childNode, (Branch)document, rbelWriter);
        }
        return this.convertDocumentToString(document, true);
    }

    private void addEncodingInformationIfMissing(Document document, RbelContentTreeNode treeRootNode) {
        if (StringUtils.isEmpty((CharSequence)document.getXMLEncoding())) {
            document.setXMLEncoding(treeRootNode.getElementCharset().displayName());
        }
    }

    private void addNode(RbelContentTreeNode treeNode, Branch parentBranch, RbelWriter.RbelWriterInstance rbelWriter) {
        String key;
        if (log.isTraceEnabled()) {
            log.trace("converting xml node '{}'", (Object)(treeNode.getContent() == null ? "<null>" : new String(treeNode.getContent(), treeNode.getElementCharset())));
        }
        if (!StringUtils.isEmpty((CharSequence)(key = treeNode.getKey().orElseThrow(() -> new RbelSerializationException("Could not find key for " + String.valueOf(treeNode)))))) {
            if (RbelXmlSerializer.isATextNode(treeNode, key)) {
                if (!(parentBranch instanceof Document)) {
                    parentBranch.add((Node)new DefaultText(new String(rbelWriter.renderTree(treeNode).getContent(), treeNode.getElementCharset())));
                }
            } else if (treeNode.attributes().containsKey("isXmlAttribute") && parentBranch instanceof Element) {
                Element element = (Element)parentBranch;
                element.addAttribute(key, rbelWriter.renderTree(treeNode).getContentAsString());
            } else if (treeNode.attributes().containsKey("isXmlNamespacePrefix") && parentBranch instanceof Element) {
                Element element = (Element)parentBranch;
                element.addNamespace(key, treeNode.getRawStringContent());
            } else {
                this.addXmlNode(treeNode, parentBranch, rbelWriter, key);
            }
        }
    }

    private void addXmlNode(RbelContentTreeNode treeNode, Branch parentBranch, RbelWriter.RbelWriterInstance rbelWriter, String key) {
        Element newElement = parentBranch.addElement(this.determineQualifiedName(treeNode, key));
        for (RbelContentTreeNode childNode : treeNode.getChildNodes()) {
            this.addNode(childNode, (Branch)newElement, rbelWriter);
        }
    }

    private static boolean isATextNode(RbelContentTreeNode treeNode, String key) {
        return "text".equals(key) && treeNode.hasTypeOptional(RbelContentType.XML).orElse(false) == false && !treeNode.attributes().containsKey("isXmlAttribute");
    }

    private QName determineQualifiedName(RbelContentTreeNode treeNode, String key) {
        if (treeNode.attributes().containsKey("namespaceUri")) {
            if (treeNode.attributes().containsKey("namespacePrefix")) {
                return DocumentHelper.createQName((String)key, (Namespace)Namespace.get((String)treeNode.attributes().get("namespacePrefix"), (String)treeNode.attributes().get("namespaceUri")));
            }
            return DocumentHelper.createQName((String)key, (Namespace)Namespace.get((String)treeNode.attributes().get("namespaceUri")));
        }
        return DocumentHelper.createQName((String)key);
    }

    private byte[] convertDocumentToString(Document document, boolean suppressDeclaration) throws IOException {
        StringWriter resultWriter = new StringWriter();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setSuppressDeclaration(suppressDeclaration);
        XMLWriter writer = new XMLWriter((Writer)resultWriter, format);
        writer.write(document);
        return resultWriter.toString().getBytes();
    }

    @Generated
    public RbelXmlSerializer() {
    }
}

