/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.writer;

import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.writer.RbelJsonSerializer;
import de.gematik.rbellogger.writer.RbelSerializationException;
import de.gematik.rbellogger.writer.RbelSerializer;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.rbellogger.writer.tree.RbelContentTreeNode;
import java.security.Key;
import java.util.Base64;
import java.util.Collection;
import java.util.Optional;
import javax.crypto.spec.SecretKeySpec;
import org.jose4j.jca.ProviderContext;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.lang.JoseException;

public class RbelJweSerializer
implements RbelSerializer {
    @Override
    public byte[] render(RbelContentTreeNode node, RbelWriter.RbelWriterInstance rbelWriter) {
        return this.renderToString(node, rbelWriter).getBytes();
    }

    @Override
    public byte[] renderNode(RbelContentTreeNode node, RbelWriter.RbelWriterInstance rbelWriter) {
        return this.render(node, rbelWriter);
    }

    public String renderToString(RbelContentTreeNode node, RbelWriter.RbelWriterInstance rbelWriter) {
        JsonWebEncryption jwe = new JsonWebEncryption();
        ProviderContext context = new ProviderContext();
        context.getGeneralProviderContext().setGeneralProvider("BC");
        jwe.setProviderContext(context);
        this.writeHeaderInJwe(node.childNode("header"), jwe, rbelWriter);
        jwe.setPlaintext(rbelWriter.renderTree(node.childNode("body").orElseThrow(() -> new RbelSerializationException("Could not find body-node needed for JWT serialization in node '" + String.valueOf(node.getKey()) + "'!"))).getContent());
        jwe.setKey(this.findSignerKey(node.childNode("encryptionInfo"), rbelWriter));
        try {
            return jwe.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new RbelSerializationException("Error writing into Jwt", (Exception)((Object)e));
        }
    }

    private Key findSignerKey(Optional<RbelContentTreeNode> signature, RbelWriter.RbelWriterInstance rbelWriter) {
        if (signature.isEmpty()) {
            throw new RbelSerializationException("Could not find signature-node needed for JWT serialization!");
        }
        return signature.get().childNode("decryptedUsingKeyWithId").map(RbelContentTreeNode::getRawStringContent).map(keyName -> rbelWriter.getRbelKeyManager().findKeyByName((String)keyName).or(() -> rbelWriter.getRbelKeyManager().findKeyByName("puk_" + keyName)).orElseThrow(() -> new RbelSerializationException("Could not find key named '" + keyName + "'!"))).map(RbelKey::getKey).or(() -> ((RbelContentTreeNode)signature.get()).childNode("decryptedUsingKey").map(RbelContentTreeNode::getRawStringContent).map(Base64.getUrlDecoder()::decode).map(keyBytes -> new SecretKeySpec((byte[])keyBytes, "AES"))).orElseThrow(() -> new RbelSerializationException("Unable to find key!"));
    }

    private void writeHeaderInJwe(Optional<RbelContentTreeNode> headers, JsonWebEncryption jwe, RbelWriter.RbelWriterInstance rbelWriter) {
        headers.map(RbelContentTreeNode::getChildNodes).stream().flatMap(Collection::stream).forEach(header -> {
            if (RbelJsonSerializer.isJsonArray(header)) {
                jwe.setHeader(header.getKey().orElseThrow(), header.getChildNodes().stream().map(childNode -> new String(rbelWriter.renderTree((RbelContentTreeNode)childNode).getContent(), childNode.getElementCharset())).toList());
            } else {
                jwe.setHeader(header.getKey().orElseThrow(), new String(rbelWriter.renderTree((RbelContentTreeNode)header).getContent(), header.getElementCharset()));
            }
        });
    }
}

