/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.writer;

import java.beans.ConstructorProperties;
import java.util.stream.Stream;
import lombok.Generated;

public enum RbelContentType {
    XML("application/xml", true),
    JSON("application/json", true),
    JWT("application/jwt", false),
    JWE("application/octet-stream", false),
    URL("text/plain", false),
    BEARER_TOKEN("text/plain", false);

    final String contentTypeString;
    final boolean isTransitive;

    public static RbelContentType seekValueFor(String rawValue) {
        String compareValue = rawValue.trim().toUpperCase();
        return Stream.of(RbelContentType.values()).filter(candidate -> candidate.name().equals(compareValue)).findFirst().orElseThrow(() -> new RuntimeException("Could not match content type '" + rawValue + "'!"));
    }

    @ConstructorProperties(value={"contentTypeString", "isTransitive"})
    @Generated
    private RbelContentType(String contentTypeString, boolean isTransitive) {
        this.contentTypeString = contentTypeString;
        this.isTransitive = isTransitive;
    }

    @Generated
    public String getContentTypeString() {
        return this.contentTypeString;
    }

    @Generated
    public boolean isTransitive() {
        return this.isTransitive;
    }
}

