/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import de.gematik.rbellogger.data.RbelMultiMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class RbelPathAble {
    public abstract Optional<? extends RbelPathAble> getFirst(String var1);

    public abstract RbelPathAble getParentNode();

    public abstract List<? extends RbelPathAble> getAll(String var1);

    public abstract List<? extends RbelPathAble> getChildNodes();

    public abstract RbelMultiMap<? extends RbelPathAble> getChildNodesWithKey();

    public abstract Optional<String> getKey();

    public abstract String getRawStringContent();

    public abstract List<? extends RbelPathAble> findRbelPathMembers(String var1);

    public List<RbelPathAble> descendToContentNodeIfAdvised() {
        return List.of(this);
    }

    public boolean shouldElementBeKeptInFinalResult() {
        return true;
    }

    public String findNodePath() {
        LinkedList keyList = new LinkedList();
        RbelPathAble currentNode = this;
        for (RbelPathAble parent = currentNode.getParentNode(); parent != null; parent = parent.getParentNode()) {
            currentNode.findKeyInParentElement().ifPresent(keyList::addFirst);
            currentNode = parent;
        }
        return String.join((CharSequence)".", keyList);
    }

    public Optional<String> findKeyInParentElement() {
        return Optional.ofNullable(this.getParentNode()).stream().map(RbelPathAble::getChildNodesWithKey).flatMap(RbelMultiMap::stream).filter(e -> e.getValue() == this).map(Map.Entry::getKey).findFirst();
    }
}

