/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelNestedFacet;
import de.gematik.rbellogger.data.core.RbelValueFacet;
import de.gematik.rbellogger.data.core.TracingMessagePairFacet;
import de.gematik.rbellogger.facets.http.RbelHttpHeaderFacet;
import de.gematik.rbellogger.facets.http.RbelHttpMessageFacet;
import de.gematik.rbellogger.facets.http.RbelHttpRequestFacet;
import de.gematik.rbellogger.facets.http.RbelHttpResponseFacet;
import de.gematik.rbellogger.facets.jackson.RbelJsonFacet;
import de.gematik.rbellogger.util.RbelPathAble;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class RbelContextDecorator {
    private static final int MAXIMUM_JEXL_ELEMENT_SIZE = 16000;
    public static final String CONTENT = "content";

    public static void buildJexlMapContext(Object element, Optional<String> key, TigerJexlContext mapContext) {
        Optional<RbelElement> parentElement = RbelContextDecorator.getParentElement(element);
        mapContext.put("parent", parentElement.orElse(null));
        Optional<RbelElement> message = RbelContextDecorator.findMessage(element);
        mapContext.put("message", message.map(RbelContextDecorator::convertToJexlMessage).orElse(null));
        if (element instanceof RbelElement) {
            RbelElement rbelElement = (RbelElement)element;
            mapContext.put(CONTENT, (Object)RbelContextDecorator.getMaxedOutContentOfElement(rbelElement));
            mapContext.put("charset", (Object)rbelElement.getElementCharset().displayName());
            mapContext.put("@", RbelContextDecorator.buildPositionDescriptor(rbelElement));
            mapContext.put("pos", RbelContextDecorator.buildPositionDescriptor(rbelElement));
        }
        Optional<RbelElement> requestMessage = RbelContextDecorator.tryToFindRequestMessage(element);
        Optional<JexlMessage> responseMessage = RbelContextDecorator.tryToFindResponseMessage(element).map(RbelContextDecorator::convertToJexlMessage);
        if (requestMessage.filter(msg -> message.isPresent()).map(msg -> message.get() == msg).orElse(false).booleanValue()) {
            mapContext.put("request", mapContext.get("message"));
            mapContext.put("response", responseMessage.orElse(null));
            mapContext.put("isRequest", (Object)true);
            mapContext.put("isResponse", (Object)false);
        } else {
            mapContext.put("request", requestMessage.map(RbelContextDecorator::convertToJexlMessage).orElse(null));
            mapContext.put("response", responseMessage.orElse(null));
            mapContext.put("isRequest", (Object)false);
            mapContext.put("isResponse", (Object)true);
        }
        mapContext.put("facets", Optional.ofNullable(element).filter(RbelElement.class::isInstance).map(RbelElement.class::cast).map(RbelElement::getFacets).stream().flatMap(Collection::stream).map(Object::getClass).map(Class::getSimpleName).collect(Collectors.toSet()));
        mapContext.put("key", key.or(() -> RbelContextDecorator.tryToFindKeyFromParentMap(element, parentElement)).orElse(null));
        mapContext.put("path", Optional.ofNullable(element).filter(RbelElement.class::isInstance).map(RbelElement.class::cast).map(RbelPathAble::findNodePath).orElse(null));
    }

    private static String getMaxedOutContentOfElement(RbelElement element) {
        if (element.getSize() < 16000L) {
            return element.getRawStringContent();
        }
        return "";
    }

    private static String getMaxedOutContentOfElement(String string) {
        return StringUtils.abbreviate((String)string, (int)16000);
    }

    private static Map<String, Object> buildPositionDescriptor(RbelElement element) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        element.getChildNodesWithKey().stream().forEach(entry -> {
            String key = RbelContextDecorator.buildKey((String)entry.getKey());
            if (((RbelElement)entry.getValue()).hasFacet(RbelJsonFacet.class) && ((RbelElement)entry.getValue()).hasFacet(RbelNestedFacet.class)) {
                result.put(key, RbelContextDecorator.getMaxedOutContentOfElement(((RbelElement)entry.getValue()).getFacetOrFail(RbelNestedFacet.class).getNestedElement()));
            } else if (((RbelElement)entry.getValue()).hasFacet(RbelValueFacet.class)) {
                Object value = ((RbelElement)entry.getValue()).getFacetOrFail(RbelValueFacet.class).getValue();
                if (value != null) {
                    result.put(key, RbelContextDecorator.getMaxedOutContentOfElement(value.toString()));
                } else {
                    result.put(key, null);
                }
            } else if (!((RbelElement)entry.getValue()).getChildNodes().isEmpty()) {
                result.put(key, RbelContextDecorator.buildPositionDescriptor((RbelElement)entry.getValue()));
            } else {
                result.put(key, RbelContextDecorator.getMaxedOutContentOfElement((RbelElement)entry.getValue()));
            }
        });
        return result;
    }

    private static String buildKey(String key) {
        boolean isPureInteger = true;
        try {
            Integer.parseInt(key);
        }
        catch (NumberFormatException e) {
            isPureInteger = false;
        }
        if (isPureInteger) {
            return "_" + key;
        }
        return key;
    }

    private static Optional<RbelElement> tryToFindRequestMessage(Object element) {
        if (!(element instanceof RbelElement)) {
            return Optional.empty();
        }
        Optional<RbelElement> message = RbelContextDecorator.findMessage(element);
        if (message.isEmpty()) {
            return Optional.empty();
        }
        return message.flatMap(msg -> msg.getFacet(TracingMessagePairFacet.class)).map(TracingMessagePairFacet::getRequest).or(() -> message.filter(msg -> msg.hasFacet(RbelHttpRequestFacet.class)));
    }

    private static Optional<RbelElement> tryToFindResponseMessage(Object element) {
        if (!(element instanceof RbelElement)) {
            return Optional.empty();
        }
        Optional<RbelElement> message = RbelContextDecorator.findMessage(element);
        if (message.isEmpty()) {
            return Optional.empty();
        }
        return message.flatMap(msg -> msg.getFacet(TracingMessagePairFacet.class)).map(TracingMessagePairFacet::getResponse).or(() -> message.filter(msg -> msg.hasFacet(RbelHttpResponseFacet.class)));
    }

    private static JexlMessage convertToJexlMessage(RbelElement element) {
        Optional<RbelElement> bodyOptional = element.getFirst("body").filter(el -> el.getSize() < 16000L);
        return JexlMessage.builder().request(element.getFacet(RbelHttpRequestFacet.class).isPresent()).response(element.getFacet(RbelHttpResponseFacet.class).isPresent()).method(element.getFacet(RbelHttpRequestFacet.class).map(RbelHttpRequestFacet::getMethod).map(RbelElement::getRawStringContent).orElse(null)).url(element.getFacet(RbelHttpRequestFacet.class).map(RbelHttpRequestFacet::getPath).map(RbelElement::getRawStringContent).orElse(null)).path(element.getFacet(RbelHttpRequestFacet.class).map(RbelHttpRequestFacet::getPath).map(RbelElement::getRawStringContent).flatMap(RbelContextDecorator::convertToUrlSafe).map(URI::getPath).orElse(null)).bodyAsString(bodyOptional.map(RbelElement::getRawStringContent).orElse(null)).body(bodyOptional.orElse(null)).statusCode(element.getFacet(RbelHttpResponseFacet.class).map(RbelHttpResponseFacet::getResponseCode).map(RbelElement::getRawStringContent).orElse(null)).headers(element.getFacet(RbelHttpMessageFacet.class).map(RbelHttpMessageFacet::getHeader).flatMap(el -> el.getFacet(RbelHttpHeaderFacet.class)).filter(RbelHttpHeaderFacet.class::isInstance).map(RbelHttpHeaderFacet.class::cast).map(RbelHttpHeaderFacet::entries).stream().flatMap(Collection::stream).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(e -> ((RbelElement)e.getValue()).getRawStringContent(), Collectors.toList())))).build();
    }

    private static Optional<URI> convertToUrlSafe(String rawUrl) {
        try {
            return Optional.of(new URI(rawUrl));
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }

    private static Optional<RbelElement> findMessage(Object element) {
        RbelElement ptr;
        if (!(element instanceof RbelElement)) {
            return Optional.empty();
        }
        for (ptr = (RbelElement)element; ptr.getParentNode() != null && ptr.getParentNode() != ptr; ptr = ptr.getParentNode()) {
        }
        if (ptr.hasFacet(RbelHttpMessageFacet.class) && ptr.getParentNode() == null) {
            return Optional.of(ptr);
        }
        return Optional.empty();
    }

    private static Optional<RbelElement> getParentElement(Object element) {
        return Optional.ofNullable(element).filter(RbelElement.class::isInstance).map(RbelElement.class::cast).map(RbelElement::getParentNode);
    }

    private static Optional<String> tryToFindKeyFromParentMap(Object element, Optional<RbelElement> parent) {
        return parent.stream().map(RbelElement::getChildNodesWithKey).flatMap(RbelMultiMap::stream).filter(entry -> entry.getValue() == element).map(Map.Entry::getKey).findFirst();
    }

    public static String forceStringConvert(RbelPathAble obj) {
        RbelElement rbelElement;
        if (obj.getFirst(CONTENT).isPresent()) {
            return obj.getFirst(CONTENT).map(RbelContextDecorator::forceStringConvert).orElse("");
        }
        if (obj instanceof RbelElement && (rbelElement = (RbelElement)obj).hasFacet(RbelValueFacet.class)) {
            Object value = rbelElement.getFacetOrFail(RbelValueFacet.class).getValue();
            if (value == null) {
                return "<null>";
            }
            return value.toString();
        }
        if (obj.getRawStringContent() != null) {
            return obj.getRawStringContent();
        }
        return "";
    }

    @Generated
    private RbelContextDecorator() {
    }

    public static class JexlMessage {
        public final String method;
        public final String url;
        public final String path;
        public final String statusCode;
        public final boolean request;
        public final boolean response;
        public final Map<String, List<String>> headers;
        public final String bodyAsString;
        public final RbelElement body;

        @ConstructorProperties(value={"method", "url", "path", "statusCode", "request", "response", "headers", "bodyAsString", "body"})
        @Generated
        JexlMessage(String method, String url, String path, String statusCode, boolean request, boolean response, Map<String, List<String>> headers, String bodyAsString, RbelElement body) {
            this.method = method;
            this.url = url;
            this.path = path;
            this.statusCode = statusCode;
            this.request = request;
            this.response = response;
            this.headers = headers;
            this.bodyAsString = bodyAsString;
            this.body = body;
        }

        @Generated
        public static JexlMessageBuilder builder() {
            return new JexlMessageBuilder();
        }

        @Generated
        public String getMethod() {
            return this.method;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public String getStatusCode() {
            return this.statusCode;
        }

        @Generated
        public boolean isRequest() {
            return this.request;
        }

        @Generated
        public boolean isResponse() {
            return this.response;
        }

        @Generated
        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        @Generated
        public String getBodyAsString() {
            return this.bodyAsString;
        }

        @Generated
        public RbelElement getBody() {
            return this.body;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JexlMessage)) {
                return false;
            }
            JexlMessage other = (JexlMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isRequest() != other.isRequest()) {
                return false;
            }
            if (this.isResponse() != other.isResponse()) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$statusCode = this.getStatusCode();
            String other$statusCode = other.getStatusCode();
            if (this$statusCode == null ? other$statusCode != null : !this$statusCode.equals(other$statusCode)) {
                return false;
            }
            Map<String, List<String>> this$headers = this.getHeaders();
            Map<String, List<String>> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            String this$bodyAsString = this.getBodyAsString();
            String other$bodyAsString = other.getBodyAsString();
            if (this$bodyAsString == null ? other$bodyAsString != null : !this$bodyAsString.equals(other$bodyAsString)) {
                return false;
            }
            RbelElement this$body = this.getBody();
            RbelElement other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JexlMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRequest() ? 79 : 97);
            result = result * 59 + (this.isResponse() ? 79 : 97);
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $statusCode = this.getStatusCode();
            result = result * 59 + ($statusCode == null ? 43 : $statusCode.hashCode());
            Map<String, List<String>> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            String $bodyAsString = this.getBodyAsString();
            result = result * 59 + ($bodyAsString == null ? 43 : $bodyAsString.hashCode());
            RbelElement $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RbelContextDecorator.JexlMessage(method=" + this.getMethod() + ", url=" + this.getUrl() + ", path=" + this.getPath() + ", statusCode=" + this.getStatusCode() + ", request=" + this.isRequest() + ", response=" + this.isResponse() + ", headers=" + String.valueOf(this.getHeaders()) + ", bodyAsString=" + this.getBodyAsString() + ", body=" + String.valueOf(this.getBody()) + ")";
        }

        @Generated
        public static class JexlMessageBuilder {
            @Generated
            private String method;
            @Generated
            private String url;
            @Generated
            private String path;
            @Generated
            private String statusCode;
            @Generated
            private boolean request;
            @Generated
            private boolean response;
            @Generated
            private Map<String, List<String>> headers;
            @Generated
            private String bodyAsString;
            @Generated
            private RbelElement body;

            @Generated
            JexlMessageBuilder() {
            }

            @Generated
            public JexlMessageBuilder method(String method) {
                this.method = method;
                return this;
            }

            @Generated
            public JexlMessageBuilder url(String url) {
                this.url = url;
                return this;
            }

            @Generated
            public JexlMessageBuilder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public JexlMessageBuilder statusCode(String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            @Generated
            public JexlMessageBuilder request(boolean request) {
                this.request = request;
                return this;
            }

            @Generated
            public JexlMessageBuilder response(boolean response) {
                this.response = response;
                return this;
            }

            @Generated
            public JexlMessageBuilder headers(Map<String, List<String>> headers) {
                this.headers = headers;
                return this;
            }

            @Generated
            public JexlMessageBuilder bodyAsString(String bodyAsString) {
                this.bodyAsString = bodyAsString;
                return this;
            }

            @Generated
            public JexlMessageBuilder body(RbelElement body) {
                this.body = body;
                return this;
            }

            @Generated
            public JexlMessage build() {
                return new JexlMessage(this.method, this.url, this.path, this.statusCode, this.request, this.response, this.headers, this.bodyAsString, this.body);
            }

            @Generated
            public String toString() {
                return "RbelContextDecorator.JexlMessage.JexlMessageBuilder(method=" + this.method + ", url=" + this.url + ", path=" + this.path + ", statusCode=" + this.statusCode + ", request=" + this.request + ", response=" + this.response + ", headers=" + String.valueOf(this.headers) + ", bodyAsString=" + this.bodyAsString + ", body=" + String.valueOf(this.body) + ")";
            }
        }
    }
}

