/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import de.gematik.rbellogger.util.RbelContent;
import de.gematik.rbellogger.util.RbelContentBase;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.builder.HashCodeBuilder;

class RbelContentSlice
extends RbelContent {
    private final RbelContentBase baseContent;
    private final int start;
    private int end;

    @Override
    public void truncate(int usedBytes) {
        if (usedBytes < 0 || usedBytes > this.size()) {
            throw new IllegalArgumentException(String.format("Invalid truncate size: %d, content size: %d", usedBytes, this.size()));
        }
        this.end = this.start + usedBytes;
    }

    @Override
    public int size() {
        return this.end - this.start;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isNull() {
        return this.baseContent.isNull();
    }

    @Override
    public byte[] toByteArray() {
        return this.baseContent.toByteArray(this.start, this.end);
    }

    private void checkRange(int from, int to) {
        RbelContentSlice.checkRange(from, to, this.size());
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(index);
        }
    }

    @Override
    public RbelContent subArray(int from, int to) {
        this.checkRange(from, to);
        if (from == 0 && to == this.size()) {
            return this;
        }
        return this.baseContent.subArrayWithoutChecks(from + this.start, to + this.start);
    }

    @Override
    public InputStream toInputStream() {
        return this.baseContent.toInputStream(this.start, this.end);
    }

    @Override
    public byte[] toByteArray(int from, int to) {
        this.checkRange(from, to);
        return this.baseContent.toByteArrayWithoutChecks(this.start + from, this.start + to);
    }

    @Override
    public byte get(int index) {
        this.checkIndex(index);
        return this.baseContent.getWithoutChecks(index + this.start);
    }

    @Override
    public int indexOf(byte o) {
        if (this.isEmpty()) {
            return -1;
        }
        return this.indexOf(o, 0);
    }

    @Override
    public int indexOf(byte o, int startIndex) {
        this.checkIndex(startIndex);
        return Math.max(-1, this.baseContent.indexOf(o, this.start + startIndex, this.end) - this.start);
    }

    @Override
    public int indexOf(byte[] searchContent) {
        return this.indexOf(searchContent, 0);
    }

    @Override
    public int indexOf(byte[] searchContent, int startIndex) {
        this.checkIndex(startIndex);
        return Math.max(-1, this.baseContent.indexOf(searchContent, this.start + startIndex, this.end) - this.start);
    }

    @Override
    public boolean startsWith(byte[] prefix) {
        if (this.isEmpty()) {
            return prefix.length == 0;
        }
        return this.startsWith(prefix, 0);
    }

    @Override
    public boolean startsWith(byte[] searchContent, int startIndex) {
        this.checkIndex(startIndex);
        return this.baseContent.startsWith(searchContent, this.start + startIndex);
    }

    @Override
    public boolean startsTrimmedWith(byte[] firstNonBlankBytes) {
        if (this.isEmpty()) {
            return firstNonBlankBytes.length == 0;
        }
        return this.startsTrimmedWith(firstNonBlankBytes, 0);
    }

    public boolean startsTrimmedWith(byte[] firstNonBlankBytes, int startIndex) {
        this.checkIndex(startIndex);
        return this.baseContent.startsTrimmedWith(firstNonBlankBytes, this.start + startIndex);
    }

    @Override
    public boolean startsTrimmedWithIgnoreCase(byte[] firstNonBlankBytes, Charset charset) {
        return this.startsTrimmedWithIgnoreCase(firstNonBlankBytes, charset, 0);
    }

    public boolean startsTrimmedWithIgnoreCase(byte[] firstNonBlankBytes, Charset charset, int startIndex) {
        this.checkIndex(startIndex);
        return this.baseContent.startsTrimmedWithIgnoreCase(firstNonBlankBytes, charset, this.start + startIndex);
    }

    @Override
    public boolean endsTrimmedWith(byte[] lastNonBlankBytes) {
        return this.endsTrimmedWith(lastNonBlankBytes, this.size());
    }

    public boolean endsTrimmedWith(byte[] lastNonBlankBytes, int endIndex) {
        this.checkRange(0, endIndex);
        return this.baseContent.endsTrimmedWith(lastNonBlankBytes, this.start + endIndex);
    }

    @Override
    public boolean endsTrimmedWithIgnoreCase(byte[] lastNonBlankBytes, Charset charset) {
        return this.endsTrimmedWithIgnoreCase(lastNonBlankBytes, charset, this.size());
    }

    public boolean endsTrimmedWithIgnoreCase(byte[] lastNonBlankBytes, Charset charset, int endIndex) {
        this.checkRange(0, endIndex);
        return this.baseContent.endsTrimmedWithIgnoreCase(lastNonBlankBytes, charset, this.start + endIndex);
    }

    @Override
    public boolean endsWith(byte[] postfix) {
        return this.endsWith(postfix, this.size());
    }

    public boolean endsWith(byte[] postfix, int endIndex) {
        this.checkRange(0, endIndex);
        return this.baseContent.endsWith(postfix, this.start + endIndex);
    }

    @Override
    public int countOccurrencesUpTo(byte toBeFound, int maxAllowedCount) {
        return this.baseContent.countOccurrencesUpTo(toBeFound, maxAllowedCount, this.start, this.end);
    }

    @Override
    public boolean contains(byte[] searchContent) {
        return this.baseContent.indexOf(searchContent, this.start, this.end) >= 0;
    }

    @Override
    public int getChunkSize() {
        return this.baseContent.getChunkSize();
    }

    @Override
    public List<RbelContent> split(byte[] delimiter) {
        return this.baseContent.split(delimiter, this.start, this.end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RbelContent)) {
            return false;
        }
        RbelContent that = (RbelContent)o;
        if (this.size() != that.size()) {
            return false;
        }
        return Arrays.equals(this.toByteArray(), that.toByteArray());
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.size()).append(this.toByteArray()).toHashCode();
    }

    public String toString() {
        return "RbelContentSlice{start=" + this.start + ", end=" + this.end + "}:" + this.toReadableString();
    }

    @ConstructorProperties(value={"baseContent", "start", "end"})
    @Generated
    public RbelContentSlice(RbelContentBase baseContent, int start, int end) {
        this.baseContent = baseContent;
        this.start = start;
        this.end = end;
    }

    @Override
    @Generated
    public RbelContentBase getBaseContent() {
        return this.baseContent;
    }
}

