/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import com.google.common.base.Preconditions;
import de.gematik.rbellogger.util.RbelContent;
import de.gematik.rbellogger.util.RbelContentSlice;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.tuple.Pair;

class RbelContentBase
extends RbelContent {
    private static final int DEFAULT_CHUNK_SIZE = 8192;
    private final int chunkSize;
    private int size = 0;
    @Nullable
    private ArrayList<byte[]> chunks;
    private WeakReference<byte[]> cachedByteArray = new WeakReference<Object>(null);

    public static RbelContentBase of(byte[] content) {
        return RbelContent.builder().content(content != null ? List.of(content) : null).build();
    }

    public static RbelContentBase of(List<RbelContent> contents) {
        RbelContentBase result = RbelContent.builder().build();
        for (RbelContent content : contents) {
            result.append(content);
        }
        return result;
    }

    public static RbelContentBase from(InputStream stream) throws IOException {
        byte[] bytes;
        RbelContentBase result = RbelContent.builder().build();
        do {
            bytes = stream.readNBytes(8192);
            result.append(bytes);
        } while (bytes.length >= 8192);
        return result;
    }

    private RbelContentBase(@Nullable Integer chunkSize, @Nullable Collection<byte[]> content) {
        int n = this.chunkSize = chunkSize == null ? 8192 : chunkSize;
        if (this.chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize must be positive");
        }
        if (content != null) {
            int length = 0;
            for (byte[] chunk : content) {
                length += chunk.length;
            }
            this.appendContent(content, length);
        }
    }

    @Override
    public void truncate(int size) {
        if (size < 0 || size > this.size) {
            throw new IndexOutOfBoundsException(MessageFormat.format("Invalid size: {0}, current size: {1}", size, this.size));
        }
        this.size = size;
        this.deleteWeakReferences();
    }

    private byte[] getChunk(int index) {
        assert (this.chunks != null);
        return this.chunks.get(index / this.chunkSize);
    }

    private int getIndexInChunk(int index) {
        return index % this.chunkSize;
    }

    private int getBeginIndexOfChunkContaining(int i) {
        return i - this.getIndexInChunk(i);
    }

    public boolean add(byte aByte) {
        int chunkIndex = this.getIndexInChunk(this.size);
        if (chunkIndex == 0) {
            lastChunk = new byte[this.chunkSize];
            if (this.chunks == null) {
                this.chunks = new ArrayList();
            }
            this.chunks.add(lastChunk);
        } else {
            assert (this.chunks != null);
            assert (this.size > 0);
            lastChunk = this.chunks.get(this.chunks.size() - 1);
            if (chunkIndex >= lastChunk.length) {
                byte[] newChunk = new byte[this.chunkSize];
                System.arraycopy(lastChunk, 0, newChunk, 0, lastChunk.length);
                this.chunks.set(this.chunks.size() - 1, newChunk);
                lastChunk = newChunk;
            }
        }
        lastChunk[chunkIndex] = aByte;
        ++this.size;
        this.deleteWeakReferences();
        return true;
    }

    private void deleteWeakReferences() {
        if (this.cachedByteArray.get() != null) {
            this.cachedByteArray = new WeakReference<Object>(null);
        }
    }

    public void append(byte[] array) {
        if (this.chunks == null) {
            this.chunks = new ArrayList();
        }
        if (this.size % this.chunkSize == 0 && array.length <= this.chunkSize) {
            this.chunks.add(array);
            this.size += array.length;
        } else {
            int copyLength;
            for (int i = 0; i < array.length; i += copyLength) {
                byte[] chunk;
                int targetIndexInChunk = this.getIndexInChunk(this.size);
                copyLength = Math.min(this.chunkSize - targetIndexInChunk, array.length - i);
                if (targetIndexInChunk == 0) {
                    byte[] newChunk = new byte[copyLength];
                    this.chunks.add(newChunk);
                    chunk = newChunk;
                } else {
                    chunk = this.getChunk(this.size);
                    if (chunk.length < this.chunkSize) {
                        byte[] newLastChunk = new byte[this.chunkSize];
                        System.arraycopy(chunk, 0, newLastChunk, 0, targetIndexInChunk);
                        this.chunks.set(this.chunks.size() - 1, newLastChunk);
                        chunk = newLastChunk;
                    }
                }
                System.arraycopy(array, i, chunk, targetIndexInChunk, copyLength);
                this.size += copyLength;
            }
        }
        this.deleteWeakReferences();
    }

    public void append(RbelContent content) {
        if (content instanceof RbelContentBase) {
            RbelContentBase contentBase = (RbelContentBase)content;
            this.appendContent(contentBase.getChunks(), content.size());
        } else {
            this.append(content.toByteArray());
        }
    }

    private void appendContent(Collection<byte[]> arrays, int bytesToAppend) {
        if (arrays != null && bytesToAppend >= 0) {
            int copied = 0;
            for (byte[] array : arrays) {
                byte[] appended;
                if (copied + array.length <= bytesToAppend) {
                    appended = array;
                } else {
                    appended = new byte[bytesToAppend - copied];
                    System.arraycopy(array, 0, appended, 0, appended.length);
                }
                this.append(appended);
                copied += appended.length;
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public RbelContentBase getBaseContent() {
        return this;
    }

    @Override
    public List<RbelContent> split(byte[] delimiter) {
        return this.split(delimiter, 0, this.size);
    }

    public List<RbelContent> split(byte[] delimiter, int start, int end) {
        int foundIndex;
        ArrayList<RbelContent> parts = new ArrayList<RbelContent>();
        int nextStart = start;
        while (nextStart + delimiter.length <= end && (foundIndex = this.indexOf(delimiter, nextStart)) >= 0) {
            RbelContent part = this.subArray(nextStart, foundIndex + delimiter.length);
            parts.add(part);
            nextStart = foundIndex + delimiter.length;
        }
        if (nextStart < end) {
            RbelContent part = this.subArray(nextStart, end);
            parts.add(part);
        }
        return parts;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean isNull() {
        return this.chunks == null;
    }

    @Override
    public byte[] toByteArray() {
        byte[] byteArray = (byte[])this.cachedByteArray.get();
        if (byteArray == null) {
            byteArray = this.toByteArrayWithoutChecks(0, this.size);
            this.cachedByteArray = new WeakReference<byte[]>(byteArray);
        }
        return byteArray;
    }

    @Override
    public InputStream toInputStream() {
        return this.toInputStream(0, this.size);
    }

    public InputStream toInputStream(int start, int end) {
        BoundedInputStream result = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){
            final Iterator<byte[]> iterator;
            {
                this.iterator = RbelContentBase.this.chunks != null ? RbelContentBase.this.chunks.iterator() : Collections.emptyIterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public InputStream nextElement() {
                return new ByteArrayInputStream(this.iterator.next());
            }
        }))).setMaxCount((long)end)).get();
        for (long skipped = result.skip((long)start); skipped < (long)start; skipped += result.skip((long)start - skipped)) {
        }
        return result;
    }

    @Override
    public byte[] toByteArray(int from, int to) {
        this.checkRange(from, to);
        return this.toByteArrayWithoutChecks(from, to);
    }

    private void checkRange(int from, int to) {
        RbelContentBase.checkRange(from, to, this.size);
    }

    @Override
    public RbelContent subArray(int from, int to) {
        this.checkRange(from, to);
        return this.subArrayWithoutChecks(from, to);
    }

    RbelContent subArrayWithoutChecks(int from, int to) {
        if (from == 0 && to == this.size) {
            return this;
        }
        return new RbelContentSlice(this, from, to);
    }

    byte[] toByteArrayWithoutChecks(int from, int to) {
        if (from % this.chunkSize == 0 && from < this.size) {
            assert (this.chunks != null);
            byte[] chunk = this.chunks.get(from / this.chunkSize);
            if (chunk.length == to - from) {
                return chunk;
            }
        }
        byte[] result = new byte[to - from];
        int filled = 0;
        while (from < to) {
            byte[] currentChunk = this.getChunk(from);
            int indexInChunk = this.getIndexInChunk(from);
            int restLength = (to - 1) / this.chunkSize == from / this.chunkSize ? this.getIndexInChunk(to - 1) + 1 - indexInChunk : this.chunkSize - indexInChunk;
            System.arraycopy(currentChunk, indexInChunk, result, filled, restLength);
            filled += restLength;
            from += restLength;
        }
        return result;
    }

    @Override
    public byte get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.getWithoutChecks(index);
    }

    byte getWithoutChecks(int index) {
        return this.getChunk(index)[this.getIndexInChunk(index)];
    }

    @Override
    public int indexOf(byte b) {
        return this.indexOf(b, 0);
    }

    @Override
    public int indexOf(byte b, int startIndex) {
        return this.indexOf(b, startIndex, this.size);
    }

    public int indexOf(byte b, int startIndex, int endIndex) {
        int i = startIndex;
        while (i < endIndex) {
            byte[] chunk = this.getChunk(i);
            int foundIndexInChunk = ArrayUtils.indexOf((byte[])chunk, (byte)b, (int)this.getIndexInChunk(i));
            int beginOfChunk = this.getBeginIndexOfChunkContaining(i);
            if (foundIndexInChunk >= 0) {
                int result = beginOfChunk + foundIndexInChunk;
                if (result < endIndex) {
                    return result;
                }
                return -1;
            }
            i = beginOfChunk + chunk.length;
        }
        return -1;
    }

    @Override
    public int indexOf(byte[] searchContent) {
        return this.indexOf(searchContent, 0);
    }

    @Override
    public int indexOf(byte[] searchContent, int startIndex) {
        return this.indexOf(searchContent, startIndex, this.size);
    }

    public int indexOf(byte[] searchContent, int startIndex, int endIndex) {
        Preconditions.checkNotNull((Object)searchContent, (Object)"searchContent");
        if (searchContent.length == 0) {
            return startIndex;
        }
        int i = startIndex;
        while (i + searchContent.length <= endIndex) {
            int possibleStartIndex = this.indexOf(searchContent[0], i, endIndex);
            if (possibleStartIndex < 0 || possibleStartIndex + searchContent.length > endIndex) {
                return -1;
            }
            if (searchContent.length == 1 || this.startsWith(searchContent, possibleStartIndex)) {
                return possibleStartIndex;
            }
            i = possibleStartIndex + 1;
        }
        return -1;
    }

    public int lastIndexOf(byte o, int endIndex) {
        int i = endIndex - 1;
        while (i >= 0) {
            byte[] chunk = this.getChunk(i);
            int foundIndex = ArrayUtils.lastIndexOf((byte[])chunk, (byte)o, (int)this.getIndexInChunk(i));
            int beginOfChunk = this.getBeginIndexOfChunkContaining(i);
            if (foundIndex >= 0) {
                return beginOfChunk + foundIndex;
            }
            i = beginOfChunk - 1;
        }
        return -1;
    }

    @Override
    public boolean startsWith(byte[] prefix) {
        if (prefix == null) {
            return false;
        }
        int prefixLength = prefix.length;
        if (prefix.length > this.size) {
            return false;
        }
        for (int i = 0; i < prefixLength; ++i) {
            if (this.getWithoutChecks(i) == prefix[i]) continue;
            return false;
        }
        return true;
    }

    private boolean startsWithIgnoreCaseWithoutChecks(Pair<byte[], Charset> prefix, int startInclusive) {
        byte[] prefixBytes = (byte[])prefix.getLeft();
        if (startInclusive + prefixBytes.length <= this.size) {
            Charset charset = (Charset)prefix.getRight();
            String prefixString = new String(prefixBytes, charset);
            byte[] start = new byte[prefixBytes.length];
            for (int i = 0; i < start.length; ++i) {
                start[i] = this.getWithoutChecks(startInclusive + i);
            }
            return new String(start, charset).equalsIgnoreCase(prefixString);
        }
        return false;
    }

    @Override
    public boolean startsWith(byte[] searchContent, int startIndex) {
        int j = 0;
        int k = startIndex;
        while (j < searchContent.length) {
            if (this.getWithoutChecks(k) != searchContent[j]) {
                return false;
            }
            ++j;
            ++k;
        }
        return true;
    }

    @Override
    public boolean startsTrimmedWith(byte[] firstNonBlankBytes) {
        return this.startsTrimmedWith(firstNonBlankBytes, 0);
    }

    public boolean startsTrimmedWith(byte[] firstNonBlankBytes, int startIndex) {
        return this.startsTrimmedWith(firstNonBlankBytes, null, startIndex, (pair, start) -> this.startsWith((byte[])pair.getLeft(), (int)start));
    }

    @Override
    public boolean startsTrimmedWithIgnoreCase(byte[] firstNonBlankBytes, Charset charset) {
        return this.startsTrimmedWithIgnoreCase(firstNonBlankBytes, charset, 0);
    }

    public boolean startsTrimmedWithIgnoreCase(byte[] firstNonBlankBytes, Charset charset, int startIndex) {
        return this.startsTrimmedWith(firstNonBlankBytes, charset, startIndex, this::startsWithIgnoreCaseWithoutChecks);
    }

    private boolean startsTrimmedWith(byte[] firstNonBlankBytes, Charset charset, int startIndex, BiPredicate<Pair<byte[], Charset>, Integer> doesArrayAtOffsetStartWith) {
        for (int i = startIndex; i < this.size; ++i) {
            if (Character.isWhitespace(this.getWithoutChecks(i))) continue;
            if (i + firstNonBlankBytes.length > this.size) {
                return false;
            }
            return doesArrayAtOffsetStartWith.test((Pair<byte[], Charset>)Pair.of((Object)firstNonBlankBytes, (Object)charset), i);
        }
        return false;
    }

    @Override
    public boolean endsTrimmedWith(byte[] lastNonBlankBytes) {
        return this.endsTrimmedWith(lastNonBlankBytes, this.size);
    }

    public boolean endsTrimmedWith(byte[] lastNonBlankBytes, int endIndexExclusive) {
        return this.endsTrimmedWith(lastNonBlankBytes, null, endIndexExclusive, (pair, index) -> this.endsWith((byte[])pair.getLeft(), (int)index));
    }

    @Override
    public boolean endsTrimmedWithIgnoreCase(byte[] lastNonBlankBytes, Charset charset) {
        return this.endsTrimmedWithIgnoreCase(lastNonBlankBytes, charset, this.size);
    }

    public boolean endsTrimmedWithIgnoreCase(byte[] lastNonBlankBytes, Charset charset, int endIndex) {
        return this.endsTrimmedWith(lastNonBlankBytes, charset, endIndex, this::endsWithIgnoreCaseWithoutChecks);
    }

    private boolean endsTrimmedWith(byte[] lastNonBlankBytes, Charset charset, int endIndexExclusive, BiPredicate<Pair<byte[], Charset>, Integer> doesArrayAtOffsetEndWith) {
        for (int i = endIndexExclusive - 1; i >= 0; --i) {
            if (Character.isWhitespace(this.getWithoutChecks(i))) continue;
            int beginIndex = i - lastNonBlankBytes.length + 1;
            if (beginIndex < 0) {
                return false;
            }
            return doesArrayAtOffsetEndWith.test((Pair<byte[], Charset>)Pair.of((Object)lastNonBlankBytes, (Object)charset), i + 1);
        }
        return false;
    }

    @Override
    public boolean endsWith(byte[] postfix) {
        return this.endsWith(postfix, this.size);
    }

    public boolean endsWith(byte[] postfix, int endIndexExclusive) {
        if (postfix.length > endIndexExclusive) {
            return false;
        }
        int postfixIndex = postfix.length - 1;
        int contentIndex = endIndexExclusive - 1;
        while (postfixIndex >= 0) {
            if (postfix[postfixIndex] != this.getWithoutChecks(contentIndex)) {
                return false;
            }
            --postfixIndex;
            --contentIndex;
        }
        return true;
    }

    private boolean endsWithIgnoreCaseWithoutChecks(Pair<byte[], Charset> suffix, int endExclusive) {
        byte[] suffixBytes = (byte[])suffix.getLeft();
        if (endExclusive - suffixBytes.length >= 0) {
            Charset charset = (Charset)suffix.getRight();
            String suffixString = new String(suffixBytes, charset);
            byte[] end = new byte[suffixBytes.length];
            for (int i = 0; i < end.length; ++i) {
                end[i] = this.getWithoutChecks(endExclusive - end.length + i);
            }
            return new String(end, charset).equalsIgnoreCase(suffixString);
        }
        return false;
    }

    @Override
    public int countOccurrencesUpTo(byte toBeFound, int maxAllowedCount) {
        return this.countOccurrencesUpTo(toBeFound, maxAllowedCount, 0, this.size);
    }

    public int countOccurrencesUpTo(byte toBeFound, int maxAllowedCount, int start, int end) {
        int foundCount = 0;
        int searchIndex = start;
        while (searchIndex < end) {
            int nextFoundIndex = this.indexOf(toBeFound, searchIndex, end);
            if (nextFoundIndex < 0) {
                return foundCount;
            }
            if (++foundCount == maxAllowedCount) {
                return foundCount;
            }
            searchIndex = nextFoundIndex + 1;
        }
        return foundCount;
    }

    @Override
    public boolean contains(byte[] searchContent) {
        return this.indexOf(searchContent) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RbelContent)) {
            return false;
        }
        RbelContent that = (RbelContent)o;
        if (this.size() != that.size()) {
            return false;
        }
        return Arrays.equals(this.toByteArray(), that.toByteArray());
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.size).append(this.toByteArray()).toHashCode();
    }

    public String toString() {
        return "RbelContentBase{size=" + this.size + "}:" + this.toReadableString();
    }

    @Generated
    public static RbelContentBaseBuilder builder() {
        return new RbelContentBaseBuilder();
    }

    @Override
    @Generated
    public int getChunkSize() {
        return this.chunkSize;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Nullable
    @Generated
    public ArrayList<byte[]> getChunks() {
        return this.chunks;
    }

    @Generated
    public WeakReference<byte[]> getCachedByteArray() {
        return this.cachedByteArray;
    }

    @Generated
    public static class RbelContentBaseBuilder {
        @Generated
        private Integer chunkSize;
        @Generated
        private Collection<byte[]> content;

        @Generated
        RbelContentBaseBuilder() {
        }

        @Generated
        public RbelContentBaseBuilder chunkSize(@Nullable Integer chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        @Generated
        public RbelContentBaseBuilder content(@Nullable Collection<byte[]> content) {
            this.content = content;
            return this;
        }

        @Generated
        public RbelContentBase build() {
            return new RbelContentBase(this.chunkSize, this.content);
        }

        @Generated
        public String toString() {
            return "RbelContentBase.RbelContentBaseBuilder(chunkSize=" + this.chunkSize + ", content=" + String.valueOf(this.content) + ")";
        }
    }
}

