/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import de.gematik.rbellogger.util.RbelContentBase;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.Nullable;

public abstract class RbelContent {
    public static RbelContent of(@Nullable byte[] content) {
        return RbelContentBase.of(content);
    }

    public static RbelContent of(List<RbelContent> content) {
        return RbelContentBase.of(content);
    }

    public static RbelContent from(InputStream stream) throws IOException {
        return RbelContentBase.from(stream);
    }

    public static RbelContentBase.RbelContentBaseBuilder builder() {
        return RbelContentBase.builder();
    }

    static void checkRange(int from, int to, int size) {
        if (from < 0 || from > size) {
            throw new IndexOutOfBoundsException(MessageFormat.format("from: {0}", from));
        }
        if (to < 0 || to > size) {
            throw new IndexOutOfBoundsException(MessageFormat.format("to: {0}", to));
        }
        if (to < from) {
            throw new IndexOutOfBoundsException(MessageFormat.format("from: {0}, to: {1}", from, to));
        }
    }

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract boolean isNull();

    public abstract byte[] toByteArray();

    public abstract InputStream toInputStream();

    public byte[] toByteArray(int from, int to) {
        return this.subArray(from, to).toByteArray();
    }

    public abstract RbelContent subArray(int var1, int var2);

    public abstract byte get(int var1);

    public abstract int indexOf(byte var1);

    public abstract int indexOf(byte var1, int var2);

    public abstract int indexOf(byte[] var1);

    public abstract int indexOf(byte[] var1, int var2);

    public abstract boolean startsWith(byte[] var1);

    public abstract boolean startsWith(byte[] var1, int var2);

    public abstract boolean endsWith(byte[] var1);

    public abstract boolean startsTrimmedWith(byte[] var1);

    public abstract boolean endsTrimmedWith(byte[] var1);

    public abstract boolean startsTrimmedWithIgnoreCase(byte[] var1, Charset var2);

    public abstract boolean endsTrimmedWithIgnoreCase(byte[] var1, Charset var2);

    public abstract int countOccurrencesUpTo(byte var1, int var2);

    public abstract int getChunkSize();

    public RbelContentBase getBaseContent() {
        return (RbelContentBase)this;
    }

    public abstract List<RbelContent> split(byte[] var1);

    public abstract boolean contains(byte[] var1);

    public abstract void truncate(int var1);

    public String toReadableString() {
        return new String(this.toByteArray(), StandardCharsets.UTF_8);
    }
}

